/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;

public abstract class DependencyOrderer<T> {
    private Map<T, Dependencies<T>> unorderedObjects = null;

    public void addObject(T obj) {
        if (this.unorderedObjects == null) {
            this.unorderedObjects = Maps.map();
        }
        this.unorderedObjects.put(obj, null);
    }

    public List<T> computeOrder(Collection<T> objects) {
        return this.computeOrder(objects, true);
    }

    public List<T> computeOrder(Collection<T> objects, boolean restrict) {
        if (this.unorderedObjects == null) {
            int size = objects.size();
            this.unorderedObjects = Maps.mapc(size);
        }
        for (T object : objects) {
            this.unorderedObjects.put(object, null);
        }
        return this.computeOrder(restrict);
    }

    public List<T> computeOrder() {
        return this.computeOrder(true);
    }

    public List<T> computeOrder(boolean restrict) {
        if (this.unorderedObjects == null) {
            return Collections.EMPTY_LIST;
        }
        this.setDirectDependencies(restrict);
        List orderedObjects = Lists.listc(this.unorderedObjects.size());
        while (!this.unorderedObjects.isEmpty()) {
            boolean progress = false;
            Iterator<Map.Entry<T, Dependencies<T>>> iter = this.unorderedObjects.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<T, Dependencies<T>> entry = iter.next();
                T object = entry.getKey();
                Dependencies dependencies = entry.getValue();
                dependencies.updateIndex(orderedObjects);
                if (!dependencies.isEmpty()) continue;
                orderedObjects.add(object);
                iter.remove();
                progress = true;
            }
            if (progress) continue;
            return null;
        }
        return orderedObjects;
    }

    public List<T> getCycle() {
        T obj;
        int cycleStart;
        Assert.check(this.unorderedObjects != null && !this.unorderedObjects.isEmpty());
        List dependencyChain = Lists.list();
        Map chainIndex = Maps.map();
        while ((cycleStart = this.cycleTest(obj = this.unorderedObjects.keySet().iterator().next(), dependencyChain, chainIndex)) < 0) {
        }
        return dependencyChain.subList(cycleStart, dependencyChain.size());
    }

    private int cycleTest(T obj, List<T> dependencyChain, Map<T, Integer> chainIndex) {
        Integer cycleIndex = chainIndex.get(obj);
        if (cycleIndex != null) {
            return cycleIndex;
        }
        int idx = dependencyChain.size();
        dependencyChain.add(obj);
        chainIndex.put(obj, idx);
        Dependencies<T> deps = this.unorderedObjects.get(obj);
        for (Object dep : deps.directDependencies) {
            int cycleStart;
            if (!this.unorderedObjects.containsKey(dep) || (cycleStart = this.cycleTest(dep, dependencyChain, chainIndex)) < 0) continue;
            return cycleStart;
        }
        dependencyChain.remove(idx);
        chainIndex.remove(obj);
        this.unorderedObjects.remove(obj);
        return -1;
    }

    private void setDirectDependencies(boolean restrict) {
        if (restrict) {
            for (T obj : this.unorderedObjects.keySet()) {
                Set<T> directDeps = this.findDirectDependencies(obj);
                directDeps.retainAll(this.unorderedObjects.keySet());
                this.unorderedObjects.put(obj, new Dependencies<T>(directDeps));
            }
        } else {
            List objs = Lists.set2list(this.unorderedObjects.keySet());
            int i = 0;
            while (i < objs.size()) {
                Object obj = objs.get(i);
                Set directDeps = this.findDirectDependencies(obj);
                for (Object dep : directDeps) {
                    if (this.unorderedObjects.containsKey(dep)) continue;
                    this.unorderedObjects.put(dep, null);
                    objs.add(dep);
                }
                this.unorderedObjects.put(obj, new Dependencies(directDeps));
                ++i;
            }
        }
    }

    protected abstract Set<T> findDirectDependencies(T var1);

    private static class Dependencies<T> {
        public Set<T> directDependencies;
        private int currentIndex = 0;

        public Dependencies(Set<T> directDependencies) {
            this.directDependencies = directDependencies;
        }

        public void updateIndex(List<T> orderedObjects) {
            while (this.currentIndex < orderedObjects.size()) {
                this.directDependencies.remove(orderedObjects.get(this.currentIndex));
                ++this.currentIndex;
            }
        }

        public boolean isEmpty() {
            return this.directDependencies.isEmpty();
        }
    }
}

