/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.runtime;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.util.FastMath;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorException;
import org.eclipse.escet.cif.simulator.runtime.io.RuntimeValueToString;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;

public class CifSimulatorMath {
    private CifSimulatorMath() {
    }

    public static int abs(int x) {
        if (x == Integer.MIN_VALUE) {
            String msg = Strings.fmt((String)"Integer overflow: abs(%d).", (Object[])new Object[]{x});
            throw new CifSimulatorException(msg);
        }
        return Math.abs(x);
    }

    public static double abs(double x) {
        return Math.abs(x);
    }

    public static double acos(double x) {
        double rslt = Math.acos(x);
        if (Double.isInfinite(rslt)) {
            String msg = Strings.fmt((String)"Real overflow: acos(%s).", (Object[])new Object[]{CifSimulatorMath.realToStr(x)});
            throw new CifSimulatorException(msg);
        }
        if (Double.isNaN(rslt)) {
            String msg = Strings.fmt((String)"Invalid operation: acos(%s).", (Object[])new Object[]{CifSimulatorMath.realToStr(x)});
            throw new CifSimulatorException(msg);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static double acosh(double x) {
        double rslt = FastMath.acosh((double)x);
        if (Double.isInfinite(rslt)) {
            String msg = Strings.fmt((String)"Real overflow: acosh(%s).", (Object[])new Object[]{CifSimulatorMath.realToStr(x)});
            throw new CifSimulatorException(msg);
        }
        if (Double.isNaN(rslt)) {
            String msg = Strings.fmt((String)"Invalid operation: acosh(%s).", (Object[])new Object[]{CifSimulatorMath.realToStr(x)});
            throw new CifSimulatorException(msg);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static double asin(double x) {
        double rslt = Math.asin(x);
        if (Double.isInfinite(rslt)) {
            String msg = Strings.fmt((String)"Real overflow: asin(%s).", (Object[])new Object[]{CifSimulatorMath.realToStr(x)});
            throw new CifSimulatorException(msg);
        }
        if (Double.isNaN(rslt)) {
            String msg = Strings.fmt((String)"Invalid operation: asin(%s).", (Object[])new Object[]{CifSimulatorMath.realToStr(x)});
            throw new CifSimulatorException(msg);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static double asinh(double x) {
        double rslt = FastMath.asinh((double)x);
        if (Double.isInfinite(rslt)) {
            String msg = Strings.fmt((String)"Real overflow: asinh(%s).", (Object[])new Object[]{CifSimulatorMath.realToStr(x)});
            throw new CifSimulatorException(msg);
        }
        if (Double.isNaN(rslt)) {
            String msg = Strings.fmt((String)"Invalid operation: asinh(%s).", (Object[])new Object[]{CifSimulatorMath.realToStr(x)});
            throw new CifSimulatorException(msg);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static double atan(double x) {
        double rslt = Math.atan(x);
        if (Double.isInfinite(rslt)) {
            String msg = Strings.fmt((String)"Real overflow: atan(%s).", (Object[])new Object[]{CifSimulatorMath.realToStr(x)});
            throw new CifSimulatorException(msg);
        }
        if (Double.isNaN(rslt)) {
            String msg = Strings.fmt((String)"Invalid operation: atan(%s).", (Object[])new Object[]{CifSimulatorMath.realToStr(x)});
            throw new CifSimulatorException(msg);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static double atanh(double x) {
        double rslt = FastMath.atanh((double)x);
        if (Double.isInfinite(rslt)) {
            String msg = Strings.fmt((String)"Real overflow: atanh(%s).", (Object[])new Object[]{CifSimulatorMath.realToStr(x)});
            throw new CifSimulatorException(msg);
        }
        if (Double.isNaN(rslt)) {
            String msg = Strings.fmt((String)"Invalid operation: atanh(%s).", (Object[])new Object[]{CifSimulatorMath.realToStr(x)});
            throw new CifSimulatorException(msg);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static int addInt(int x, int y) {
        long rslt = (long)x + (long)y;
        if (Integer.MIN_VALUE <= rslt && rslt <= Integer.MAX_VALUE) {
            return (int)rslt;
        }
        String msg = Strings.fmt((String)"Integer overflow: %d + %d.", (Object[])new Object[]{x, y});
        throw new CifSimulatorException(msg);
    }

    public static double addReal(double x, double y) {
        double rslt = x + y;
        if (Double.isInfinite(rslt)) {
            String msg = Strings.fmt((String)"Real overflow: %s + %s.", (Object[])new Object[]{CifSimulatorMath.realToStr(x), CifSimulatorMath.realToStr(y)});
            throw new CifSimulatorException(msg);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static <T> List<T> addList(List<T> x, List<T> y) {
        List rslt = Lists.listc((int)(x.size() + y.size()));
        rslt.addAll(x);
        rslt.addAll(y);
        return rslt;
    }

    public static String addString(String x, String y) {
        return String.valueOf(x) + y;
    }

    public static <K, V> Map<K, V> addDict(Map<K, V> x, Map<K, V> y) {
        LinkedHashMap rslt = Maps.copy(x);
        rslt.putAll(y);
        return rslt;
    }

    public static <K, V> Map<K, V> addpairs(Map<K, V> dict, K[] ks, V[] vs) {
        Assert.check((ks.length == vs.length ? 1 : 0) != 0);
        int i = 0;
        while (i < ks.length) {
            K k = ks[i];
            V v = vs[i];
            V previous = dict.put(k, v);
            if (previous != null) {
                String msg = Strings.fmt((String)"Duplicate key in dictionary value: %s.", (Object[])new Object[]{RuntimeValueToString.runtimeToString(k)});
                throw new CifSimulatorException(msg);
            }
            ++i;
        }
        return dict;
    }

    public static String boolToStr(boolean x) {
        return x ? "true" : "false";
    }

    public static double cbrt(double x) {
        double rslt = Math.cbrt(x);
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static int ceil(double x) {
        double rslt = Math.ceil(x);
        if (rslt < -2.147483648E9 || rslt > 2.147483647E9) {
            String msg = Strings.fmt((String)"Integer overflow: ceil(%s).", (Object[])new Object[]{CifSimulatorMath.realToStr(x)});
            throw new CifSimulatorException(msg);
        }
        return (int)rslt;
    }

    public static double cos(double x) {
        double rslt = Math.cos(x);
        if (Double.isInfinite(rslt)) {
            String msg = Strings.fmt((String)"Real overflow: cos(%s).", (Object[])new Object[]{CifSimulatorMath.realToStr(x)});
            throw new CifSimulatorException(msg);
        }
        if (Double.isNaN(rslt)) {
            String msg = Strings.fmt((String)"Invalid operation: cos(%s).", (Object[])new Object[]{CifSimulatorMath.realToStr(x)});
            throw new CifSimulatorException(msg);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static double cosh(double x) {
        double rslt = Math.cosh(x);
        if (Double.isInfinite(rslt)) {
            String msg = Strings.fmt((String)"Real overflow: cosh(%s).", (Object[])new Object[]{CifSimulatorMath.realToStr(x)});
            throw new CifSimulatorException(msg);
        }
        if (Double.isNaN(rslt)) {
            String msg = Strings.fmt((String)"Invalid operation: cosh(%s).", (Object[])new Object[]{CifSimulatorMath.realToStr(x)});
            throw new CifSimulatorException(msg);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static <T> List<T> delete(List<T> lst, int origIdx) {
        int idx = origIdx;
        if (idx < 0) {
            idx = lst.size() + idx;
        }
        if (idx < 0 || idx >= lst.size()) {
            String msg = Strings.fmt((String)"Index out of bounds: del(%s, %s).", (Object[])new Object[]{RuntimeValueToString.runtimeToString(lst), origIdx});
            throw new CifSimulatorException(msg);
        }
        List rslt = Lists.copy(lst);
        rslt.remove(idx);
        return rslt;
    }

    public static int div(int x, int y) {
        if (y == 0) {
            String msg = Strings.fmt((String)"Division by zero: %d div %d.", (Object[])new Object[]{x, y});
            throw new CifSimulatorException(msg);
        }
        if (x == Integer.MIN_VALUE && y == -1) {
            String msg = Strings.fmt((String)"Integer overflow: %d div %d.", (Object[])new Object[]{x, y});
            throw new CifSimulatorException(msg);
        }
        return x / y;
    }

    public static double divide(double x, double y) {
        if (y == 0.0) {
            String msg = Strings.fmt((String)"Division by zero: %s / %s.", (Object[])new Object[]{CifSimulatorMath.realToStr(x), CifSimulatorMath.realToStr(y)});
            throw new CifSimulatorException(msg);
        }
        double rslt = x / y;
        if (Double.isInfinite(rslt)) {
            String msg = Strings.fmt((String)"Real overflow: %s * %s.", (Object[])new Object[]{CifSimulatorMath.realToStr(x), CifSimulatorMath.realToStr(y)});
            throw new CifSimulatorException(msg);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static boolean empty(List<?> x) {
        return x.isEmpty();
    }

    public static boolean empty(Set<?> x) {
        return x.isEmpty();
    }

    public static boolean empty(Map<?, ?> x) {
        return x.isEmpty();
    }

    public static boolean equal(boolean x, boolean y) {
        return x == y;
    }

    public static boolean equal(Boolean x, boolean y) {
        return x == y;
    }

    public static boolean equal(boolean x, Boolean y) {
        return x == y;
    }

    public static boolean equal(int x, int y) {
        return x == y;
    }

    public static boolean equal(Integer x, int y) {
        return x == y;
    }

    public static boolean equal(int x, Integer y) {
        return x == y;
    }

    public static boolean equal(double x, double y) {
        return x == y;
    }

    public static boolean equal(Double x, double y) {
        return x == y;
    }

    public static boolean equal(double x, Double y) {
        return x == y;
    }

    public static boolean equal(Object x, Object y) {
        return x.equals(y);
    }

    public static double exp(double x) {
        double rslt = Math.exp(x);
        if (Double.isInfinite(rslt)) {
            String msg = Strings.fmt((String)"Real overflow: exp(%s).", (Object[])new Object[]{CifSimulatorMath.realToStr(x)});
            throw new CifSimulatorException(msg);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static int floor(double x) {
        double rslt = Math.floor(x);
        if (rslt < -2.147483648E9 || rslt > 2.147483647E9) {
            String msg = Strings.fmt((String)"Integer overflow: floor(%s).", (Object[])new Object[]{CifSimulatorMath.realToStr(x)});
            throw new CifSimulatorException(msg);
        }
        return (int)rslt;
    }

    public static int hash(Object x) {
        return x.hashCode();
    }

    public static <T> boolean in(T x, List<T> y) {
        return y.contains(x);
    }

    public static <T> boolean in(T x, Set<T> y) {
        return y.contains(x);
    }

    public static <K> boolean in(K x, Map<K, ?> y) {
        return y.containsKey(x);
    }

    public static <T> Set<T> intersection(Set<T> set1, Set<T> set2) {
        Set rslt = Sets.copy(set1);
        rslt.retainAll(set2);
        return rslt;
    }

    public static double intToReal(int x) {
        return x;
    }

    public static String intToStr(int x) {
        return Integer.toString(x);
    }

    public static double ln(double x) {
        if (x <= 0.0) {
            String msg = Strings.fmt((String)"Invalid operation: ln(%s).", (Object[])new Object[]{CifSimulatorMath.realToStr(x)});
            throw new CifSimulatorException(msg);
        }
        return Math.log(x);
    }

    public static double log(double x) {
        if (x <= 0.0) {
            String msg = Strings.fmt((String)"Invalid operation: log(%s).", (Object[])new Object[]{CifSimulatorMath.realToStr(x)});
            throw new CifSimulatorException(msg);
        }
        return Math.log10(x);
    }

    @SafeVarargs
    public static <T> List<T> makelist(List<T> lst, T ... elems) {
        T[] TArray = elems;
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            T elem = TArray[n2];
            lst.add(elem);
            ++n2;
        }
        return lst;
    }

    @SafeVarargs
    public static <T> Set<T> makeset(Set<T> lst, T ... elems) {
        T[] TArray = elems;
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            T elem = TArray[n2];
            lst.add(elem);
            ++n2;
        }
        return lst;
    }

    public static int max(int x, int y) {
        return Math.max(x, y);
    }

    public static double max(double x, double y) {
        return Math.max(x, y);
    }

    public static int min(int x, int y) {
        return Math.min(x, y);
    }

    public static double min(double x, double y) {
        return Math.min(x, y);
    }

    public static int mod(int x, int y) {
        if (y == 0) {
            String msg = Strings.fmt((String)"Division by zero: %d mod %d.", (Object[])new Object[]{x, y});
            throw new CifSimulatorException(msg);
        }
        return x % y;
    }

    public static <T> List<T> modify(List<T> lst, int origIdx, T newValue) {
        int idx = origIdx;
        if (idx < 0) {
            idx = lst.size() + idx;
        }
        if (idx < 0 || idx >= lst.size()) {
            String msg = Strings.fmt((String)"Index out of bounds: %s[%s].", (Object[])new Object[]{RuntimeValueToString.runtimeToString(lst), origIdx});
            throw new CifSimulatorException(msg);
        }
        List rslt = Lists.copy(lst);
        rslt.set(idx, newValue);
        return rslt;
    }

    public static <K, V> Map<K, V> modify(Map<K, V> dict, K key, V value) {
        LinkedHashMap rslt = Maps.copy(dict);
        rslt.put(key, value);
        return rslt;
    }

    public static int multiply(int x, int y) {
        long rslt = (long)x * (long)y;
        if (Integer.MIN_VALUE <= rslt && rslt <= Integer.MAX_VALUE) {
            return (int)rslt;
        }
        String msg = Strings.fmt((String)"Integer overflow: %d * %d.", (Object[])new Object[]{x, y});
        throw new CifSimulatorException(msg);
    }

    public static double multiply(double x, double y) {
        double rslt = x * y;
        if (Double.isInfinite(rslt)) {
            String msg = Strings.fmt((String)"Real overflow: %s * %s.", (Object[])new Object[]{CifSimulatorMath.realToStr(x), CifSimulatorMath.realToStr(y)});
            throw new CifSimulatorException(msg);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static int negate(int x) {
        if (x == Integer.MIN_VALUE) {
            String msg = Strings.fmt((String)"Integer overflow: -%d.", (Object[])new Object[]{x});
            throw new CifSimulatorException(msg);
        }
        return -x;
    }

    public static double negate(double x) {
        return x == 0.0 ? 0.0 : -x;
    }

    public static int powInt(int x, int y) {
        Assert.check((y >= 0 ? 1 : 0) != 0);
        double rslt = Math.pow(x, y);
        if (-2.147483648E9 <= rslt && rslt <= 2.147483647E9) {
            return (int)rslt;
        }
        String msg = Strings.fmt((String)"Integer overflow: pow(%d, %d).", (Object[])new Object[]{x, y});
        throw new CifSimulatorException(msg);
    }

    public static double powReal(double x, double y) {
        double rslt = Math.pow(x, y);
        if (Double.isInfinite(rslt)) {
            String msg = Strings.fmt((String)"Real overflow: pow(%s, %s).", (Object[])new Object[]{CifSimulatorMath.realToStr(x), CifSimulatorMath.realToStr(y)});
            throw new CifSimulatorException(msg);
        }
        if (Double.isNaN(rslt)) {
            String msg = Strings.fmt((String)"Invalid operation: pow(%s, %s).", (Object[])new Object[]{CifSimulatorMath.realToStr(x), CifSimulatorMath.realToStr(y)});
            throw new CifSimulatorException(msg);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static String realToStr(double x) {
        Assert.check((!Double.isNaN(x) ? 1 : 0) != 0);
        Assert.check((!Double.isInfinite(x) ? 1 : 0) != 0);
        return Double.toString(x).replace('E', 'e');
    }

    public static <T> T project(List<T> lst, int origIdx) {
        int idx = origIdx;
        if (idx < 0) {
            idx = lst.size() + idx;
        }
        if (idx < 0 || idx >= lst.size()) {
            String msg = Strings.fmt((String)"Index out of bounds: %s[%s].", (Object[])new Object[]{RuntimeValueToString.runtimeToString(lst), origIdx});
            throw new CifSimulatorException(msg);
        }
        return lst.get(idx);
    }

    public static <K, V> V project(Map<K, V> dict, K key) {
        V rslt = dict.get(key);
        if (rslt == null) {
            String msg = Strings.fmt((String)"Key not found: %s[%s].", (Object[])new Object[]{RuntimeValueToString.runtimeToString(dict), key});
            throw new CifSimulatorException(msg);
        }
        return rslt;
    }

    public static String project(String str, int origIdx) {
        int idx = origIdx;
        if (idx < 0) {
            idx = str.length() + idx;
        }
        if (idx < 0 || idx >= str.length()) {
            String msg = Strings.fmt((String)"Index out of bounds: \"%s\"[%s].", (Object[])new Object[]{Strings.escape((String)str), origIdx});
            throw new CifSimulatorException(msg);
        }
        return str.substring(idx, idx + 1);
    }

    public static int round(double x) {
        if (x < -2.1474836485E9 || x >= 2.1474836475E9) {
            String msg = Strings.fmt((String)"Integer overflow: round(%s).", (Object[])new Object[]{CifSimulatorMath.realToStr(x)});
            throw new CifSimulatorException(msg);
        }
        long rslt = Math.round(x);
        return (int)rslt;
    }

    public static double scale(double v, double inmin, double inmax, double outmin, double outmax) {
        double inrange = CifSimulatorMath.subtract(inmax, inmin);
        if (inrange == 0.0) {
            String msg = Strings.fmt((String)"Empty input interval: scale(%s, %s, %s, %s, %s).", (Object[])new Object[]{CifSimulatorMath.realToStr(v), CifSimulatorMath.realToStr(inmin), CifSimulatorMath.realToStr(inmax), CifSimulatorMath.realToStr(outmin), CifSimulatorMath.realToStr(outmax)});
            throw new CifSimulatorException(msg);
        }
        double fraction = CifSimulatorMath.divide(CifSimulatorMath.subtract(v, inmin), inrange);
        return CifSimulatorMath.addReal(outmin, CifSimulatorMath.multiply(fraction, CifSimulatorMath.subtract(outmax, outmin)));
    }

    public static int sign(int x) {
        return x == 0 ? 0 : (x < 0 ? -1 : 1);
    }

    public static int sign(double x) {
        return x == 0.0 ? 0 : (x < 0.0 ? -1 : 1);
    }

    public static double sin(double x) {
        double rslt = Math.sin(x);
        if (Double.isInfinite(rslt)) {
            String msg = Strings.fmt((String)"Real overflow: sin(%s).", (Object[])new Object[]{CifSimulatorMath.realToStr(x)});
            throw new CifSimulatorException(msg);
        }
        if (Double.isNaN(rslt)) {
            String msg = Strings.fmt((String)"Invalid operation: sin(%s).", (Object[])new Object[]{CifSimulatorMath.realToStr(x)});
            throw new CifSimulatorException(msg);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static double sinh(double x) {
        double rslt = Math.sinh(x);
        if (Double.isInfinite(rslt)) {
            String msg = Strings.fmt((String)"Real overflow: sinh(%s).", (Object[])new Object[]{CifSimulatorMath.realToStr(x)});
            throw new CifSimulatorException(msg);
        }
        if (Double.isNaN(rslt)) {
            String msg = Strings.fmt((String)"Invalid operation: sinh(%s).", (Object[])new Object[]{CifSimulatorMath.realToStr(x)});
            throw new CifSimulatorException(msg);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static int size(String x) {
        return x.length();
    }

    public static int size(List<?> x) {
        return x.size();
    }

    public static int size(Set<?> x) {
        return x.size();
    }

    public static int size(Map<?, ?> x) {
        return x.size();
    }

    public static <T> List<T> slice(List<T> lst, Integer beginIndex, Integer endIndex) {
        return Lists.slice(lst, (Integer)beginIndex, (Integer)endIndex);
    }

    public static String slice(String str, Integer beginIndex, Integer endIndex) {
        return Strings.slice((String)str, (Integer)beginIndex, (Integer)endIndex);
    }

    public static double sqrt(double x) {
        if (x < 0.0) {
            String msg = Strings.fmt((String)"Invalid operation: sqrt(%s).", (Object[])new Object[]{CifSimulatorMath.realToStr(x)});
            throw new CifSimulatorException(msg);
        }
        return Math.sqrt(x);
    }

    public static boolean strToBool(String x) {
        if (x.equals("true")) {
            return true;
        }
        if (x.equals("false")) {
            return false;
        }
        String msg = Strings.fmt((String)"Cast from type \"string\" to type \"bool\" failed: the string value does not represent a boolean value: \"%s\".", (Object[])new Object[]{Strings.escape((String)x)});
        throw new CifSimulatorException(msg);
    }

    public static int strToInt(String x) {
        try {
            return Integer.parseInt(x);
        }
        catch (NumberFormatException e) {
            String msg = Strings.fmt((String)"Cast from type \"string\" to type \"int\" failed: the string value does not represent an integer value, or the integer value resulted in integer overflow: \"%s\".", (Object[])new Object[]{Strings.escape((String)x)});
            throw new CifSimulatorException(msg);
        }
    }

    public static double strToReal(String x) {
        double rslt;
        try {
            rslt = Double.parseDouble(x);
            if (Double.isNaN(rslt)) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            String msg = Strings.fmt((String)"Cast from type \"string\" to type \"real\" failed: the string value does not represent a real value: \"%s\".", (Object[])new Object[]{Strings.escape((String)x)});
            throw new CifSimulatorException(msg);
        }
        if (Double.isInfinite(rslt)) {
            String msg = Strings.fmt((String)"Cast from type \"string\" to type \"real\" failed, due to real overflow: \"%s\".", (Object[])new Object[]{Strings.escape((String)x)});
            throw new CifSimulatorException(msg);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static <T> boolean subset(Set<T> x, Set<T> y) {
        return y.containsAll(x);
    }

    public static int subtract(int x, int y) {
        long rslt = (long)x - (long)y;
        if (Integer.MIN_VALUE <= rslt && rslt <= Integer.MAX_VALUE) {
            return (int)rslt;
        }
        String msg = Strings.fmt((String)"Integer overflow: %d - %d.", (Object[])new Object[]{x, y});
        throw new CifSimulatorException(msg);
    }

    public static double subtract(double x, double y) {
        double rslt = x - y;
        if (Double.isInfinite(rslt)) {
            String msg = Strings.fmt((String)"Real overflow: %s - %s.", (Object[])new Object[]{CifSimulatorMath.realToStr(x), CifSimulatorMath.realToStr(y)});
            throw new CifSimulatorException(msg);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static <T> Set<T> subtract(Set<T> x, Set<T> y) {
        Set rslt = Sets.copy(x);
        rslt.removeAll(y);
        return rslt;
    }

    public static <K, V> Map<K, V> subtract(Map<K, V> x, Map<K, V> y) {
        LinkedHashMap rslt = Maps.copy(x);
        for (K key : y.keySet()) {
            rslt.remove(key);
        }
        return rslt;
    }

    public static <K, V> Map<K, V> subtract(Map<K, V> x, List<K> y) {
        LinkedHashMap rslt = Maps.copy(x);
        for (K key : y) {
            rslt.remove(key);
        }
        return rslt;
    }

    public static <K, V> Map<K, V> subtract(Map<K, V> x, Set<K> y) {
        LinkedHashMap rslt = Maps.copy(x);
        for (K key : y) {
            rslt.remove(key);
        }
        return rslt;
    }

    public static double tan(double x) {
        double rslt = Math.tan(x);
        if (Double.isInfinite(rslt)) {
            String msg = Strings.fmt((String)"Real overflow: tan(%s).", (Object[])new Object[]{CifSimulatorMath.realToStr(x)});
            throw new CifSimulatorException(msg);
        }
        if (Double.isNaN(rslt)) {
            String msg = Strings.fmt((String)"Invalid operation: tan(%s).", (Object[])new Object[]{CifSimulatorMath.realToStr(x)});
            throw new CifSimulatorException(msg);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static double tanh(double x) {
        double rslt = Math.tanh(x);
        if (Double.isInfinite(rslt)) {
            String msg = Strings.fmt((String)"Real overflow: tanh(%s).", (Object[])new Object[]{CifSimulatorMath.realToStr(x)});
            throw new CifSimulatorException(msg);
        }
        if (Double.isNaN(rslt)) {
            String msg = Strings.fmt((String)"Invalid operation: tanh(%s).", (Object[])new Object[]{CifSimulatorMath.realToStr(x)});
            throw new CifSimulatorException(msg);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static <T> Set<T> union(Set<T> set1, Set<T> set2) {
        Set rslt = Sets.copy(set1);
        rslt.addAll(set2);
        return rslt;
    }
}

