/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.output.plotviz;

import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.eclipse.escet.cif.simulator.output.plotviz.PlotVisualizationRangeOption;
import org.eclipse.escet.cif.simulator.output.plotviz.PlotVisualizerDataPoint;
import org.eclipse.escet.cif.simulator.output.plotviz.PlotVisualizerDataSeries;
import org.eclipse.escet.cif.simulator.runtime.meta.RuntimeStateFilterer;
import org.eclipse.escet.cif.simulator.runtime.meta.RuntimeStateObjectMeta;
import org.eclipse.escet.cif.simulator.runtime.meta.StateObjectType;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeState;
import org.eclipse.escet.common.java.Lists;

public class PlotVisualizerData {
    public final Double range = PlotVisualizationRangeOption.getRange();
    private String filtersTxt;
    public List<RuntimeStateObjectMeta> metas;
    public List<PlotVisualizerDataSeries> varDatas = null;

    public PlotVisualizerData(String filtersTxt) {
        this.filtersTxt = filtersTxt;
    }

    public void initMeta(RuntimeState state) {
        this.metas = Lists.list();
        for (RuntimeStateObjectMeta meta : state.spec.stateObjectsMeta) {
            Object value;
            if (meta.type == StateObjectType.AUTOMATON || !PlotVisualizerData.isSupportedType(value = state.getVarValue(meta))) continue;
            this.metas.add(meta);
        }
        this.metas = RuntimeStateFilterer.filter(this.metas, this.filtersTxt, "Plot visualizer", "shown in the plot visualizer");
        this.filtersTxt = null;
    }

    public void initVarDatas() {
        this.varDatas = Lists.listc((int)this.metas.size());
        for (RuntimeStateObjectMeta meta : this.metas) {
            PlotVisualizerDataSeries seriesData = new PlotVisualizerDataSeries(meta);
            this.varDatas.add(seriesData);
        }
    }

    public void add(RuntimeState state, List<RuntimeStateObjectMeta> metas, List<PlotVisualizerDataSeries> targetDatas) {
        if (this.range != null) {
            if (targetDatas.isEmpty()) {
                return;
            }
            double curTime = state.getTime();
            double lastTime = curTime - this.range;
            if (lastTime < 0.0) {
                lastTime = 0.0;
            }
            Deque<PlotVisualizerDataPoint> points0 = ((PlotVisualizerDataSeries)Lists.first(targetDatas)).points;
            int itemsToRemove = 0;
            for (PlotVisualizerDataPoint point : points0) {
                double timeValue = point.x;
                if (timeValue < lastTime) {
                    ++itemsToRemove;
                    continue;
                }
                if (timeValue == lastTime || --itemsToRemove >= 0) break;
                itemsToRemove = 0;
                break;
            }
            int mi = 0;
            while (mi < metas.size()) {
                Deque<PlotVisualizerDataPoint> points = targetDatas.get((int)mi).points;
                int ri = 0;
                while (ri < itemsToRemove) {
                    points.removeFirst();
                    ++ri;
                }
                ++mi;
            }
        }
        double t = state.getTime();
        int i = 0;
        while (i < metas.size()) {
            Object value = state.getVarValue(metas.get(i));
            double number = PlotVisualizerData.valueToDouble(value);
            PlotVisualizerDataSeries series = targetDatas.get(i);
            series.points.add(new PlotVisualizerDataPoint(t, number));
            ++i;
        }
    }

    public void remove(double time, List<PlotVisualizerDataSeries> targetDatas) {
        block9: {
            double lastTime;
            Deque<PlotVisualizerDataPoint> points0;
            block8: {
                if (targetDatas.isEmpty()) {
                    return;
                }
                points0 = ((PlotVisualizerDataSeries)Lists.first(targetDatas)).points;
                if (points0.isEmpty()) {
                    return;
                }
                lastTime = points0.getLast().x;
                if (time != 0.0) break block8;
                for (PlotVisualizerDataSeries series : targetDatas) {
                    series.points.clear();
                }
                break block9;
            }
            if (time == lastTime) break block9;
            int itemsToRemove = 0;
            Iterator<PlotVisualizerDataPoint> iter = points0.descendingIterator();
            while (iter.hasNext()) {
                double t = iter.next().x;
                if (t > time) {
                    ++itemsToRemove;
                    continue;
                }
                if (t == time) {
                    ++itemsToRemove;
                    break;
                }
                if (!(t < time)) continue;
                throw new RuntimeException("Moved beyond requested time: " + time);
            }
            for (PlotVisualizerDataSeries series : targetDatas) {
                Deque<PlotVisualizerDataPoint> points = series.points;
                int i = 0;
                while (i < itemsToRemove) {
                    points.removeLast();
                    ++i;
                }
            }
        }
    }

    private static boolean isSupportedType(Object value) {
        return value instanceof Boolean || value instanceof Integer || value instanceof Double;
    }

    private static double valueToDouble(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        if (value instanceof Integer) {
            return ((Integer)value).doubleValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        throw new RuntimeException("Unexpected value: " + value);
    }
}

