/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.common.CifInvariantUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.InvKind;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.ExprCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.JavaCodeFile;
import org.eclipse.escet.common.app.framework.exceptions.UnsupportedException;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class StateInvPredCodeGenerator {
    private StateInvPredCodeGenerator() {
    }

    public static void gencodeStateInvPreds(Specification spec, CifCompilerContext ctxt) {
        JavaCodeFile file = ctxt.addCodeFile("StateInvPreds");
        CodeBox h = file.header;
        h.add("/** State invariants. */");
        h.add("public final class StateInvPreds {");
        CodeBox c = file.body;
        c.add("public static boolean evalStateInvPreds(State state, boolean initial) {");
        c.indent();
        StateInvPredCodeGenerator.gencodeEvalComponent((ComplexComponent)spec, ctxt, c);
        c.add("// Invariants for current locations of automata.");
        for (Automaton aut : ctxt.getAutomata()) {
            c.add("if (!evalStateInvPreds%s(state, initial)) return false;", new Object[]{ctxt.getAutClassName(aut)});
        }
        c.add();
        c.add("// All invariant predicates satisfied.");
        c.add("return true;");
        c.dedent();
        c.add("}");
        for (Automaton aut : ctxt.getAutomata()) {
            StateInvPredCodeGenerator.gencodeEvalAutLocs(aut, ctxt, c);
        }
    }

    private static void gencodeEvalComponent(ComplexComponent comp, CifCompilerContext ctxt, CodeBox c) {
        List stateInvs = Lists.list();
        for (Invariant inv : comp.getInvariants()) {
            if (inv.getInvKind() != InvKind.STATE) continue;
            stateInvs.add(inv);
        }
        String absName = CifTextUtils.getAbsName((PositionObject)comp);
        if (!stateInvs.isEmpty()) {
            c.add("// Invariants for \"%s\".", new Object[]{absName});
        }
        String compTxt = CifTextUtils.getComponentText2((ComplexComponent)comp);
        for (Invariant inv : stateInvs) {
            Expression pred = inv.getPredicate();
            c.add("try {");
            c.indent();
            String predTxt = CifTextUtils.exprToStr((Expression)pred);
            c.add("if (!(%s)) {", new Object[]{ExprCodeGenerator.gencodeExpr(pred, ctxt, "state")});
            c.indent();
            c.add("if (initial) warn(\"Invariant \\\"%s\\\" of %s is not satisfied.\");", new Object[]{StringEscapeUtils.escapeJava((String)predTxt), StringEscapeUtils.escapeJava((String)compTxt)});
            c.add("return false;");
            c.dedent();
            c.add("}");
            c.dedent();
            c.add("} catch (CifSimulatorException e) {");
            c.indent();
            c.add("throw new CifSimulatorException(\"Evaluation of invariant \\\"%s\\\" of %s failed.\", e, state);", new Object[]{StringEscapeUtils.escapeJava((String)predTxt), StringEscapeUtils.escapeJava((String)compTxt)});
            c.dedent();
            c.add("}");
            StateInvPredCodeGenerator.checkInvTimeConstant(inv);
            SupKind kind = CifInvariantUtils.getSupKind((Invariant)inv);
            if (kind != SupKind.REQUIREMENT) continue;
            OutputProvider.warn((String)"Invariant \"%s\" of %s is a requirement, but will be simulated as a plant.", (Object[])new Object[]{predTxt, compTxt});
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                StateInvPredCodeGenerator.gencodeEvalComponent((ComplexComponent)child, ctxt, c);
            }
        }
    }

    private static void gencodeEvalAutLocs(Automaton aut, CifCompilerContext ctxt, CodeBox c) {
        c.add();
        c.add("private static boolean evalStateInvPreds%s(State state, boolean initial) {", new Object[]{ctxt.getAutClassName(aut)});
        c.indent();
        c.add("// Invariants for current location.");
        c.add("switch (state.%s.%s) {", new Object[]{ctxt.getAutSubStateFieldName(aut), ctxt.getLocationPointerFieldName(aut)});
        c.indent();
        EList locs = aut.getLocations();
        int locIdx = 0;
        while (locIdx < locs.size()) {
            Location loc = (Location)locs.get(locIdx);
            List locInvs = Lists.list();
            for (Invariant inv : loc.getInvariants()) {
                if (inv.getInvKind() != InvKind.STATE) continue;
                locInvs.add(inv);
            }
            if (!locInvs.isEmpty()) {
                c.add("case %s:", new Object[]{ctxt.getLocationValueText(loc, locIdx)});
                c.indent();
                String locTxt = CifTextUtils.getLocationText2((Location)loc);
                for (Invariant inv : locInvs) {
                    Expression pred = inv.getPredicate();
                    c.add("try {");
                    c.indent();
                    String predTxt = CifTextUtils.exprToStr((Expression)pred);
                    c.add("if (!(%s)) {", new Object[]{ExprCodeGenerator.gencodeExpr(pred, ctxt, "state")});
                    c.indent();
                    c.add("if (initial) warn(\"Invariant \\\"%s\\\" of %s is not satisfied.\");", new Object[]{StringEscapeUtils.escapeJava((String)predTxt), StringEscapeUtils.escapeJava((String)locTxt)});
                    c.add("return false;");
                    c.dedent();
                    c.add("}");
                    c.dedent();
                    c.add("} catch (CifSimulatorException e) {");
                    c.indent();
                    c.add("throw new CifSimulatorException(\"Evaluation of invariant \\\"%s\\\" of %s failed.\", e, state);", new Object[]{StringEscapeUtils.escapeJava((String)predTxt), StringEscapeUtils.escapeJava((String)locTxt)});
                    c.dedent();
                    c.add("}");
                    StateInvPredCodeGenerator.checkInvTimeConstant(inv);
                    SupKind kind = CifInvariantUtils.getSupKind((Invariant)inv);
                    if (kind != SupKind.REQUIREMENT) continue;
                    OutputProvider.warn((String)"Invariant \"%s\" of %s is a requirement, but will be simulated as a plant.", (Object[])new Object[]{predTxt, locTxt});
                }
                c.add("break;");
                c.dedent();
            }
            ++locIdx;
        }
        c.dedent();
        c.add("}");
        c.add();
        c.add("// All invariants satisfied.");
        c.add("return true;");
        c.dedent();
        c.add("}");
    }

    private static void checkInvTimeConstant(Invariant inv) {
        if (CifValueUtils.isTimeConstant((Expression)inv.getPredicate())) {
            return;
        }
        String msg = Strings.fmt((String)"Time dependent invariants are currently not supported by the CIF simulator: \"%s\".", (Object[])new Object[]{StringEscapeUtils.escapeJava((String)CifTextUtils.invToStr((Invariant)inv, (boolean)false))});
        throw new UnsupportedException(msg);
    }
}

