/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifExtFuncUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.common.FuncLocalVarOrderer;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.functions.AssignmentFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.BreakFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.ContinueFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.ElifFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.ExternalFunction;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.IfFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.functions.ReturnFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.WhileFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.FuncType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.simulator.compiler.AssignmentCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.DefaultValueCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.ExprCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.ExtJavaFuncCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.JavaCodeFile;
import org.eclipse.escet.cif.simulator.compiler.TypeCodeGenerator;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class FuncCodeGenerator {
    private FuncCodeGenerator() {
    }

    public static void gencodeFuncs(ComplexComponent comp, CifCompilerContext ctxt) {
        if (comp instanceof Automaton) {
            return;
        }
        for (Declaration decl : comp.getDeclarations()) {
            if (!(decl instanceof Function)) continue;
            FuncCodeGenerator.gencodeFunc((Function)decl, ctxt);
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                FuncCodeGenerator.gencodeFuncs((ComplexComponent)child, ctxt);
            }
        }
    }

    public static void gencodeFunc(Function func, CifCompilerContext ctxt) {
        String className = ctxt.getFuncClassName(func);
        JavaCodeFile file = ctxt.addCodeFile(className);
        CifType retType = CifTypeUtils.makeTupleType((List)EMFHelper.deepclone((List)func.getReturnTypes()));
        FuncType funcType = CifConstructors.newFuncType();
        for (FunctionParameter param : func.getParameters()) {
            CifType paramType = param.getParameter().getType();
            funcType.getParamTypes().add((Object)((CifType)EMFHelper.deepclone((EObject)paramType)));
        }
        funcType.setReturnType(retType);
        String absName = CifTextUtils.getAbsName((PositionObject)func);
        CodeBox h = file.header;
        h.add("/** Function \"%s\". */", new Object[]{absName});
        h.add("public final class %s extends %s {", new Object[]{className, ctxt.getFuncTypeClassName(funcType)});
        CodeBox c = file.body;
        c.add("public static final %s %s = new %s();", new Object[]{className, ctxt.getFuncFieldName(func), className});
        if (func instanceof ExternalFunction) {
            FuncCodeGenerator.gencodeClassFields((ExternalFunction)func, c);
        }
        c.add();
        c.add("private %s() {", new Object[]{className});
        c.indent();
        c.add("// Private constructor to force use of singleton instance.");
        c.dedent();
        c.add("}");
        List paramTxts = Lists.listc((int)func.getParameters().size());
        for (FunctionParameter param : func.getParameters()) {
            DiscVariable var = param.getParameter();
            String typeTxt = TypeCodeGenerator.gencodeType(var.getType(), ctxt);
            String name = ctxt.getFuncParamMethodParamName(var);
            paramTxts.add(String.valueOf(typeTxt) + " " + name);
        }
        c.add();
        c.add("@Override");
        c.add("public %s evalFunc(%s) {", new Object[]{TypeCodeGenerator.gencodeType(retType, ctxt), StringUtils.join((Iterable)paramTxts, (String)", ")});
        c.indent();
        c.add("try {");
        c.indent();
        if (func instanceof InternalFunction) {
            FuncCodeGenerator.gencodeBody((InternalFunction)func, c, ctxt);
        } else {
            FuncCodeGenerator.gencodeBody((ExternalFunction)func, retType, c, ctxt);
        }
        c.dedent();
        c.add("} catch (StackOverflowError e) {");
        c.indent();
        c.add("throw new CifSimulatorException(\"Stack overflow during evaluation of function \\\"%s\\\".\");", new Object[]{absName});
        c.dedent();
        c.add("} catch (CifSimulatorException e) {");
        c.indent();
        c.add("throw new CifSimulatorException(\"Evaluation of function \\\"%s\\\" failed.\", e);", new Object[]{absName});
        c.dedent();
        c.add("}");
        c.dedent();
        c.add("}");
        if (func instanceof ExternalFunction) {
            FuncCodeGenerator.gencodeAdditionalMethods((ExternalFunction)func, retType, c, ctxt);
        }
        c.add();
        c.add("@Override");
        c.add("public String toString() {");
        c.indent();
        c.add("return \"%s\";", new Object[]{absName});
        c.dedent();
        c.add("}");
    }

    private static void gencodeClassFields(ExternalFunction func, CodeBox c) {
        String extRef = func.getFunction();
        String langName = CifExtFuncUtils.getLangName((String)extRef);
        if (!langName.equals("java")) {
            throw new RuntimeException("Unknown language: " + langName);
        }
        ExtJavaFuncCodeGenerator.gencodeClassFields(func, c);
    }

    private static void gencodeAdditionalMethods(ExternalFunction func, CifType retType, CodeBox c, CifCompilerContext ctxt) {
        String extRef = func.getFunction();
        String langName = CifExtFuncUtils.getLangName((String)extRef);
        if (!langName.equals("java")) {
            throw new RuntimeException("Unknown language: " + langName);
        }
        ExtJavaFuncCodeGenerator.gencodeAdditionalMethods(func, retType, c, ctxt);
    }

    private static void gencodeBody(InternalFunction func, CodeBox c, CifCompilerContext ctxt) {
        Object localVars = func.getVariables();
        localVars = new FuncLocalVarOrderer().computeOrder((Collection)localVars);
        Assert.notNull((Object)localVars);
        c.add("boolean b; // temp var for pred eval rslts");
        Iterator iterator = localVars.iterator();
        while (iterator.hasNext()) {
            DiscVariable var = (DiscVariable)iterator.next();
            if (var.getValue() == null) {
                c.add("%s %s = %s;", new Object[]{TypeCodeGenerator.gencodeType(var.getType(), ctxt), ctxt.getFuncLocalVarName(var), DefaultValueCodeGenerator.getDefaultValueCode(var.getType(), ctxt)});
                continue;
            }
            Assert.check((var.getValue().getValues().size() == 1 ? 1 : 0) != 0);
            Expression value = (Expression)Lists.first((List)var.getValue().getValues());
            c.add("%s %s;", new Object[]{TypeCodeGenerator.gencodeType(var.getType(), ctxt), ctxt.getFuncLocalVarName(var)});
            c.add("try {");
            c.indent();
            c.add("%s = %s;", new Object[]{ctxt.getFuncLocalVarName(var), ExprCodeGenerator.gencodeExpr(value, ctxt, null)});
            c.dedent();
            c.add("} catch (CifSimulatorException e) {");
            c.indent();
            c.add("throw new CifSimulatorException(\"Evaluation of the initial value of variable \\\"%s\\\" failed.\", e);", new Object[]{CifTextUtils.getAbsName((PositionObject)var)});
            c.dedent();
            c.add("}");
        }
        if (!localVars.isEmpty()) {
            c.add();
        }
        FuncCodeGenerator.gencodeStatements((List<FunctionStatement>)func.getStatements(), c, ctxt);
        c.add("throw new RuntimeException(\"no return at end of func\");");
    }

    private static void gencodeStatements(List<FunctionStatement> statements, CodeBox c, CifCompilerContext ctxt) {
        for (FunctionStatement statement : statements) {
            FuncCodeGenerator.gencodeStatement(statement, c, ctxt);
        }
    }

    private static void gencodeStatement(FunctionStatement statement, CodeBox c, CifCompilerContext ctxt) {
        if (statement instanceof AssignmentFuncStatement) {
            AssignmentFuncStatement asgn = (AssignmentFuncStatement)statement;
            AssignmentCodeGenerator.gencodeAssignment(asgn.getAddressable(), asgn.getValue(), null, c, ctxt, null);
        } else if (statement instanceof BreakFuncStatement) {
            c.add("if (true) break;");
        } else if (statement instanceof ContinueFuncStatement) {
            c.add("if (true) continue;");
        } else if (statement instanceof IfFuncStatement) {
            IfFuncStatement istat = (IfFuncStatement)statement;
            c.add("try {");
            c.indent();
            c.add("b = %s;", new Object[]{ExprCodeGenerator.gencodePreds((List<Expression>)istat.getGuards(), ctxt, null)});
            c.dedent();
            c.add("} catch (CifSimulatorException e) {");
            c.indent();
            c.add("throw new CifSimulatorException(\"Evaluation of \\\"if\\\" statement guard(s) \\\"%s\\\" failed.\", e);", new Object[]{StringEscapeUtils.escapeJava((String)CifTextUtils.exprsToStr((List)istat.getGuards()))});
            c.dedent();
            c.add("}");
            c.add("if (b) {");
            c.indent();
            FuncCodeGenerator.gencodeStatements((List<FunctionStatement>)istat.getThens(), c, ctxt);
            c.dedent();
            for (ElifFuncStatement elif : istat.getElifs()) {
                c.add("} else {");
                c.indent();
                c.add("try {");
                c.indent();
                c.add("b = %s;", new Object[]{ExprCodeGenerator.gencodePreds((List<Expression>)elif.getGuards(), ctxt, null)});
                c.dedent();
                c.add("} catch (CifSimulatorException e) {");
                c.indent();
                c.add("throw new CifSimulatorException(\"Evaluation of \\\"elif\\\" statement guard(s) \\\"%s\\\" failed.\", e);", new Object[]{StringEscapeUtils.escapeJava((String)CifTextUtils.exprsToStr((List)elif.getGuards()))});
                c.dedent();
                c.add("}");
                c.add("if (b) {");
                c.indent();
                FuncCodeGenerator.gencodeStatements((List<FunctionStatement>)elif.getThens(), c, ctxt);
                c.dedent();
            }
            if (!istat.getElses().isEmpty()) {
                c.add("} else {");
                c.indent();
                FuncCodeGenerator.gencodeStatements((List<FunctionStatement>)istat.getElses(), c, ctxt);
                c.dedent();
            }
            int i = 0;
            while (i < istat.getElifs().size()) {
                c.add("}");
                c.dedent();
                ++i;
            }
            c.add("}");
        } else if (statement instanceof ReturnFuncStatement) {
            ReturnFuncStatement rstat = (ReturnFuncStatement)statement;
            Expression retValue = CifValueUtils.makeTuple((List)EMFHelper.deepclone((List)rstat.getValues()));
            c.add("try {");
            c.indent();
            c.add("if (true) return %s;", new Object[]{ExprCodeGenerator.gencodeExpr(retValue, ctxt, null)});
            c.dedent();
            c.add("} catch (CifSimulatorException e) {");
            c.indent();
            c.add("throw new CifSimulatorException(\"Evaluation of return value \\\"%s\\\" failed.\", e);", new Object[]{StringEscapeUtils.escapeJava((String)CifTextUtils.exprToStr((Expression)retValue))});
            c.dedent();
            c.add("}");
        } else if (statement instanceof WhileFuncStatement) {
            WhileFuncStatement wstat = (WhileFuncStatement)statement;
            c.add("while (true) {");
            c.indent();
            c.add("SPEC.ctxt.checkTermination();");
            c.add("try {");
            c.indent();
            c.add("b = %s;", new Object[]{ExprCodeGenerator.gencodePreds((List<Expression>)wstat.getGuards(), ctxt, null)});
            c.dedent();
            c.add("} catch (CifSimulatorException e) {");
            c.indent();
            c.add("throw new CifSimulatorException(\"Evaluation of \\\"while\\\" statement condition(s) \\\"%s\\\" failed.\", e);", new Object[]{StringEscapeUtils.escapeJava((String)CifTextUtils.exprsToStr((List)wstat.getGuards()))});
            c.dedent();
            c.add("}");
            c.add("if (!b) break;");
            FuncCodeGenerator.gencodeStatements((List<FunctionStatement>)wstat.getStatements(), c, ctxt);
            c.dedent();
            c.add("}");
        } else {
            throw new RuntimeException("Unknown func stat: " + statement);
        }
    }

    private static void gencodeBody(ExternalFunction func, CifType retType, CodeBox c, CifCompilerContext ctxt) {
        String extRef = func.getFunction();
        String langName = CifExtFuncUtils.getLangName((String)extRef);
        if (!langName.equals("java")) {
            throw new RuntimeException("Unknown language: " + langName);
        }
        ExtJavaFuncCodeGenerator.gencodeBody(func, retType, c, ctxt);
    }

    public static void gencodeFuncType(FuncType funcType, String className, CifCompilerContext ctxt) {
        JavaCodeFile file = ctxt.addCodeFile(className);
        CodeBox h = file.header;
        h.add("/** Function type \"%s\". */", new Object[]{CifTextUtils.typeToStr((CifType)funcType)});
        h.add("public abstract class %s implements RuntimeToStringable {", new Object[]{className});
        CodeBox c = file.body;
        List paramTxts = Lists.listc((int)funcType.getParamTypes().size());
        EList paramTypes = funcType.getParamTypes();
        int paramIdx = 0;
        while (paramIdx < paramTypes.size()) {
            CifType paramType = (CifType)paramTypes.get(paramIdx);
            String typeTxt = TypeCodeGenerator.gencodeType(paramType, ctxt);
            String name = "p_" + paramIdx;
            paramTxts.add(String.valueOf(typeTxt) + " " + name);
            ++paramIdx;
        }
        c.add("public abstract %s evalFunc(%s);", new Object[]{TypeCodeGenerator.gencodeType(funcType.getReturnType(), ctxt), StringUtils.join((Iterable)paramTxts, (String)", ")});
    }
}

