/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.JavaCodeFile;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class EnumCodeGenerator {
    private EnumCodeGenerator() {
    }

    public static void gencodeEnums(CifCompilerContext ctxt) {
        List names;
        Map<EnumDecl, EnumDecl> reprsMap = ctxt.getEnumReprs();
        Map namesMap = Maps.map();
        for (Map.Entry<EnumDecl, EnumDecl> entry : reprsMap.entrySet()) {
            EnumDecl equalEnum = entry.getKey();
            EnumDecl repr = entry.getValue();
            names = (List)namesMap.get(repr);
            if (names == null) {
                names = Lists.list();
                namesMap.put(repr, names);
            }
            names.add(CifTextUtils.getAbsName((PositionObject)equalEnum));
        }
        for (Map.Entry<Object, Object> entry : namesMap.entrySet()) {
            EnumDecl enumDecl = (EnumDecl)entry.getKey();
            EList lits = enumDecl.getLiterals();
            names = (List)entry.getValue();
            String className = ctxt.getEnumClassName(enumDecl);
            JavaCodeFile file = ctxt.addCodeFile(className);
            CodeBox h = file.header;
            String absName = CifTextUtils.getAbsName((PositionObject)enumDecl);
            h.add("/** Enumeration representative \"%s\", for enumerations:", new Object[]{absName});
            h.add(" * <ul>");
            for (String name : names) {
                h.add(" *  <li>%s</li>", new Object[]{name});
            }
            h.add(" * </ul>");
            h.add(" */");
            h.add("public enum %s implements RuntimeToStringable {", new Object[]{className});
            CodeBox c = file.body;
            int i = 0;
            while (i < lits.size() - 1) {
                c.add("%s,", new Object[]{((EnumLiteral)lits.get(i)).getName()});
                ++i;
            }
            c.add("%s;", new Object[]{((EnumLiteral)Lists.last((List)lits)).getName()});
            c.add();
            c.add("public static String getCifName() {");
            c.indent();
            c.add("return %s;", new Object[]{Strings.stringToJava((String)absName)});
            c.dedent();
            c.add("}");
            c.add();
            c.add("@Override");
            c.add("public String toString() {");
            c.indent();
            c.add("return name();");
            c.dedent();
            c.add("}");
        }
    }

    public static Map<EnumDecl, EnumDecl> getEnumReprs(Specification spec) {
        List enums = Lists.list();
        EnumCodeGenerator.collectEnums((ComplexComponent)spec, enums);
        Map commonMap = Maps.map();
        for (EnumDecl enumDecl : enums) {
            EnumDeclEqHashWrap wrap = new EnumDeclEqHashWrap(enumDecl);
            List commonList = (List)commonMap.get(wrap);
            if (commonList == null) {
                commonList = Lists.list((Object)wrap);
                commonMap.put(wrap, commonList);
                continue;
            }
            commonList.add(wrap);
        }
        Map rslt = Maps.map();
        Set elems = commonMap.entrySet();
        for (Map.Entry elem : elems) {
            EnumDeclEqHashWrap representative = (EnumDeclEqHashWrap)elem.getKey();
            List equalEnums = (List)elem.getValue();
            for (EnumDeclEqHashWrap equalEnum : equalEnums) {
                rslt.put(equalEnum.enumDecl, representative.enumDecl);
            }
        }
        return rslt;
    }

    private static void collectEnums(ComplexComponent comp, List<EnumDecl> enums) {
        for (Declaration decl : comp.getDeclarations()) {
            if (!(decl instanceof EnumDecl)) continue;
            enums.add((EnumDecl)decl);
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                EnumCodeGenerator.collectEnums((ComplexComponent)child, enums);
            }
        }
    }

    private static class EnumDeclEqHashWrap {
        public final EnumDecl enumDecl;
        public final List<String> literals;
        public final int literalsHash;

        public EnumDeclEqHashWrap(EnumDecl enumDecl) {
            this.enumDecl = enumDecl;
            this.literals = CifTypeUtils.getLiteralNames((EnumDecl)enumDecl);
            this.literalsHash = this.literals.hashCode();
        }

        public int hashCode() {
            return this.literalsHash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            EnumDeclEqHashWrap other = (EnumDeclEqHashWrap)obj;
            return this.literals.equals(other.literals);
        }
    }
}

