/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.api.part;

import com.google.common.collect.Iterables;
import java.util.Iterator;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.util.Proxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.MappingHelper;
import org.eclipse.sirius.diagram.business.internal.query.DDiagramElementContainerExperimentalQuery;
import org.eclipse.sirius.diagram.business.internal.query.DNodeContainerExperimentalQuery;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramElementContainerEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramContainerEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.CommonEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.PortLayoutHelper;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.ResetOriginEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDiagramElementContainerNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.DNodeContainerItemSemanticEditPolicy;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.layout.LayoutUtils;
import org.eclipse.sirius.diagram.ui.tools.api.policy.CompoundEditPolicy;
import org.eclipse.sirius.diagram.ui.tools.internal.ui.NoCopyDragEditPartsTrackerEx;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.gmf.runtime.diagram.ui.tools.RubberbandDragTracker;
import org.eclipse.sirius.viewpoint.description.style.LabelBorderStyleDescription;

public abstract class AbstractDiagramContainerEditPart
extends AbstractDiagramElementContainerEditPart
implements IDiagramContainerEditPart {
    public AbstractDiagramContainerEditPart(View view) {
        super(view);
    }

    @Override
    public Class<?> getMetamodelType() {
        return DNodeContainer.class;
    }

    public boolean isRegionContainer() {
        DDiagramElement ddiagramElement = this.resolveDiagramElement();
        if (ddiagramElement instanceof DNodeContainer) {
            DNodeContainer ddec = (DNodeContainer)ddiagramElement;
            return new DNodeContainerExperimentalQuery(ddec).isRegionContainer();
        }
        return false;
    }

    public Command getCommand(Request request) {
        Command result = null;
        if (request.getType() != null && "paste".equals(request.getType())) {
            Iterable shapeCompartmentChildren = Iterables.filter((Iterable)this.children, ShapeCompartmentEditPart.class);
            if (shapeCompartmentChildren.iterator().hasNext()) {
                ShapeCompartmentEditPart lastShapeCompartmentEditPart = (ShapeCompartmentEditPart)Iterables.getLast((Iterable)shapeCompartmentChildren);
                result = lastShapeCompartmentEditPart.getCommand(request);
            }
            if (result == null) {
                result = super.getCommand(request);
            }
        } else {
            Command cmd = super.getCommand(request);
            result = CommonEditPartOperation.handleAutoPinOnInteractiveMove(this, request, cmd);
        }
        return result;
    }

    protected Command getPortCreationCommand(Command originalCommand, CreateViewRequest request) {
        CompositeCommand compositeCommand = new CompositeCommand(Messages.IAbstractDiagramNodeEditPart_createViewCommandLabel);
        compositeCommand.compose((IUndoableOperation)new CommandProxy(originalCommand));
        Iterator iterDescriptor = request.getViewDescriptors().iterator();
        LayoutUtils.prepareFigureForDummyAdds(this.getBorderedFigure().getBorderItemContainer());
        while (iterDescriptor.hasNext()) {
            EObject containerSemanticElement;
            Object createdElement;
            CreateViewRequest.ViewDescriptor viewDescriptor = (CreateViewRequest.ViewDescriptor)iterDescriptor.next();
            IAdaptable adapt = viewDescriptor.getElementAdapter();
            if (!(adapt instanceof Proxy) || !((createdElement = ((Proxy)adapt).getRealObject()) instanceof DNode) || !MappingHelper.getAllBorderedNodeMappings((AbstractNodeMapping)((DDiagramElementContainer)(containerSemanticElement = this.resolveSemanticElement())).getActualMapping()).contains((Object)((DNode)createdElement).getActualMapping())) continue;
            Rectangle bounds = PortLayoutHelper.getBounds(this, (DNode)createdElement, viewDescriptor, (DDiagramElement)containerSemanticElement);
            viewDescriptor.setPersisted(true);
            compositeCommand.compose((IUndoableOperation)new SetBoundsCommand(this.getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)viewDescriptor, bounds));
            compositeCommand.compose((IUndoableOperation)SiriusLayoutDataManager.INSTANCE.getAddAdapterMakerCommand(this.getEditingDomain(), (IAdaptable)viewDescriptor));
        }
        LayoutUtils.releaseDummys(this.getBorderedFigure().getBorderItemContainer());
        return new ICommandProxy(compositeCommand.reduce());
    }

    public DragTracker getDragTracker(Request request) {
        if (request instanceof SelectionRequest && ((SelectionRequest)request).isAltKeyPressed()) {
            return new RubberbandDragTracker();
        }
        return new NoCopyDragEditPartsTrackerEx((EditPart)this);
    }

    protected void performDirectEditRequest(Request request) {
        if (request instanceof DirectEditRequest) {
            Request req = new Request();
            req.setType((Object)"direct edit");
            super.performDirectEditRequest(req);
        } else if ("direct edit".equals(request.getType())) {
            super.performDirectEditRequest(request);
        }
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new DNodeContainerItemSemanticEditPolicy());
        this.removeEditPolicy("ConnectionHandlesPolicy");
        EditPolicy currentComponentEditPolicy = this.getEditPolicy("ComponentEditPolicy");
        if (currentComponentEditPolicy instanceof CompoundEditPolicy) {
            ResetOriginEditPolicy resetOriginEditPolicy = new ResetOriginEditPolicy();
            resetOriginEditPolicy.setHost((EditPart)this);
            ((CompoundEditPolicy)currentComponentEditPolicy).addEditPolicy((EditPolicy)resetOriginEditPolicy);
        } else {
            CompoundEditPolicy compoundEditPolicy = new CompoundEditPolicy();
            compoundEditPolicy.addEditPolicy(currentComponentEditPolicy);
            compoundEditPolicy.addEditPolicy((EditPolicy)new ResetOriginEditPolicy());
            this.installEditPolicy("ComponentEditPolicy", compoundEditPolicy);
        }
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        IFigure pane = null;
        pane = editPart instanceof IBorderItemEditPart ? this.getBorderedFigure().getBorderItemContainer() : (editPart instanceof AbstractDiagramElementContainerNameEditPart || this.isRegionContainer() || this.hasFullLabelBorder() ? this.getContentPane() : super.getContentPaneFor(editPart));
        return pane;
    }

    private boolean hasFullLabelBorder() {
        EObject element = this.resolveSemanticElement();
        if (element instanceof DDiagramElementContainer) {
            Option labelBorderStyle = new DDiagramElementContainerExperimentalQuery((DDiagramElementContainer)element).getLabelBorderStyle();
            return labelBorderStyle.some() && "labelBorderForContainer".equals(((LabelBorderStyleDescription)labelBorderStyle.get()).getId());
        }
        return false;
    }

    @Override
    protected void handleNotificationEvent(Notification notification) {
        if (DiagramPackage.eINSTANCE.getDNodeContainer_ChildrenPresentation().equals(notification.getFeature())) {
            this.handleMajorSemanticChange();
        } else {
            super.handleNotificationEvent(notification);
        }
    }
}

