/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.equivalence;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.eclipse.escet.cif.eventbased.automata.Automaton;
import org.eclipse.escet.cif.eventbased.automata.Edge;
import org.eclipse.escet.cif.eventbased.automata.Event;
import org.eclipse.escet.cif.eventbased.automata.Location;
import org.eclipse.escet.cif.eventbased.equivalence.Block;
import org.eclipse.escet.cif.eventbased.equivalence.BlockLocation;
import org.eclipse.escet.cif.eventbased.equivalence.CounterExample;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;

public abstract class BlockPartitioner {
    public final List<Automaton> automs;
    public final Event[] events;
    public final Map<Location, BlockLocation> blockLocs = Maps.map();
    public List<Block> blocks = Lists.list();
    private Queue<Integer> notDone = new ArrayDeque<Integer>();
    private final boolean requireAllAutomata;

    public BlockPartitioner(List<Automaton> automs, boolean requireAllAutomata) {
        this.automs = automs;
        this.requireAllAutomata = requireAllAutomata;
        Set events = Sets.set();
        for (Automaton aut : automs) {
            events.addAll(aut.alphabet);
        }
        this.events = new Event[events.size()];
        events.toArray(this.events);
    }

    public CounterExample performBlockPartitioning() {
        Block[] blks = new Block[]{this.makeBlock(-1, null), this.makeBlock(-1, null)};
        int autNum = 0;
        while (autNum < this.automs.size()) {
            this.addAutomaton(this.automs.get(autNum), autNum, blks);
            ++autNum;
        }
        if (!blks[0].locs.isEmpty()) {
            if (this.requireAllAutomata && !blks[0].allAutomataPresent(this.automs.size())) {
                return this.constructCounterExample(blks[0], null);
            }
            this.blocks.add(blks[0]);
            this.markBlockForReview(0);
        }
        if (!blks[1].locs.isEmpty()) {
            if (this.requireAllAutomata && !blks[1].allAutomataPresent(this.automs.size())) {
                return this.constructCounterExample(blks[1], null);
            }
            this.blocks.add(blks[1]);
            if (this.blocks.size() == 2) {
                this.markBlockForReview(1);
            } else {
                for (BlockLocation bl : blks[1].locs) {
                    bl.blockNumber = 0;
                }
                this.markBlockForReview(0);
            }
        }
        this.dumpPartition("Initial partition (based on marking)");
        while (!this.notDone.isEmpty()) {
            CounterExample example;
            int num = this.notDone.poll();
            if (OutputProvider.dodbg()) {
                OutputProvider.dbg((String)"Reviewing block %s", (Object[])new Object[]{num});
                OutputProvider.dbg();
            }
            if ((example = this.reviewBlock(num)) != null) {
                this.dumpPartition("Partition counter-example");
                return example;
            }
            if (this.notDone.isEmpty()) continue;
            this.dumpPartition("Intermediate partition");
        }
        this.dumpPartition("Partition finished (no counter-example)");
        return null;
    }

    private void dumpPartition(String name) {
        if (!OutputProvider.dodbg()) {
            return;
        }
        OutputProvider.dbg((String)(String.valueOf(name) + ":"));
        OutputProvider.idbg();
        int blkNum = 0;
        while (blkNum < this.blocks.size()) {
            Block blk = this.blocks.get(blkNum);
            String s = Strings.fmt((String)"Block %d:", (Object[])new Object[]{blkNum});
            for (BlockLocation bloc : blk.locs) {
                Location loc = bloc.loc;
                s = String.valueOf(s) + Strings.fmt((String)" %s", (Object[])new Object[]{loc.origin});
            }
            OutputProvider.dbg((String)s);
            s = "";
            int evtNum = 0;
            while (evtNum < this.events.length) {
                String t = "";
                for (Integer inBlk : blk.inEvents.get(evtNum)) {
                    if (!t.isEmpty()) {
                        t = String.valueOf(t) + ", ";
                    }
                    t = String.valueOf(t) + Strings.fmt((String)"%s", (Object[])new Object[]{inBlk});
                }
                if (!s.isEmpty()) {
                    s = String.valueOf(s) + ", ";
                }
                s = String.valueOf(s) + Strings.fmt((String)"%s -> [%s]", (Object[])new Object[]{this.events[evtNum].name, t});
                ++evtNum;
            }
            OutputProvider.dbg((String)("Input: " + s));
            s = "";
            evtNum = 0;
            while (evtNum < this.events.length) {
                Integer out;
                if (!s.isEmpty()) {
                    s = String.valueOf(s) + ", ";
                }
                s = (out = blk.outEvents[evtNum]) == null ? String.valueOf(s) + Strings.fmt((String)"%s -> ?", (Object[])new Object[]{this.events[evtNum].name}) : String.valueOf(s) + Strings.fmt((String)"%s -> %s", (Object[])new Object[]{this.events[evtNum].name, out});
                ++evtNum;
            }
            OutputProvider.dbg((String)("Output: " + s));
            OutputProvider.dbg();
            ++blkNum;
        }
        OutputProvider.ddbg();
    }

    private void addAutomaton(Automaton aut, int autNum, Block[] blks) {
        Assert.check((aut.initial != null ? 1 : 0) != 0);
        ArrayDeque<BlockLocation> toAdd = new ArrayDeque<BlockLocation>();
        int blknum = aut.initial.marked ? 1 : 0;
        BlockLocation initialBlkLoc = new BlockLocation(aut.initial, autNum, 0, blknum);
        this.blockLocs.put(initialBlkLoc.loc, initialBlkLoc);
        blks[blknum].locs.add(initialBlkLoc);
        toAdd.add(initialBlkLoc);
        while (!toAdd.isEmpty()) {
            BlockLocation blkLoc = (BlockLocation)toAdd.poll();
            Edge edge = blkLoc.loc.outgoingEdges;
            int nxtDepth = blkLoc.depth + 1;
            while (edge != null) {
                Location nxt = edge.dstLoc;
                if (this.blockLocs.containsKey(nxt)) {
                    edge = edge.nextOutgoing;
                    continue;
                }
                blknum = nxt.marked ? 1 : 0;
                BlockLocation nxtBlkLoc = new BlockLocation(nxt, autNum, nxtDepth, blknum);
                this.blockLocs.put(nxt, nxtBlkLoc);
                blks[blknum].locs.add(nxtBlkLoc);
                toAdd.add(nxtBlkLoc);
                edge = edge.nextOutgoing;
            }
        }
    }

    private CounterExample reviewBlock(int blkIndex) {
        Block blk = this.blocks.get(blkIndex);
        Assert.check((boolean)blk.needsReview);
        blk.needsReview = false;
        Map succBlocks = Maps.map();
        int evtIndex = 0;
        while (evtIndex < this.events.length) {
            if (blk.outEvents[evtIndex] == null) {
                Event evt = this.events[evtIndex];
                succBlocks.clear();
                for (BlockLocation bl : blk.locs) {
                    List succBlkLocs;
                    int nextBlock = -1;
                    Iterator<Edge> iterator = bl.loc.getOutgoing(evt).iterator();
                    if (iterator.hasNext()) {
                        Edge e = iterator.next();
                        BlockLocation dstBlkLoc = this.blockLocs.get(e.dstLoc);
                        nextBlock = dstBlkLoc.blockNumber;
                    }
                    if ((succBlkLocs = (List)succBlocks.get(nextBlock)) == null) {
                        succBlkLocs = Lists.list();
                        succBlocks.put(nextBlock, succBlkLocs);
                    }
                    succBlkLocs.add(bl);
                }
                if (succBlocks.size() == 1) {
                    Integer succBlk;
                    blk.outEvents[evtIndex] = succBlk = (Integer)succBlocks.keySet().iterator().next();
                    if (succBlk >= 0) {
                        this.blocks.get((int)succBlk.intValue()).inEvents.get(evtIndex).add(blkIndex);
                    }
                } else {
                    Assert.check((succBlocks.size() > 1 ? 1 : 0) != 0);
                    this.invalidateIncoming(blk, blkIndex);
                    this.unlinkOutgoing(blk, blkIndex);
                    boolean first = true;
                    for (Map.Entry succBlkEntry : succBlocks.entrySet()) {
                        int newBlocknum;
                        Block newBlock = this.makeBlock(((List)succBlkEntry.getValue()).size(), Arrays.copyOf(blk.outEvents, blk.outEvents.length));
                        if (first) {
                            this.blocks.set(blkIndex, newBlock);
                            newBlocknum = blkIndex;
                            first = false;
                        } else {
                            newBlocknum = this.blocks.size();
                            this.blocks.add(newBlock);
                        }
                        for (BlockLocation bl : (List)succBlkEntry.getValue()) {
                            bl.blockNumber = newBlocknum;
                            newBlock.locs.add(bl);
                        }
                        if (this.requireAllAutomata && !newBlock.allAutomataPresent(this.automs.size())) {
                            return this.constructCounterExample(newBlock, evt);
                        }
                        int destBlk = (Integer)succBlkEntry.getKey();
                        if (destBlk != blkIndex) {
                            newBlock.outEvents[evtIndex] = destBlk;
                        }
                        this.reconnectOutgoing(newBlock, newBlocknum);
                        this.markBlockForReview(newBlocknum);
                    }
                    Assert.check((!blk.needsReview ? 1 : 0) != 0);
                    return null;
                }
            }
            ++evtIndex;
        }
        return null;
    }

    private Block makeBlock(int numLocs, Integer[] outgoing) {
        if (outgoing == null) {
            outgoing = new Integer[this.events.length];
        }
        return new Block(this.events.length, numLocs, outgoing);
    }

    private void invalidateIncoming(Block blk, int skipReview) {
        int evtIndex = 0;
        while (evtIndex < this.events.length) {
            for (int pred : blk.inEvents.get(evtIndex)) {
                Block predBlock = this.blocks.get(pred);
                predBlock.outEvents[evtIndex] = null;
                if (pred == skipReview) continue;
                this.markBlockForReview(pred);
            }
            ++evtIndex;
        }
    }

    public void unlinkOutgoing(Block badBlk, int badBlocknum) {
        int evtIndex = 0;
        while (evtIndex < this.events.length) {
            int succBlkIdx;
            Integer succBlkIndex = badBlk.outEvents[evtIndex];
            if (succBlkIndex != null && (succBlkIdx = succBlkIndex.intValue()) != -1) {
                if (succBlkIdx == badBlocknum) {
                    badBlk.outEvents[evtIndex] = null;
                } else {
                    Block succBlk = this.blocks.get(succBlkIdx);
                    List<Integer> incomingBlknums = succBlk.inEvents.get(evtIndex);
                    int lastIndex = incomingBlknums.size() - 1;
                    int idx = 0;
                    while (idx <= lastIndex) {
                        if (incomingBlknums.get(idx) == badBlocknum) break;
                        ++idx;
                    }
                    Assert.check((idx <= lastIndex ? 1 : 0) != 0);
                    if (idx < lastIndex) {
                        incomingBlknums.set(idx, incomingBlknums.get(lastIndex));
                    }
                    incomingBlknums.remove(lastIndex);
                }
            }
            ++evtIndex;
        }
    }

    private void reconnectOutgoing(Block newBlk, int newBlocknum) {
        int evtIndex = 0;
        while (evtIndex < this.events.length) {
            Integer succBlkIndex = newBlk.outEvents[evtIndex];
            if (succBlkIndex != null && succBlkIndex != -1) {
                Block succBlk = this.blocks.get(succBlkIndex);
                succBlk.inEvents.get(evtIndex).add(newBlocknum);
            }
            ++evtIndex;
        }
    }

    private void markBlockForReview(int blkIndex) {
        Block blk = this.blocks.get(blkIndex);
        if (!blk.needsReview) {
            this.notDone.add(blkIndex);
            blk.needsReview = true;
        }
    }

    protected abstract CounterExample constructCounterExample(Block var1, Event var2);
}

