/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.apps;

import java.util.List;
import java.util.Set;
import org.eclipse.escet.cif.eventbased.AutomatonAbstraction;
import org.eclipse.escet.cif.eventbased.apps.conversion.ApplicationHelper;
import org.eclipse.escet.cif.eventbased.apps.conversion.ConvertFromEventBased;
import org.eclipse.escet.cif.eventbased.apps.conversion.ConvertToEventBased;
import org.eclipse.escet.cif.eventbased.apps.options.ObservedEventsOption;
import org.eclipse.escet.cif.eventbased.apps.options.ResultNameOption;
import org.eclipse.escet.cif.eventbased.automata.Automaton;
import org.eclipse.escet.cif.eventbased.automata.Event;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.io.CifWriter;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.exceptions.ApplicationException;
import org.eclipse.escet.common.app.framework.exceptions.InvalidInputException;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.OutputFileOption;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class AutomatonAbstractionApplication
extends Application<IOutputComponent> {
    public static void main(String[] args) {
        AutomatonAbstractionApplication app = new AutomatonAbstractionApplication();
        app.run(args);
    }

    public AutomatonAbstractionApplication() {
    }

    public AutomatonAbstractionApplication(AppStreams streams) {
        super(streams);
    }

    private OptionCategory getTransformationOptionPage() {
        List subPages = Lists.list();
        List options = Lists.list();
        options.add(Options.getInstance(InputFileOption.class));
        options.add(Options.getInstance(ObservedEventsOption.class));
        options.add(Options.getInstance(OutputFileOption.class));
        options.add(Options.getInstance(ResultNameOption.class));
        return new OptionCategory("Automaton abstraction", "CIF event-based automaton abstraction options.", subPages, options);
    }

    protected OptionCategory getAllOptions() {
        List subPages = Lists.list();
        subPages.add(this.getTransformationOptionPage());
        subPages.add(AutomatonAbstractionApplication.getGeneralOptionCategory());
        List options = Lists.list();
        String optDesc = "All options for the event-based automaton abstraction tool.";
        return new OptionCategory("Event-based automaton abstraction options", optDesc, subPages, options);
    }

    protected OutputProvider<IOutputComponent> getProvider() {
        return new OutputProvider();
    }

    protected int runInternal() {
        String resultName;
        Specification spec;
        CifReader cifReader;
        block12: {
            Automaton aut;
            block11: {
                Set<Event> obses;
                block10: {
                    ConvertToEventBased cte;
                    block9: {
                        block8: {
                            try {
                                OutputProvider.dbg((String)"Loading CIF specification \"%s\"...", (Object[])new Object[]{InputFileOption.getPath()});
                                cifReader = (CifReader)new CifReader().init();
                                spec = (Specification)cifReader.read();
                                if (!this.isTerminationRequested()) break block8;
                                return 0;
                            }
                            catch (ApplicationException e) {
                                String msg = Strings.fmt((String)"Failed to compute automaton abstraction for CIF file \"%s\".", (Object[])new Object[]{InputFileOption.getPath()});
                                throw new ApplicationException(msg, (Throwable)e);
                            }
                        }
                        OutputProvider.dbg((String)"Converting to internal representation...");
                        cte = new ConvertToEventBased();
                        cte.convertSpecification(spec, true);
                        if (!this.isTerminationRequested()) break block9;
                        return 0;
                    }
                    if (cte.automata.size() != 1) {
                        String msg = Strings.fmt((String)"CIF input file contains %d automata, while automaton abstraction requires a file with exactly one automaton.", (Object[])new Object[]{cte.automata.size()});
                        throw new InvalidInputException(msg);
                    }
                    aut = cte.automata.get(0);
                    OutputProvider.dbg((String)"Abstracting automaton...");
                    String[] obsNms = ObservedEventsOption.getEvents();
                    obses = ApplicationHelper.selectEvents(obsNms, aut.alphabet);
                    AutomatonAbstraction.automatonAbstractionPreCheck(aut, obses);
                    if (!this.isTerminationRequested()) break block10;
                    return 0;
                }
                aut = AutomatonAbstraction.automatonAbstraction(aut, obses);
                if (!this.isTerminationRequested()) break block11;
                return 0;
            }
            OutputProvider.dbg((String)"Converting from internal representation...");
            resultName = "abstracted";
            resultName = ResultNameOption.getRsltName(resultName);
            ConvertFromEventBased cfe = new ConvertFromEventBased();
            spec = cfe.convertAutomaton(aut, resultName);
            if (!this.isTerminationRequested()) break block12;
            return 0;
        }
        String outPath = "_" + resultName + ".cif";
        outPath = OutputFileOption.getDerivedPath((String)".cif", (String)outPath);
        OutputProvider.dbg((String)"Writing result to \"%s\"...", (Object[])new Object[]{outPath});
        outPath = Paths.resolve((String)outPath);
        CifWriter.writeCifSpec((Specification)spec, (String)outPath, (String)cifReader.getAbsDirPath());
        return 0;
    }

    public String getAppName() {
        return "CIF automaton abstraction tool";
    }

    public String getAppDescription() {
        return "Abstracts an automaton to a set of observable events.";
    }
}

