/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import org.eclipse.escet.cif.common.CifExtFuncUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.ComponentDef;
import org.eclipse.escet.cif.metamodel.cif.ComponentInst;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.IoDecl;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgCopy;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgFile;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgIn;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgMove;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgOut;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.functions.ExternalFunction;
import org.eclipse.escet.cif.metamodel.cif.print.Print;
import org.eclipse.escet.cif.metamodel.cif.print.PrintFile;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.java.Assert;

public class CifRelativePathUtils {
    private CifRelativePathUtils() {
    }

    public static void adaptRelativePaths(ComplexComponent component, String oldPath, String newPath) {
        for (Declaration decl : component.getDeclarations()) {
            if (!(decl instanceof ExternalFunction)) continue;
            CifRelativePathUtils.adaptRelativePaths((ExternalFunction)decl, oldPath, newPath);
        }
        for (IoDecl ioDecl : component.getIoDecls()) {
            CifRelativePathUtils.adaptRelativePaths(ioDecl, oldPath, newPath);
        }
        if (component instanceof Group) {
            Group group = (Group)component;
            for (Component child : group.getComponents()) {
                if (child instanceof ComplexComponent) {
                    CifRelativePathUtils.adaptRelativePaths((ComplexComponent)child, oldPath, newPath);
                    continue;
                }
                Assert.check((boolean)(child instanceof ComponentInst));
            }
            for (ComponentDef cdef : group.getDefinitions()) {
                CifRelativePathUtils.adaptRelativePaths(cdef.getBody(), oldPath, newPath);
            }
        }
    }

    public static void adaptRelativePaths(ExternalFunction func, String oldPath, String newPath) {
        String extRef = func.getFunction();
        extRef = CifExtFuncUtils.updateExtRefRelPaths(extRef, oldPath, newPath);
        func.setFunction(extRef);
    }

    public static void adaptRelativePaths(IoDecl ioDecl, String oldPath, String newPath) {
        if (ioDecl instanceof SvgFile) {
            SvgFile svgFile = (SvgFile)ioDecl;
            String path = svgFile.getPath();
            path = Paths.resolve((String)path, (String)oldPath);
            path = Paths.getRelativePath((String)path, (String)newPath);
            svgFile.setPath(path);
        } else if (ioDecl instanceof SvgCopy) {
            SvgCopy svgCopy = (SvgCopy)ioDecl;
            SvgFile svgFile = svgCopy.getSvgFile();
            if (svgFile == null) {
                return;
            }
            CifRelativePathUtils.adaptRelativePaths((IoDecl)svgFile, oldPath, newPath);
        } else if (ioDecl instanceof SvgMove) {
            SvgMove svgMove = (SvgMove)ioDecl;
            SvgFile svgFile = svgMove.getSvgFile();
            if (svgFile == null) {
                return;
            }
            CifRelativePathUtils.adaptRelativePaths((IoDecl)svgFile, oldPath, newPath);
        } else if (ioDecl instanceof SvgOut) {
            SvgOut svgOut = (SvgOut)ioDecl;
            SvgFile svgFile = svgOut.getSvgFile();
            if (svgFile == null) {
                return;
            }
            CifRelativePathUtils.adaptRelativePaths((IoDecl)svgFile, oldPath, newPath);
        } else if (ioDecl instanceof SvgIn) {
            SvgIn svgIn = (SvgIn)ioDecl;
            SvgFile svgFile = svgIn.getSvgFile();
            if (svgFile == null) {
                return;
            }
            CifRelativePathUtils.adaptRelativePaths((IoDecl)svgFile, oldPath, newPath);
        } else if (ioDecl instanceof PrintFile) {
            PrintFile printFile = (PrintFile)ioDecl;
            String path = printFile.getPath();
            if (path.startsWith(":")) {
                return;
            }
            path = Paths.resolve((String)path, (String)oldPath);
            path = Paths.getRelativePath((String)path, (String)newPath);
            printFile.setPath(path);
        } else if (ioDecl instanceof Print) {
            Print print = (Print)ioDecl;
            PrintFile printFile = print.getFile();
            if (printFile == null) {
                return;
            }
            CifRelativePathUtils.adaptRelativePaths((IoDecl)printFile, oldPath, newPath);
        } else {
            throw new RuntimeException("Unknown I/O decl: " + ioDecl);
        }
    }
}

