/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.generator.parser;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.escet.common.app.framework.io.AppStream;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.setext.generator.parser.GrammarItem;
import org.eclipse.escet.setext.generator.parser.LALR1ParserGenerator;
import org.eclipse.escet.setext.generator.parser.LookaheadItem;
import org.eclipse.escet.setext.generator.parser.ParserAcceptAction;
import org.eclipse.escet.setext.generator.parser.ParserAction;
import org.eclipse.escet.setext.generator.parser.ParserReduceAction;
import org.eclipse.escet.setext.generator.parser.ParserShiftAction;
import org.eclipse.escet.setext.generator.parser.PropagationItem;
import org.eclipse.escet.setext.parser.ast.Symbol;
import org.eclipse.escet.setext.parser.ast.parser.NonTerminal;
import org.eclipse.escet.setext.parser.ast.parser.ParserRule;
import org.eclipse.escet.setext.parser.ast.scanner.Terminal;

public class LALR1AutomatonState {
    public Map<GrammarItem, LookaheadItem> items;
    public Set<LookaheadItem> itemsClosure;
    public Map<GrammarItem, Set<PropagationItem>> propagations = Maps.map();
    public final int id;
    public Map<Symbol, LALR1AutomatonState> edges = Maps.map();
    public Map<Terminal, Set<ParserAction>> actions = Maps.map();
    public Map<NonTerminal, LALR1AutomatonState> gotos = Maps.map();
    public Symbol entrySymbol;

    public LALR1AutomatonState(Map<GrammarItem, LookaheadItem> items, int id) {
        this.items = items;
        this.id = id;
        Assert.check((!items.isEmpty() ? 1 : 0) != 0);
        for (LookaheadItem item : items.values()) {
            Assert.check((boolean)item.item.isKernelItem());
        }
        Assert.check((id >= 0 ? 1 : 0) != 0);
    }

    public void addEdge(Symbol symbol, LALR1AutomatonState state) {
        if (this.edges.containsKey(symbol)) {
            throw new IllegalStateException("Duplicate edge.");
        }
        this.edges.put(symbol, state);
        if (state.entrySymbol == null) {
            state.entrySymbol = symbol;
        } else {
            Assert.check((state.entrySymbol == symbol ? 1 : 0) != 0);
        }
    }

    public List<Pair<Symbol, LALR1AutomatonState>> getSortedEdges() {
        List sortedEdges = Lists.list();
        for (Map.Entry<Symbol, LALR1AutomatonState> entry : this.edges.entrySet()) {
            sortedEdges.add(Pair.pair((Object)entry.getKey(), (Object)entry.getValue()));
        }
        Comparator<Pair<Symbol, LALR1AutomatonState>> cmp = new Comparator<Pair<Symbol, LALR1AutomatonState>>(){

            @Override
            public int compare(Pair<Symbol, LALR1AutomatonState> t1, Pair<Symbol, LALR1AutomatonState> t2) {
                int targetId1 = ((LALR1AutomatonState)t1.right).id;
                int targetId2 = ((LALR1AutomatonState)t2.right).id;
                if (targetId1 < targetId2) {
                    return -1;
                }
                if (targetId1 > targetId2) {
                    return 1;
                }
                return Strings.SORTER.compare(((Symbol)t1.left).name, ((Symbol)t2.left).name);
            }
        };
        Collections.sort(sortedEdges, cmp);
        return sortedEdges;
    }

    public List<Pair<Terminal, ParserAction>> getSortedActions(final List<Terminal> terminals, final List<NonTerminal> nonterminals) {
        List sortedActions = Lists.list();
        for (Map.Entry<Terminal, Set<ParserAction>> entry : this.actions.entrySet()) {
            Set<ParserAction> entryActs = entry.getValue();
            Assert.check((entryActs.size() == 1 ? 1 : 0) != 0);
            sortedActions.add(Pair.pair((Object)entry.getKey(), (Object)entryActs.iterator().next()));
        }
        Comparator<Pair<Terminal, ParserAction>> cmp = new Comparator<Pair<Terminal, ParserAction>>(){

            @Override
            public int compare(Pair<Terminal, ParserAction> t1, Pair<Terminal, ParserAction> t2) {
                ParserAction act1 = (ParserAction)t1.right;
                ParserAction act2 = (ParserAction)t2.right;
                int c = Integer.valueOf(act1.getType()).compareTo(act2.getType());
                if (c != 0) {
                    return c;
                }
                if (act1 instanceof ParserShiftAction) {
                    int target1 = ((ParserShiftAction)act1).target.id;
                    int target2 = ((ParserShiftAction)act2).target.id;
                    c = Integer.valueOf(target1).compareTo(target2);
                    if (c != 0) {
                        return c;
                    }
                }
                if (act1 instanceof ParserReduceAction) {
                    NonTerminal nt1 = ((ParserReduceAction)act1).nonterminal;
                    NonTerminal nt2 = ((ParserReduceAction)act2).nonterminal;
                    int idx1 = nonterminals.indexOf(nt1);
                    int idx2 = nonterminals.indexOf(nt2);
                    c = Integer.valueOf(idx1).compareTo(idx2);
                    if (c != 0) {
                        return c;
                    }
                    ParserRule rule1 = ((ParserReduceAction)act1).rule;
                    ParserRule rule2 = ((ParserReduceAction)act2).rule;
                    idx1 = nt1.rules.indexOf(rule1);
                    idx2 = nt2.rules.indexOf(rule2);
                    c = Integer.valueOf(idx1).compareTo(idx2);
                    if (c != 0) {
                        return c;
                    }
                }
                int termIdx1 = terminals.indexOf(t1.left);
                int termIdx2 = terminals.indexOf(t2.left);
                return Integer.valueOf(termIdx1).compareTo(termIdx2);
            }
        };
        Collections.sort(sortedActions, cmp);
        return sortedActions;
    }

    public void print(AppStream s, boolean initial) {
        List itemTxts = Lists.list();
        for (LookaheadItem item : this.items.values()) {
            itemTxts.add(item.toString());
        }
        Collections.sort(itemTxts, Strings.SORTER);
        s.println(Strings.fmt((String)"%sstate %d (%s):", (Object[])new Object[]{initial ? "initial " : "", this.id, itemTxts}));
        List<Pair<Symbol, LALR1AutomatonState>> edges = this.getSortedEdges();
        for (Pair<Symbol, LALR1AutomatonState> edge : edges) {
            Symbol symbol = (Symbol)edge.left;
            LALR1AutomatonState target = (LALR1AutomatonState)edge.right;
            String edgeTxt = String.valueOf(symbol.name) + " -> " + target.id;
            s.println("  " + edgeTxt);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void printTable(AppStream s, boolean initial, LALR1ParserGenerator generator) {
        s.println(Strings.fmt((String)"%sstate %d:", (Object[])new Object[]{initial ? "initial " : "", this.id}));
        List kernelTxts = Lists.list();
        List nonKernelTxts = Lists.list();
        for (LookaheadItem item : this.itemsClosure) {
            if (item.item.isKernelItem()) {
                kernelTxts.add(item.toString(true));
                continue;
            }
            nonKernelTxts.add(item.toString(true));
        }
        Collections.sort(kernelTxts, Strings.SORTER);
        Collections.sort(nonKernelTxts, Strings.SORTER);
        for (String itemTxt : kernelTxts) {
            s.println("  + " + itemTxt);
        }
        for (String itemTxt : nonKernelTxts) {
            s.println("  - " + itemTxt);
        }
        s.println();
        List terminals = Sets.sortedgeneric(this.actions.keySet(), (Comparator)Terminal.NAME_COMPARER);
        int maxTermLen = 1;
        for (Terminal terminal : terminals) {
            if (terminal.name == null) continue;
            maxTermLen = Math.max(maxTermLen, terminal.name.length());
        }
        List shiftTxts = Lists.list();
        List reduceTxts = Lists.list();
        List acceptTxts = Lists.list();
        boolean stateHasConflicts = false;
        for (Terminal terminal : terminals) {
            void var14_19;
            String string = terminal.name;
            if (string == null && terminal.isEof()) {
                String string2 = "\u00b6";
            }
            Assert.notNull((Object)var14_19);
            String string3 = StringUtils.rightPad((String)var14_19, (int)maxTermLen);
            Set<ParserAction> terminalActs = this.actions.get(terminal);
            boolean conflict = terminalActs.size() > 1;
            int shifts = 0;
            int reduces = 0;
            int accepts = 0;
            for (ParserAction action : terminalActs) {
                String txt = String.valueOf(string3) + " -> " + action.toString();
                String prefix = conflict ? "! " : "  ";
                txt = String.valueOf(prefix) + txt;
                if (action instanceof ParserShiftAction) {
                    ++shifts;
                    shiftTxts.add(txt);
                    continue;
                }
                if (action instanceof ParserReduceAction) {
                    ++reduces;
                    reduceTxts.add(txt);
                    continue;
                }
                Assert.check((boolean)(action instanceof ParserAcceptAction));
                ++accepts;
                acceptTxts.add(txt);
            }
            if (!conflict) continue;
            stateHasConflicts = true;
            ++generator.conflicts;
            if (shifts > 0 && reduces > 0) {
                ++generator.shiftReduceConflicts;
                Assert.check((accepts == 0 ? 1 : 0) != 0);
                s.println("! shift/reduce conflict on " + string3.trim());
                OutputProvider.warn((String)"shift/reduce conflict on %s in state %d.", (Object[])new Object[]{string3.trim(), this.id});
                continue;
            }
            if (reduces > 0 && accepts > 0) {
                ++generator.acceptReduceConflicts;
                Assert.check((shifts == 0 ? 1 : 0) != 0);
                s.println("! accept/reduce conflict on " + string3.trim());
                OutputProvider.warn((String)"accept/reduce conflict on %s in state %d.", (Object[])new Object[]{string3.trim(), this.id});
                continue;
            }
            ++generator.reduceReduceConflicts;
            Assert.check((shifts == 0 ? 1 : 0) != 0);
            Assert.check((accepts == 0 ? 1 : 0) != 0);
            s.println("! reduce/reduce conflict on " + string3.trim());
            OutputProvider.warn((String)"reduce/reduce conflict on %s in state %d.", (Object[])new Object[]{string3.trim(), this.id});
        }
        Assert.check((generator.conflicts == generator.shiftReduceConflicts + generator.reduceReduceConflicts + generator.acceptReduceConflicts ? 1 : 0) != 0);
        if (stateHasConflicts) {
            s.println();
        }
        Collections.sort(shiftTxts, Strings.SORTER);
        Collections.sort(reduceTxts, Strings.SORTER);
        Collections.sort(acceptTxts, Strings.SORTER);
        for (String shiftTxt : shiftTxts) {
            s.println(shiftTxt);
        }
        if (!shiftTxts.isEmpty() && !reduceTxts.isEmpty()) {
            s.println();
        }
        for (String reduceTxt : reduceTxts) {
            s.println(reduceTxt);
        }
        if (!(shiftTxts.isEmpty() && reduceTxts.isEmpty() || acceptTxts.isEmpty())) {
            s.println();
        }
        for (String acceptTxt : acceptTxts) {
            s.println(acceptTxt);
        }
        if (!this.actions.isEmpty() && !this.gotos.isEmpty()) {
            s.println();
        }
        List nonterminals = Sets.sortedgeneric(this.gotos.keySet(), (Comparator)NonTerminal.NAME_COMPARER);
        int maxNonTermLen = 1;
        for (NonTerminal nonTerminal : nonterminals) {
            maxNonTermLen = Math.max(maxNonTermLen, nonTerminal.name.length());
        }
        for (Map.Entry entry : this.gotos.entrySet()) {
            NonTerminal nonterminal = (NonTerminal)entry.getKey();
            LALR1AutomatonState target = (LALR1AutomatonState)entry.getValue();
            String name = nonterminal.name;
            name = StringUtils.rightPad((String)name, (int)maxNonTermLen);
            s.println("  " + name + " -> goto state " + target.id);
        }
    }
}

