/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import org.immutables.value.Value;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.ImmutableEndpointSpec;
import org.mandas.docker.client.messages.swarm.PortConfig;

@JsonDeserialize(builder=ImmutableEndpointSpec.Builder.class)
@Value.Immutable
public interface EndpointSpec {
    @JsonProperty(value="Mode")
    @Nullable
    public Mode mode();

    @JsonProperty(value="Ports")
    public List<PortConfig> ports();

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public Builder toBuilder() {
        return ImmutableEndpointSpec.builder().from(this);
    }

    default public EndpointSpec withVipMode() {
        return this.toBuilder().mode(Mode.RESOLUTION_MODE_VIP).build();
    }

    default public EndpointSpec withDnsrrMode() {
        return this.toBuilder().mode(Mode.RESOLUTION_MODE_DNSRR).build();
    }

    public static Builder builder() {
        return ImmutableEndpointSpec.builder();
    }

    public static interface Builder {
        public Builder mode(Mode var1);

        default public Builder addPort(PortConfig portConfig) {
            this.ports(portConfig);
            return this;
        }

        public Builder ports(PortConfig ... var1);

        public Builder ports(Iterable<? extends PortConfig> var1);

        public EndpointSpec build();
    }

    public static enum Mode {
        RESOLUTION_MODE_VIP("vip"),
        RESOLUTION_MODE_DNSRR("dnsrr");

        private final String value;

        private Mode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

