/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng.grammar.rng;

import java.io.IOException;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.eclipse.lemminx.uriresolver.CacheResourcesManager;
import org.eclipse.lemminx.uriresolver.URIResolverExtension;

public class RelaxNGURIResolverExtension
implements URIResolverExtension {
    private static final String RELAXNG_NAMESPACE_URI = "http://relaxng.org/ns/structure/1.0";
    private static final String RELAXNG_SYSTEM = "https://relaxng.org/relaxng.rng";
    private static final CacheResourcesManager.ResourceToDeploy RELAXNG_RESOURCE = new CacheResourcesManager.ResourceToDeploy("https://relaxng.org/relaxng.rng", "schemas/relaxng/relaxng.rng");

    @Override
    public String getName() {
        return "embedded relaxng.rng";
    }

    @Override
    public String resolve(String baseLocation, String publicId, String systemId) {
        if (!RELAXNG_NAMESPACE_URI.equals(publicId)) {
            return null;
        }
        try {
            return CacheResourcesManager.getResourceCachePath(RELAXNG_RESOURCE).toFile().toURI().toString();
        }
        catch (Exception exception) {
            return RELAXNG_SYSTEM;
        }
    }

    @Override
    public XMLInputSource resolveEntity(XMLResourceIdentifier resourceIdentifier) throws XNIException, IOException {
        String baseLocation;
        String relaxngFilePath;
        String publicId = resourceIdentifier.getNamespace();
        if (RELAXNG_NAMESPACE_URI.equals(publicId) && (relaxngFilePath = this.resolve(baseLocation = resourceIdentifier.getBaseSystemId(), publicId, null)) != null) {
            return new XMLInputSource(publicId, relaxngFilePath, relaxngFilePath);
        }
        return null;
    }
}

