/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.extensions;

import java.util.Collections;
import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.MockXMLLanguageServer;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.services.extensions.IDocumentLifecycleParticipant;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DocumentLifecycleParticipantTest
extends AbstractCacheBasedTest {
    private CaptureDocumentLifecycleCalls documentLifecycleParticipant;
    private MockXMLLanguageServer server;

    @BeforeEach
    public void initializeLanguageService() {
        this.server = new MockXMLLanguageServer();
        this.documentLifecycleParticipant = new CaptureDocumentLifecycleCalls();
        this.server.getXMLLanguageService().registerDocumentLifecycleParticipant((IDocumentLifecycleParticipant)this.documentLifecycleParticipant);
    }

    @Test
    public void didOpen() {
        Assertions.assertEquals((int)0, (int)this.documentLifecycleParticipant.getDidOpen());
        this.server.didOpen("test.xml", "<foo ");
        DocumentLifecycleParticipantTest.waitFor();
        Assertions.assertEquals((int)1, (int)this.documentLifecycleParticipant.getDidOpen());
    }

    @Test
    public void didChange() {
        Assertions.assertEquals((int)0, (int)this.documentLifecycleParticipant.getDidChange());
        this.server.didOpen("test.xml", "<foo ");
        this.server.didChange("test.xml", Collections.emptyList());
        DocumentLifecycleParticipantTest.waitFor();
        Assertions.assertEquals((int)1, (int)this.documentLifecycleParticipant.getDidChange());
    }

    @Test
    public void didSave() {
        Assertions.assertEquals((int)0, (int)this.documentLifecycleParticipant.getDidSave());
        this.server.didOpen("test.xml", "<foo ");
        this.server.didSave("test.xml");
        DocumentLifecycleParticipantTest.waitFor();
        Assertions.assertEquals((int)1, (int)this.documentLifecycleParticipant.getDidSave());
    }

    @Test
    public void didClose() {
        Assertions.assertEquals((int)0, (int)this.documentLifecycleParticipant.getDidClose());
        this.server.didOpen("test.xml", "<foo ");
        this.server.didClose("test.xml");
        Assertions.assertEquals((int)1, (int)this.documentLifecycleParticipant.getDidClose());
    }

    private static void waitFor() {
        try {
            Thread.sleep(600L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class CaptureDocumentLifecycleCalls
    implements IDocumentLifecycleParticipant {
        private int didOpen;
        private int didChange;
        private int didSave;
        private int didClose;

        private CaptureDocumentLifecycleCalls() {
        }

        public void didOpen(DOMDocument document) {
            if (document != null) {
                ++this.didOpen;
            }
        }

        public void didChange(DOMDocument document) {
            if (document != null) {
                ++this.didChange;
            }
        }

        public void didSave(DOMDocument document) {
            if (document != null) {
                ++this.didSave;
            }
        }

        public void didClose(DOMDocument document) {
            if (document != null) {
                ++this.didClose;
            }
        }

        public int getDidOpen() {
            return this.didOpen;
        }

        public int getDidChange() {
            return this.didChange;
        }

        public int getDidSave() {
            return this.didSave;
        }

        public int getDidClose() {
            return this.didClose;
        }
    }
}

