/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng.grammar.rng;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lsp4j.DocumentHighlightKind;
import org.junit.jupiter.api.Test;

public class RNGHighlightingExtensionsTest
extends AbstractCacheBasedTest {
    @Test
    public void highlightingOnDefineName() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\">\r\n    <start>\r\n        <element name=\"addressBook\">\r\n            <zeroOrMore>\r\n                <element name=\"card\">\r\n                    <ref name=\"cardContent\"/>\r\n                </element>\r\n            </zeroOrMore>\r\n        </element>\r\n    </start>\r\n    <define name=\"cardCo|ntent\">\r\n        <element name=\"name\">\r\n            <text/>\r\n        </element>\r\n        <element name=\"email\">\r\n            <text/>\r\n        </element>\r\n    </define>\r\n</grammar>";
        XMLAssert.testHighlightsFor(xml, XMLAssert.hl(XMLAssert.r(11, 17, 11, 30), DocumentHighlightKind.Write), XMLAssert.hl(XMLAssert.r(6, 30, 6, 43), DocumentHighlightKind.Read));
    }

    @Test
    public void highlightingOnRefName() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\">\r\n    <start>\r\n        <element name=\"addressBook\">\r\n            <zeroOrMore>\r\n                <element name=\"card\">\r\n                    <ref name=\"cardCon|tent\"/>\r\n                </element>\r\n            </zeroOrMore>\r\n        </element>\r\n    </start>\r\n    <define name=\"cardContent\">\r\n        <element name=\"name\">\r\n            <text/>\r\n        </element>\r\n        <element name=\"email\">\r\n            <text/>\r\n        </element>\r\n    </define>\r\n</grammar>";
        XMLAssert.testHighlightsFor(xml, XMLAssert.hl(XMLAssert.r(6, 30, 6, 43), DocumentHighlightKind.Read), XMLAssert.hl(XMLAssert.r(11, 17, 11, 30), DocumentHighlightKind.Write));
    }
}

