/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.generators.xml2relaxng;

import java.io.IOException;
import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.extensions.generators.FileContentGeneratorSettings;
import org.eclipse.lemminx.extensions.generators.xml2relaxng.RelaxNGGeneratorSettings;
import org.junit.jupiter.api.Test;

public class XML2RelaxNGGeneratorTest
extends AbstractCacheBasedTest {
    @Test
    public void schemaWithLegacyFormatter() throws IOException {
        String xml = "<note>\r\n\t<to>Tove</to>\r\n\t<from>Jani</from>\r\n\t<heading>Reminder</heading>\r\n\t<body>Don't forget me this weekend!</body>\r\n</note>";
        String rng = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"" + System.lineSeparator() + "  datatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">" + System.lineSeparator() + "  <start>" + System.lineSeparator() + "    <ref name=\"noteContent\" />" + System.lineSeparator() + "  </start>" + System.lineSeparator() + "  <define name=\"noteContent\">" + System.lineSeparator() + "    <element name=\"note\">" + System.lineSeparator() + "      <ref name=\"toContent\" />" + System.lineSeparator() + "      <ref name=\"fromContent\" />" + System.lineSeparator() + "      <ref name=\"headingContent\" />" + System.lineSeparator() + "      <ref name=\"bodyContent\" />" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "  <define name=\"toContent\">" + System.lineSeparator() + "    <element name=\"to\">" + System.lineSeparator() + "      <text />" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "  <define name=\"fromContent\">" + System.lineSeparator() + "    <element name=\"from\">" + System.lineSeparator() + "      <text />" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "  <define name=\"headingContent\">" + System.lineSeparator() + "    <element name=\"heading\">" + System.lineSeparator() + "      <text />" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "  <define name=\"bodyContent\">" + System.lineSeparator() + "    <element name=\"body\">" + System.lineSeparator() + "      <text />" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "</grammar>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new RelaxNGGeneratorSettings(), rng);
    }

    @Test
    public void schemaWithNS() throws IOException {
        String xml = "<note xmlns=\"https://www.w3schools.com\">\r\n\t<to>Tove</to>\r\n\t<from>Jani</from>\r\n\t<heading>Reminder</heading>\r\n\t<body>Don't forget me this weekend!</body>\r\n</note>";
        String rng = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\" ns=\"https://www.w3schools.com\"" + System.lineSeparator() + "  datatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">" + System.lineSeparator() + "  <start>" + System.lineSeparator() + "    <ref name=\"noteContent\" />" + System.lineSeparator() + "  </start>" + System.lineSeparator() + "  <define name=\"noteContent\">" + System.lineSeparator() + "    <element name=\"note\">" + System.lineSeparator() + "      <ref name=\"toContent\" />" + System.lineSeparator() + "      <ref name=\"fromContent\" />" + System.lineSeparator() + "      <ref name=\"headingContent\" />" + System.lineSeparator() + "      <ref name=\"bodyContent\" />" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "  <define name=\"toContent\">" + System.lineSeparator() + "    <element name=\"to\">" + System.lineSeparator() + "      <text />" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "  <define name=\"fromContent\">" + System.lineSeparator() + "    <element name=\"from\">" + System.lineSeparator() + "      <text />" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "  <define name=\"headingContent\">" + System.lineSeparator() + "    <element name=\"heading\">" + System.lineSeparator() + "      <text />" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "  <define name=\"bodyContent\">" + System.lineSeparator() + "    <element name=\"body\">" + System.lineSeparator() + "      <text />" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "</grammar>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new RelaxNGGeneratorSettings(), rng);
    }

    @Test
    public void schemaWithDecimalAttr() throws IOException {
        String xml = "<note version=\"1.2\" />";
        String rng = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"" + System.lineSeparator() + "  datatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">" + System.lineSeparator() + "  <start>" + System.lineSeparator() + "    <ref name=\"noteContent\" />" + System.lineSeparator() + "  </start>" + System.lineSeparator() + "  <define name=\"noteContent\">" + System.lineSeparator() + "    <element name=\"note\">" + System.lineSeparator() + "      <attribute name=\"version\">" + System.lineSeparator() + "        <data type=\"decimal\" />" + System.lineSeparator() + "      </attribute>" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "</grammar>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new RelaxNGGeneratorSettings(), rng);
    }

    @Test
    public void schemaWithDecimalAttrAndContent() throws IOException {
        String xml = "<note version=\"1.2\" >ABCD</note>";
        String rng = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"" + System.lineSeparator() + "  datatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">" + System.lineSeparator() + "  <start>" + System.lineSeparator() + "    <ref name=\"noteContent\" />" + System.lineSeparator() + "  </start>" + System.lineSeparator() + "  <define name=\"noteContent\">" + System.lineSeparator() + "    <element name=\"note\">" + System.lineSeparator() + "      <text />" + System.lineSeparator() + "      <attribute name=\"version\">" + System.lineSeparator() + "        <data type=\"decimal\" />" + System.lineSeparator() + "      </attribute>" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "</grammar>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new RelaxNGGeneratorSettings(), rng);
    }

    @Test
    public void schemaWithDecimalAttrAndMixedContent() throws IOException {
        String xml = "<note version=\"1.2\" >AB<C/>D</note>";
        String rng = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"" + System.lineSeparator() + "  datatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">" + System.lineSeparator() + "  <start>" + System.lineSeparator() + "    <ref name=\"noteContent\" />" + System.lineSeparator() + "  </start>" + System.lineSeparator() + "  <define name=\"noteContent\">" + System.lineSeparator() + "    <element name=\"note\">" + System.lineSeparator() + "      <mixed>" + System.lineSeparator() + "        <ref name=\"CContent\" />" + System.lineSeparator() + "      </mixed>" + System.lineSeparator() + "      <attribute name=\"version\">" + System.lineSeparator() + "        <data type=\"decimal\" />" + System.lineSeparator() + "      </attribute>" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "  <define name=\"CContent\">" + System.lineSeparator() + "    <element name=\"C\">" + System.lineSeparator() + "      <empty />" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "</grammar>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new RelaxNGGeneratorSettings(), rng);
    }

    @Test
    public void schemaWithAttrs() throws IOException {
        String xml = "<note version=\"1.2\" >\r\n\t<to attr1=\"abcd\" attr2=\"efgh\">Tove</to>\r\n\t<from>Jani</from>\r\n\t<heading>Reminder</heading>\r\n\t<body>Don't forget me this weekend!</body>\r\n</note>";
        String rng = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"" + System.lineSeparator() + "  datatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">" + System.lineSeparator() + "  <start>" + System.lineSeparator() + "    <ref name=\"noteContent\" />" + System.lineSeparator() + "  </start>" + System.lineSeparator() + "  <define name=\"noteContent\">" + System.lineSeparator() + "    <element name=\"note\">" + System.lineSeparator() + "      <ref name=\"toContent\" />" + System.lineSeparator() + "      <ref name=\"fromContent\" />" + System.lineSeparator() + "      <ref name=\"headingContent\" />" + System.lineSeparator() + "      <ref name=\"bodyContent\" />" + System.lineSeparator() + "      <attribute name=\"version\">" + System.lineSeparator() + "        <data type=\"decimal\" />" + System.lineSeparator() + "      </attribute>" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "  <define name=\"toContent\">" + System.lineSeparator() + "    <element name=\"to\">" + System.lineSeparator() + "      <text />" + System.lineSeparator() + "      <attribute name=\"attr1\" />" + System.lineSeparator() + "      <attribute name=\"attr2\" />" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "  <define name=\"fromContent\">" + System.lineSeparator() + "    <element name=\"from\">" + System.lineSeparator() + "      <text />" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "  <define name=\"headingContent\">" + System.lineSeparator() + "    <element name=\"heading\">" + System.lineSeparator() + "      <text />" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "  <define name=\"bodyContent\">" + System.lineSeparator() + "    <element name=\"body\">" + System.lineSeparator() + "      <text />" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "</grammar>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new RelaxNGGeneratorSettings(), rng);
    }

    @Test
    public void mixedContent() {
        String xml = "<a><b/>text</a>";
        String rng = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"" + System.lineSeparator() + "  datatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">" + System.lineSeparator() + "  <start>" + System.lineSeparator() + "    <ref name=\"aContent\" />" + System.lineSeparator() + "  </start>" + System.lineSeparator() + "  <define name=\"aContent\">" + System.lineSeparator() + "    <element name=\"a\">" + System.lineSeparator() + "      <mixed>" + System.lineSeparator() + "        <ref name=\"bContent\" />" + System.lineSeparator() + "      </mixed>" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "  <define name=\"bContent\">" + System.lineSeparator() + "    <element name=\"b\">" + System.lineSeparator() + "      <empty />" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "</grammar>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new RelaxNGGeneratorSettings(), rng);
    }

    @Test
    public void threeLevel() {
        String xml = "<a>\r\n\t<b>\r\n\t\t<c/>\r\n\t</b>\r\n</a>";
        String rng = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"" + System.lineSeparator() + "  datatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">" + System.lineSeparator() + "  <start>" + System.lineSeparator() + "    <ref name=\"aContent\" />" + System.lineSeparator() + "  </start>" + System.lineSeparator() + "  <define name=\"aContent\">" + System.lineSeparator() + "    <element name=\"a\">" + System.lineSeparator() + "      <ref name=\"bContent\" />" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "  <define name=\"bContent\">" + System.lineSeparator() + "    <element name=\"b\">" + System.lineSeparator() + "      <ref name=\"cContent\" />" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "  <define name=\"cContent\">" + System.lineSeparator() + "    <element name=\"c\">" + System.lineSeparator() + "      <empty />" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "</grammar>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new RelaxNGGeneratorSettings(), rng);
    }

    @Test
    public void threeLevelAndText() {
        String xml = "<a>\r\n\t<b>\r\n\t\t<c />\r\n\t\t<d>X</d>\r\n\t</b>\r\n</a>";
        String rng = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"" + System.lineSeparator() + "  datatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">" + System.lineSeparator() + "  <start>" + System.lineSeparator() + "    <ref name=\"aContent\" />" + System.lineSeparator() + "  </start>" + System.lineSeparator() + "  <define name=\"aContent\">" + System.lineSeparator() + "    <element name=\"a\">" + System.lineSeparator() + "      <ref name=\"bContent\" />" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "  <define name=\"bContent\">" + System.lineSeparator() + "    <element name=\"b\">" + System.lineSeparator() + "      <ref name=\"cContent\" />" + System.lineSeparator() + "      <ref name=\"dContent\" />" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "  <define name=\"cContent\">" + System.lineSeparator() + "    <element name=\"c\">" + System.lineSeparator() + "      <empty />" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "  <define name=\"dContent\">" + System.lineSeparator() + "    <element name=\"d\">" + System.lineSeparator() + "      <text />" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "</grammar>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new RelaxNGGeneratorSettings(), rng);
    }

    @Test
    public void occurrences() {
        String xml = "<invoice xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n  xsi:noNamespaceSchemaLocation=\"grocery-invoice.xsd\">\r\n  <item name=\"Rice\" price=\"4.99\" />\r\n  <item name=\"Baked Beans\" price=\"1.99\" />\r\n  <item name=\"Salad\" price=\"5.99\" />\r\n</invoice>";
        String rng = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"" + System.lineSeparator() + "  datatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">" + System.lineSeparator() + "  <start>" + System.lineSeparator() + "    <ref name=\"invoiceContent\" />" + System.lineSeparator() + "  </start>" + System.lineSeparator() + "  <define name=\"invoiceContent\">" + System.lineSeparator() + "    <element name=\"invoice\">" + System.lineSeparator() + "      <oneOrMore>" + System.lineSeparator() + "        <ref name=\"itemContent\" />" + System.lineSeparator() + "      </oneOrMore>" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "  <define name=\"itemContent\">" + System.lineSeparator() + "    <element name=\"item\">" + System.lineSeparator() + "      <attribute name=\"name\" />" + System.lineSeparator() + "      <attribute name=\"price\">" + System.lineSeparator() + "        <data type=\"decimal\" />" + System.lineSeparator() + "      </attribute>" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "</grammar>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new RelaxNGGeneratorSettings(), rng);
    }

    @Test
    public void oneZeroOccurrences() {
        String xml = "<root>\r\n    <a>\r\n        <b />\r\n    </a>\r\n    <a></a>\r\n</root>";
        String rng = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"" + System.lineSeparator() + "  datatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">" + System.lineSeparator() + "  <start>" + System.lineSeparator() + "    <ref name=\"rootContent\" />" + System.lineSeparator() + "  </start>" + System.lineSeparator() + "  <define name=\"rootContent\">" + System.lineSeparator() + "    <element name=\"root\">" + System.lineSeparator() + "      <oneOrMore>" + System.lineSeparator() + "        <ref name=\"aContent\" />" + System.lineSeparator() + "      </oneOrMore>" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "  <define name=\"aContent\">" + System.lineSeparator() + "    <element name=\"a\">" + System.lineSeparator() + "      <optional>" + System.lineSeparator() + "        <ref name=\"bContent\" />" + System.lineSeparator() + "      </optional>" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "  <define name=\"bContent\">" + System.lineSeparator() + "    <element name=\"b\">" + System.lineSeparator() + "      <empty />" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "</grammar>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new RelaxNGGeneratorSettings(), rng);
    }

    @Test
    public void oneZeroOccurrences2() {
        String xml = "<root>\r\n    <a>\r\n        <b />\r\n    </a>\r\n    <a>\r\n        <c />\r\n    </a>\r\n    <a>\r\n        <b />\r\n        <c />\r\n    </a>\r\n    <a></a>\r\n</root>";
        String rng = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"" + System.lineSeparator() + "  datatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">" + System.lineSeparator() + "  <start>" + System.lineSeparator() + "    <ref name=\"rootContent\" />" + System.lineSeparator() + "  </start>" + System.lineSeparator() + "  <define name=\"rootContent\">" + System.lineSeparator() + "    <element name=\"root\">" + System.lineSeparator() + "      <oneOrMore>" + System.lineSeparator() + "        <ref name=\"aContent\" />" + System.lineSeparator() + "      </oneOrMore>" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "  <define name=\"aContent\">" + System.lineSeparator() + "    <element name=\"a\">" + System.lineSeparator() + "      <optional>" + System.lineSeparator() + "        <ref name=\"bContent\" />" + System.lineSeparator() + "      </optional>" + System.lineSeparator() + "      <optional>" + System.lineSeparator() + "        <ref name=\"cContent\" />" + System.lineSeparator() + "      </optional>" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "  <define name=\"bContent\">" + System.lineSeparator() + "    <element name=\"b\">" + System.lineSeparator() + "      <empty />" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "  <define name=\"cContent\">" + System.lineSeparator() + "    <element name=\"c\">" + System.lineSeparator() + "      <empty />" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "</grammar>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new RelaxNGGeneratorSettings(), rng);
    }

    @Test
    public void interleave() {
        String xml = "<root>\r\n\t<a>\r\n\t\t<c />\r\n\t\t<b />\r\n\t</a>\r\n\t<a>\r\n\t\t<b />\r\n\t\t<c />\r\n\t</a>\r\n</root>";
        String rng = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"" + System.lineSeparator() + "  datatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">" + System.lineSeparator() + "  <start>" + System.lineSeparator() + "    <ref name=\"rootContent\" />" + System.lineSeparator() + "  </start>" + System.lineSeparator() + "  <define name=\"rootContent\">" + System.lineSeparator() + "    <element name=\"root\">" + System.lineSeparator() + "      <oneOrMore>" + System.lineSeparator() + "        <ref name=\"aContent\" />" + System.lineSeparator() + "      </oneOrMore>" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "  <define name=\"aContent\">" + System.lineSeparator() + "    <element name=\"a\">" + System.lineSeparator() + "      <interleave>" + System.lineSeparator() + "        <ref name=\"cContent\" />" + System.lineSeparator() + "        <ref name=\"bContent\" />" + System.lineSeparator() + "      </interleave>" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "  <define name=\"cContent\">" + System.lineSeparator() + "    <element name=\"c\">" + System.lineSeparator() + "      <empty />" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "  <define name=\"bContent\">" + System.lineSeparator() + "    <element name=\"b\">" + System.lineSeparator() + "      <empty />" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "</grammar>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new RelaxNGGeneratorSettings(), rng);
    }

    @Test
    public void optionalAttribute() {
        String xml = "<root>\r\n\t<item attr1=\"\" attr2=\"\"/>\r\n\t<item attr1=\"\" />\r\n</root>";
        String rng = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"" + System.lineSeparator() + "  datatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">" + System.lineSeparator() + "  <start>" + System.lineSeparator() + "    <ref name=\"rootContent\" />" + System.lineSeparator() + "  </start>" + System.lineSeparator() + "  <define name=\"rootContent\">" + System.lineSeparator() + "    <element name=\"root\">" + System.lineSeparator() + "      <oneOrMore>" + System.lineSeparator() + "        <ref name=\"itemContent\" />" + System.lineSeparator() + "      </oneOrMore>" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "  <define name=\"itemContent\">" + System.lineSeparator() + "    <element name=\"item\">" + System.lineSeparator() + "      <attribute name=\"attr1\" />" + System.lineSeparator() + "      <optional>" + System.lineSeparator() + "        <attribute name=\"attr2\" />" + System.lineSeparator() + "      </optional>" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "</grammar>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new RelaxNGGeneratorSettings(), rng);
    }

    @Test
    public void attrIDsAndFixed() {
        String xml = "<root>\r\n\t<item attr1=\"id1\" attr2=\"A\" />\r\n\t<item attr1=\"id2\" attr2=\"A\" />\r\n\t<item attr1=\"id3\" attr2=\"A\" />\r\n\t<item attr1=\"id4\" attr2=\"A\" />\r\n\t<item attr1=\"id5\" attr2=\"A\" />\r\n\t<item attr1=\"id6\" attr2=\"A\" />\r\n\t<item attr1=\"id7\" attr2=\"A\" />\r\n\t<item attr1=\"id8\" attr2=\"A\" />\r\n\t<item attr1=\"id9\" attr2=\"A\" />\r\n\t<item attr1=\"id10\" attr2=\"A\" />\r\n</root>";
        String rng = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"" + System.lineSeparator() + "  datatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">" + System.lineSeparator() + "  <start>" + System.lineSeparator() + "    <ref name=\"rootContent\" />" + System.lineSeparator() + "  </start>" + System.lineSeparator() + "  <define name=\"rootContent\">" + System.lineSeparator() + "    <element name=\"root\">" + System.lineSeparator() + "      <oneOrMore>" + System.lineSeparator() + "        <ref name=\"itemContent\" />" + System.lineSeparator() + "      </oneOrMore>" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "  <define name=\"itemContent\">" + System.lineSeparator() + "    <element name=\"item\">" + System.lineSeparator() + "      <attribute name=\"attr1\" />" + System.lineSeparator() + "      <attribute name=\"attr2\">" + System.lineSeparator() + "        <value>A</value>" + System.lineSeparator() + "      </attribute>" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "</grammar>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new RelaxNGGeneratorSettings(), rng);
    }

    @Test
    public void attrIDsAndEnums() {
        String xml = "<root>\r\n\t<item attr1=\"id1\" attr2=\"A\" />\r\n\t<item attr1=\"id2\" attr2=\"A\" />\r\n\t<item attr1=\"id3\" attr2=\"A\" />\r\n\t<item attr1=\"id4\" attr2=\"A\" />\r\n\t<item attr1=\"id5\" attr2=\"A\" />\r\n\t<item attr1=\"id6\" attr2=\"B\" />\r\n\t<item attr1=\"id7\" attr2=\"B\" />\r\n\t<item attr1=\"id8\" attr2=\"B\" />\r\n\t<item attr1=\"id9\" attr2=\"B\" />\r\n\t<item attr1=\"id10\" attr2=\"B\" />\r\n</root>";
        String rng = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"" + System.lineSeparator() + "  datatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">" + System.lineSeparator() + "  <start>" + System.lineSeparator() + "    <ref name=\"rootContent\" />" + System.lineSeparator() + "  </start>" + System.lineSeparator() + "  <define name=\"rootContent\">" + System.lineSeparator() + "    <element name=\"root\">" + System.lineSeparator() + "      <oneOrMore>" + System.lineSeparator() + "        <ref name=\"itemContent\" />" + System.lineSeparator() + "      </oneOrMore>" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "  <define name=\"itemContent\">" + System.lineSeparator() + "    <element name=\"item\">" + System.lineSeparator() + "      <attribute name=\"attr1\" />" + System.lineSeparator() + "      <attribute name=\"attr2\">" + System.lineSeparator() + "        <choice>" + System.lineSeparator() + "          <value>A</value>" + System.lineSeparator() + "          <value>B</value>" + System.lineSeparator() + "        </choice>" + System.lineSeparator() + "      </attribute>" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "</grammar>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new RelaxNGGeneratorSettings(), rng);
    }

    @Test
    public void attrTypes() {
        String xml = "<root>\r\n\t<item dateTime=\"2001-10-26T21:32:52+02:00\"\r\n\t\t  date=\"2001-10-26\"\r\n         boolean=\"true\"\r\n         integer=\"1\"\r\n         decimal=\"1.2\"  />\r\n</root>";
        String rng = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"" + System.lineSeparator() + "  datatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">" + System.lineSeparator() + "  <start>" + System.lineSeparator() + "    <ref name=\"rootContent\" />" + System.lineSeparator() + "  </start>" + System.lineSeparator() + "  <define name=\"rootContent\">" + System.lineSeparator() + "    <element name=\"root\">" + System.lineSeparator() + "      <ref name=\"itemContent\" />" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "  <define name=\"itemContent\">" + System.lineSeparator() + "    <element name=\"item\">" + System.lineSeparator() + "      <attribute name=\"dateTime\">" + System.lineSeparator() + "        <data type=\"dateTime\" />" + System.lineSeparator() + "      </attribute>" + System.lineSeparator() + "      <attribute name=\"date\">" + System.lineSeparator() + "        <data type=\"date\" />" + System.lineSeparator() + "      </attribute>" + System.lineSeparator() + "      <attribute name=\"boolean\">" + System.lineSeparator() + "        <data type=\"boolean\" />" + System.lineSeparator() + "      </attribute>" + System.lineSeparator() + "      <attribute name=\"integer\">" + System.lineSeparator() + "        <data type=\"integer\" />" + System.lineSeparator() + "      </attribute>" + System.lineSeparator() + "      <attribute name=\"decimal\">" + System.lineSeparator() + "        <data type=\"decimal\" />" + System.lineSeparator() + "      </attribute>" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "</grammar>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new RelaxNGGeneratorSettings(), rng);
    }

    @Test
    public void attrTypesWith2Occurs() {
        String xml = "<root>\r\n\t<item dateTime=\"2001-10-26T21:32:52+02:00\"\r\n\t\t  date=\"2001-10-26\"\r\n         boolean=\"true\"\r\n         integer=\"1\"\r\n         decimal=\"1.2\"  />\r\n\t<item dateTime=\"2001-10-26T21:32:52+02:00\"\r\n\t\t  date=\"2001-10-26\"\r\n         boolean=\"true\"\r\n         integer=\"1\"\r\n         decimal=\"XXXXXXXXXXXXXXXXXXXXXX\"  />\r\n</root>";
        String rng = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"" + System.lineSeparator() + "  datatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">" + System.lineSeparator() + "  <start>" + System.lineSeparator() + "    <ref name=\"rootContent\" />" + System.lineSeparator() + "  </start>" + System.lineSeparator() + "  <define name=\"rootContent\">" + System.lineSeparator() + "    <element name=\"root\">" + System.lineSeparator() + "      <oneOrMore>" + System.lineSeparator() + "        <ref name=\"itemContent\" />" + System.lineSeparator() + "      </oneOrMore>" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "  <define name=\"itemContent\">" + System.lineSeparator() + "    <element name=\"item\">" + System.lineSeparator() + "      <attribute name=\"dateTime\">" + System.lineSeparator() + "        <data type=\"dateTime\" />" + System.lineSeparator() + "      </attribute>" + System.lineSeparator() + "      <attribute name=\"date\">" + System.lineSeparator() + "        <data type=\"date\" />" + System.lineSeparator() + "      </attribute>" + System.lineSeparator() + "      <attribute name=\"boolean\">" + System.lineSeparator() + "        <data type=\"boolean\" />" + System.lineSeparator() + "      </attribute>" + System.lineSeparator() + "      <attribute name=\"integer\">" + System.lineSeparator() + "        <data type=\"integer\" />" + System.lineSeparator() + "      </attribute>" + System.lineSeparator() + "      <attribute name=\"decimal\" />" + System.lineSeparator() + "    </element>" + System.lineSeparator() + "  </define>" + System.lineSeparator() + "</grammar>";
        XMLAssert.assertGrammarGenerator(xml, (FileContentGeneratorSettings)new RelaxNGGeneratorSettings(), rng);
    }
}

