/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.entities;

import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.util.URI;
import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lsp4j.LocationLink;
import org.junit.jupiter.api.Test;

public class EntitiesDefinitionExtensionsTest
extends AbstractCacheBasedTest {
    @Test
    public void local() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE root [\r\n  <!ENTITY mdash \"&#x2014;\">\r\n]>\r\n<root>\r\n  &mdas|h;\r\n</root>";
        XMLAssert.testDefinitionFor(xml, "test.xml", XMLAssert.ll("test.xml", XMLAssert.r(5, 2, 5, 9), XMLAssert.r(2, 11, 2, 16)));
    }

    @Test
    public void localWithSYSTEM() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" standalone=\"no\" ?>\r\n\t<!DOCTYPE copyright [\r\n\t  <!ELEMENT copyright (#PCDATA)>\r\n\t  <!ENTITY c SYSTEM \"http://www.xmlwriter.net/copyright.xml\">\r\n\t]>\r\n\t<copyright>&|c;</copyright>";
        XMLAssert.testDefinitionFor(xml, "test.xml", XMLAssert.ll("test.xml", XMLAssert.r(5, 12, 5, 15), XMLAssert.r(3, 12, 3, 13)));
    }

    @Test
    public void beforeAmp() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE root [\r\n  <!ENTITY mdash \"&#x2014;\">\r\n]>\r\n<root>\r\n  |&mdash\r\n</root>";
        XMLAssert.testDefinitionFor(xml, "test.xml", new LocationLink[0]);
    }

    @Test
    public void unknownEntity() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE root [\r\n  <!ENTITY mdash \"&#x2014;\">\r\n]>\r\n<root>\r\n  &BAD_ENT|ITY\r\n</root>";
        XMLAssert.testDefinitionFor(xml, "test.xml", new LocationLink[0]);
    }

    @Test
    public void insideText() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE root [\r\n  <!ENTITY mdash \"&#x2014;\">\r\n]>\r\n<root>\r\n  abcd&mdas|h;efgh\r\n</root>";
        XMLAssert.testDefinitionFor(xml, "test.xml", XMLAssert.ll("test.xml", XMLAssert.r(5, 6, 5, 13), XMLAssert.r(2, 11, 2, 16)));
    }

    @Test
    public void underscoreEntityName() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE root [\r\n  <!ENTITY foo_bar \"&#x2014;\">\r\n  <!ENTITY foo_baz \"&#x2014;\">\r\n]>\r\n<root>\r\n &foo_b|ar;efgh\r\n</root>";
        XMLAssert.testDefinitionFor(xml, "test.xml", XMLAssert.ll("test.xml", XMLAssert.r(6, 1, 6, 10), XMLAssert.r(2, 11, 2, 18)));
    }

    @Test
    public void externalWithIndent() throws BadLocationException, URI.MalformedURIException {
        String dtdFileURI = EntitiesDefinitionExtensionsTest.getDTDFileURI("src/test/resources/dtd/entities/base.dtd");
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<!DOCTYPE root-element SYSTEM \"src/test/resources/dtd/entities/base.dtd\" [\r\n\t<!ENTITY mdash \"&#x2014;\">\r\n]>\r\n<root-element>\r\n\r\n &f|oo;</root-element>";
        XMLAssert.testDefinitionFor(xml, "test.xml", XMLAssert.ll(dtdFileURI, XMLAssert.r(6, 1, 6, 6), XMLAssert.r(2, 9, 2, 12)));
    }

    @Test
    public void externalWithDTDIndent() throws BadLocationException, URI.MalformedURIException {
        String dtdFileURI = EntitiesDefinitionExtensionsTest.getDTDFileURI("src/test/resources/dtd/entities/base-indent.dtd");
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<!DOCTYPE root-element SYSTEM \"src/test/resources/dtd/entities/base-indent.dtd\" [\r\n\t<!ENTITY mdash \"&#x2014;\">\r\n]>\r\n<root-element>\r\n\r\n &externa|l3;</root-element>";
        XMLAssert.testDefinitionFor(xml, "test.xml", XMLAssert.ll(dtdFileURI, XMLAssert.r(6, 1, 6, 12), XMLAssert.r(0, 9, 0, 18)));
        xml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<!DOCTYPE root-element SYSTEM \"src/test/resources/dtd/entities/base-indent.dtd\" [\r\n\t<!ENTITY mdash \"&#x2014;\">\r\n]>\r\n<root-element>\r\n\r\n &externa|l5;</root-element>";
        XMLAssert.testDefinitionFor(xml, "test.xml", XMLAssert.ll(dtdFileURI, XMLAssert.r(6, 1, 6, 12), XMLAssert.r(0, 34, 0, 43)));
        xml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<!DOCTYPE root-element SYSTEM \"src/test/resources/dtd/entities/base-indent.dtd\" [\r\n\t<!ENTITY mdash \"&#x2014;\">\r\n]>\r\n<root-element>\r\n\r\n &externa|l;</root-element>";
        XMLAssert.testDefinitionFor(xml, "test.xml", XMLAssert.ll(dtdFileURI, XMLAssert.r(6, 1, 6, 11), XMLAssert.r(3, 15, 3, 23)));
        xml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<!DOCTYPE root-element SYSTEM \"src/test/resources/dtd/entities/base-indent.dtd\" [\r\n\t<!ENTITY mdash \"&#x2014;\">\r\n]>\r\n<root-element>\r\n\r\n &externa|l2;</root-element>";
        XMLAssert.testDefinitionFor(xml, "test.xml", XMLAssert.ll(dtdFileURI, XMLAssert.r(6, 1, 6, 12), XMLAssert.r(4, 9, 4, 18)));
    }

    @Test
    public void externalWithDTDNoIndent() throws BadLocationException, URI.MalformedURIException {
        String dtdFileURI = EntitiesDefinitionExtensionsTest.getDTDFileURI("src/test/resources/dtd/entities/base-no-indent.dtd");
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<!DOCTYPE root-element SYSTEM \"src/test/resources/dtd/entities/base-no-indent.dtd\" [\r\n\t<!ENTITY mdash \"&#x2014;\">\r\n]>\r\n<root-element>\r\n\r\n &externa|l3;</root-element>";
        XMLAssert.testDefinitionFor(xml, "test.xml", XMLAssert.ll(dtdFileURI, XMLAssert.r(6, 1, 6, 12), XMLAssert.r(0, 23, 0, 32)));
        xml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<!DOCTYPE root-element SYSTEM \"src/test/resources/dtd/entities/base-no-indent.dtd\" [\r\n\t<!ENTITY mdash \"&#x2014;\">\r\n]>\r\n<root-element>\r\n\r\n &externa|l5;</root-element>";
        XMLAssert.testDefinitionFor(xml, "test.xml", XMLAssert.ll(dtdFileURI, XMLAssert.r(6, 1, 6, 12), XMLAssert.r(0, 48, 0, 57)));
        xml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<!DOCTYPE root-element SYSTEM \"src/test/resources/dtd/entities/base-no-indent.dtd\" [\r\n\t<!ENTITY mdash \"&#x2014;\">\r\n]>\r\n<root-element>\r\n\r\n &externa|l;</root-element>";
        XMLAssert.testDefinitionFor(xml, "test.xml", XMLAssert.ll(dtdFileURI, XMLAssert.r(6, 1, 6, 11), XMLAssert.r(3, 15, 3, 23)));
        xml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<!DOCTYPE root-element SYSTEM \"src/test/resources/dtd/entities/base-no-indent.dtd\" [\r\n\t<!ENTITY mdash \"&#x2014;\">\r\n]>\r\n<root-element>\r\n\r\n &externa|l2;</root-element>";
        XMLAssert.testDefinitionFor(xml, "test.xml", XMLAssert.ll(dtdFileURI, XMLAssert.r(6, 1, 6, 12), XMLAssert.r(4, 9, 4, 18)));
    }

    @Test
    public void externalWithSYSTEM() throws BadLocationException, URI.MalformedURIException {
        String dtdFileURI = EntitiesDefinitionExtensionsTest.getDTDFileURI("src/test/resources/dtd/entities/base-system.dtd");
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE author SYSTEM \"src/test/resources/dtd/entities/base-system.dtd\">\r\n<author>&wr|iter;&copyright;</author>";
        XMLAssert.testDefinitionFor(xml, "test.xml", XMLAssert.ll(dtdFileURI, XMLAssert.r(2, 8, 2, 16), XMLAssert.r(1, 9, 1, 15)));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE author SYSTEM \"src/test/resources/dtd/entities/base-system.dtd\">\r\n<author>&writer;&cop|yright;</author>";
        XMLAssert.testDefinitionFor(xml, "test.xml", XMLAssert.ll(dtdFileURI, XMLAssert.r(2, 16, 2, 27), XMLAssert.r(2, 9, 2, 18)));
    }

    @Test
    public void parameterEntity() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE root [\r\n  <!ENTITY % document SYSTEM \"document.ent\">\r\n  %docu|ment;]>\r\n<root>\r\n</root>";
        XMLAssert.testDefinitionFor(xml, "test.xml", XMLAssert.ll("test.xml", XMLAssert.r(3, 2, 3, 12), XMLAssert.r(2, 13, 2, 21)));
    }

    private static String getDTDFileURI(String dtdURI) throws URI.MalformedURIException {
        return XMLEntityManager.expandSystemId((String)dtdURI, (String)"test.xml", (boolean)true).replace("///", "/");
    }
}

