/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.services.extensions.IDocumentLinkParticipant;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lsp4j.DocumentLink;

class XMLDocumentLink {
    private final XMLExtensionsRegistry extensionsRegistry;
    private static Logger LOGGER = Logger.getLogger(XMLDocumentLink.class.getName());

    public XMLDocumentLink(XMLExtensionsRegistry extensionsRegistry) {
        this.extensionsRegistry = extensionsRegistry;
    }

    public List<DocumentLink> findDocumentLinks(DOMDocument document) {
        ArrayList<DocumentLink> newLinks = new ArrayList<DocumentLink>();
        for (IDocumentLinkParticipant participant : this.extensionsRegistry.getDocumentLinkParticipants()) {
            try {
                participant.findDocumentLinks(document, newLinks);
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error while processing document links for the participant '" + participant.getClass().getName() + "'.", e);
            }
        }
        return newLinks;
    }
}

