/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.references;

import org.eclipse.lemminx.extensions.references.participants.XMLReferencesCodeLensParticipant;
import org.eclipse.lemminx.extensions.references.participants.XMLReferencesCompletionParticipant;
import org.eclipse.lemminx.extensions.references.participants.XMLReferencesDefinitionParticipant;
import org.eclipse.lemminx.extensions.references.participants.XMLReferencesDiagnosticParticipant;
import org.eclipse.lemminx.extensions.references.participants.XMLReferencesHighlightingParticipant;
import org.eclipse.lemminx.extensions.references.participants.XMLReferencesLinkedEditingRangesParticipant;
import org.eclipse.lemminx.extensions.references.participants.XMLReferencesReferenceParticipant;
import org.eclipse.lemminx.extensions.references.participants.XMLReferencesRenameParticipant;
import org.eclipse.lemminx.extensions.references.settings.XMLReferencesSettings;
import org.eclipse.lemminx.services.extensions.IDefinitionParticipant;
import org.eclipse.lemminx.services.extensions.IHighlightingParticipant;
import org.eclipse.lemminx.services.extensions.ILinkedEditingRangesParticipant;
import org.eclipse.lemminx.services.extensions.IReferenceParticipant;
import org.eclipse.lemminx.services.extensions.IXMLExtension;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.services.extensions.codelens.ICodeLensParticipant;
import org.eclipse.lemminx.services.extensions.completion.ICompletionParticipant;
import org.eclipse.lemminx.services.extensions.diagnostics.IDiagnosticsParticipant;
import org.eclipse.lemminx.services.extensions.rename.IRenameParticipant;
import org.eclipse.lemminx.services.extensions.save.ISaveContext;
import org.eclipse.lsp4j.InitializeParams;

public class XMLReferencesPlugin
implements IXMLExtension {
    private final ICompletionParticipant completionParticipant = new XMLReferencesCompletionParticipant(this);
    private final IDefinitionParticipant definitionParticipant = new XMLReferencesDefinitionParticipant(this);
    private final IReferenceParticipant referenceParticipant = new XMLReferencesReferenceParticipant(this);
    private final ICodeLensParticipant codeLensParticipant = new XMLReferencesCodeLensParticipant(this);
    private final IHighlightingParticipant highlightingParticipant = new XMLReferencesHighlightingParticipant(this);
    private final IRenameParticipant renameParticipant = new XMLReferencesRenameParticipant(this);
    private final ILinkedEditingRangesParticipant linkedEditingRangesParticipant = new XMLReferencesLinkedEditingRangesParticipant(this);
    private final IDiagnosticsParticipant diagnosticsParticipant = new XMLReferencesDiagnosticParticipant(this);
    private XMLReferencesSettings referencesSettings;

    @Override
    public void doSave(ISaveContext context) {
        if (context.getType() != ISaveContext.SaveContextType.DOCUMENT) {
            this.updateSettings(context);
        }
    }

    private void updateSettings(ISaveContext saveContext) {
        Object initializationOptionsSettings = saveContext.getSettings();
        XMLReferencesSettings referencesSettings = XMLReferencesSettings.getXMLReferencesSettings(initializationOptionsSettings);
        this.updateSettings(referencesSettings, saveContext);
    }

    private void updateSettings(XMLReferencesSettings settings, ISaveContext context) {
        this.referencesSettings = settings;
    }

    @Override
    public void start(InitializeParams params, XMLExtensionsRegistry registry) {
        registry.registerCompletionParticipant(this.completionParticipant);
        registry.registerDefinitionParticipant(this.definitionParticipant);
        registry.registerReferenceParticipant(this.referenceParticipant);
        registry.registerCodeLensParticipant(this.codeLensParticipant);
        registry.registerHighlightingParticipant(this.highlightingParticipant);
        registry.registerRenameParticipant(this.renameParticipant);
        registry.registerLinkedEditingRangesParticipants(this.linkedEditingRangesParticipant);
        registry.registerDiagnosticsParticipant(this.diagnosticsParticipant);
    }

    @Override
    public void stop(XMLExtensionsRegistry registry) {
        registry.unregisterCompletionParticipant(this.completionParticipant);
        registry.unregisterDefinitionParticipant(this.definitionParticipant);
        registry.unregisterReferenceParticipant(this.referenceParticipant);
        registry.unregisterCodeLensParticipant(this.codeLensParticipant);
        registry.unregisterHighlightingParticipant(this.highlightingParticipant);
        registry.unregisterRenameParticipant(this.renameParticipant);
        registry.unregisterLinkedEditingRangesParticipants(this.linkedEditingRangesParticipant);
        registry.unregisterDiagnosticsParticipant(this.diagnosticsParticipant);
    }

    public XMLReferencesSettings getReferencesSettings() {
        return this.referencesSettings;
    }
}

