/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.dom.parser;

import java.util.function.Predicate;
import org.eclipse.lemminx.dom.DOMDocumentType;
import org.eclipse.lemminx.dom.parser.Constants;
import org.eclipse.lemminx.dom.parser.MultiLineStream;
import org.eclipse.lemminx.dom.parser.Scanner;
import org.eclipse.lemminx.dom.parser.ScannerState;
import org.eclipse.lemminx.dom.parser.TokenType;
import org.eclipse.lemminx.utils.StringUtils;

public class XMLScanner
implements Scanner {
    private static final Predicate<Integer> START_ELEMENT_NAME_PREDICATE = ch -> ch == Constants._UDS || ch == Constants._DDT || Character.isLetter(ch);
    private static final Predicate<Integer> ELEMENT_NAME_PREDICATE = ch -> ch == Constants._UDS || ch == Constants._DDT || ch == Constants._DOT || ch == Constants._MIN || Character.isLetterOrDigit(ch);
    private static final Predicate<Integer> ATTRIBUTE_NAME_PREDICATE = ch -> !(Character.isWhitespace(ch) || ch == Constants._QMA || ch == Constants._DQO || ch == Constants._SIQ || ch == Constants._LAN || ch == Constants._RAN || ch == Constants._FSL || ch == Constants._EQS || ch >= 0 && ch <= 15 || ch == 127 || ch >= 128 && ch <= 159);
    private static final int[] END_COMMENT_PATTERN = new int[]{Constants._MIN, Constants._MIN, Constants._RAN};
    private static final int[] END_PROLOG_PATTERN = new int[]{Constants._QMA, Constants._RAN};
    private static final int[] END_WS_OR_PROLOG_PATTERN = new int[]{Constants._NWL, Constants._CAR, Constants._WSP, Constants._QMA, Constants._RAN};
    private static final int[] START_COMMENT_PATTERN = new int[]{Constants._EXL, Constants._MIN, Constants._MIN};
    private static final int[] START_CDATA_PATTERN = new int[]{Constants._EXL, Constants._OSB, Constants._CVL, Constants._DVL, Constants._AVL, Constants._TVL, Constants._AVL, Constants._OSB};
    private static final int[] END_CDATA_PATTERN = new int[]{Constants._CSB, Constants._CSB, Constants._RAN};
    private static final int[] START_DOCTYPE_PATTERN = new int[]{Constants._EXL, Constants._DVL, Constants._OVL, Constants._CVL, Constants._TVL, Constants._YVL, Constants._PVL, Constants._EVL};
    private static final int[] START_DTD_ELEMENT_PATTERN = new int[]{Constants._EXL, Constants._EVL, Constants._LVL, Constants._EVL, Constants._MVL, Constants._EVL, Constants._NVL, Constants._TVL};
    private static final int[] START_DTD_ATTLIST_PATTERN = new int[]{Constants._EXL, Constants._AVL, Constants._TVL, Constants._TVL, Constants._LVL, Constants._IVL, Constants._SVL, Constants._TVL};
    private static final int[] START_DTD_ENTITY_PATTERN = new int[]{Constants._EXL, Constants._EVL, Constants._NVL, Constants._TVL, Constants._IVL, Constants._TVL, Constants._YVL};
    private static final int[] START_DTD_NOTATION_PATTERN = new int[]{Constants._EXL, Constants._NVL, Constants._OVL, Constants._TVL, Constants._AVL, Constants._TVL, Constants._IVL, Constants._OVL, Constants._NVL};
    private static final int[] END_DTD_DOCTYPE_PATTERN = new int[]{Constants._RAN, Constants._LAN, Constants._CSB};
    private static final int[] START_DTD_INTERNAL_SUBSET_PATTERN = new int[]{Constants._OSB, Constants._RAN, Constants._LAN};
    private static final int[] DTD_ELEMENT_SEPARATORS = new int[]{Constants._QMA, Constants._AST, Constants._PLS};
    MultiLineStream stream;
    ScannerState state;
    int tokenOffset;
    TokenType tokenType;
    String tokenError;
    String lastDoctypeKind;
    String url;
    boolean isInsideDTDContent = false;
    boolean isDeclCompleted = false;
    TokenType tempToken;
    boolean isDTDFile;
    boolean isInitialAttlistDeclCompleted = false;
    private int nbBraceOpened;

    public XMLScanner(String input, int initialOffset, ScannerState initialState, boolean isDTDFile) {
        this.stream = new MultiLineStream(input, initialOffset);
        this.state = initialState;
        this.tokenOffset = 0;
        this.isInsideDTDContent = ScannerState.DTDWithinContent.equals((Object)initialState);
        this.tokenType = TokenType.Unknown;
        this.isDTDFile = isDTDFile;
    }

    boolean hasNextElementName() {
        if (!START_ELEMENT_NAME_PREDICATE.test(this.stream.peekChar())) {
            return false;
        }
        this.stream.advance(1);
        this.stream.advanceWhileChar(ELEMENT_NAME_PREDICATE);
        return true;
    }

    boolean hasNextAttributeName() {
        return this.stream.advanceWhileChar(ATTRIBUTE_NAME_PREDICATE) > 0;
    }

    boolean hasNextAttributeValue() {
        int first = this.stream.peekChar();
        if (first == Constants._SIQ || first == Constants._DQO) {
            this.stream.advance(1);
            if (this.stream.advanceUntilChar(first)) {
                this.stream.advance(1);
            }
            return true;
        }
        return false;
    }

    String doctypeName() {
        return this.stream.advanceIfRegExp(Constants.ELEMENT_NAME_REGEX);
    }

    String doctypeKind() {
        return this.stream.advanceIfRegExpGroup1(Constants.DOCTYPE_KIND_OPTIONS);
    }

    TokenType finishToken(int offset, TokenType type) {
        return this.finishToken(offset, type, null);
    }

    TokenType finishToken(int offset, TokenType type, String errorMessage) {
        this.tokenType = type;
        this.tokenOffset = offset;
        this.tokenError = errorMessage;
        return type;
    }

    @Override
    public TokenType scan() {
        int offset = this.stream.pos();
        ScannerState oldState = this.state;
        TokenType token = this.internalScan();
        if (token != TokenType.EOS && offset == this.stream.pos()) {
            this.log("Scanner.scan has not advanced at offset " + offset + ", state before: " + (Object)((Object)oldState) + " after: " + (Object)((Object)this.state));
            this.stream.advance(1);
            return this.finishToken(offset, TokenType.Unknown);
        }
        return token;
    }

    private void log(String message) {
        System.err.println(message);
    }

    TokenType internalScan() {
        int offset = this.stream.pos();
        if (this.stream.eos()) {
            return this.finishToken(offset, TokenType.EOS);
        }
        String errorMessage = null;
        switch (this.state) {
            case WithinComment: {
                if (this.stream.advanceIfChars(END_COMMENT_PATTERN)) {
                    this.state = !this.isInsideDTDContent ? ScannerState.WithinContent : ScannerState.DTDWithinContent;
                    return this.finishToken(offset, TokenType.EndCommentTag);
                }
                this.stream.advanceUntilChars(END_COMMENT_PATTERN);
                return this.finishToken(offset, TokenType.Comment);
            }
            case PrologOrPI: {
                if (this.stream.advanceIfChars(END_PROLOG_PATTERN)) {
                    this.state = this.getWithinContentState();
                    return this.finishToken(offset, TokenType.PIEnd);
                }
                if (this.stream.advanceUntilAnyOfChars(END_WS_OR_PROLOG_PATTERN) || this.stream.eos()) {
                    String name = this.getTokenTextFromOffset(offset);
                    if (Constants.PROLOG_NAME_OPTIONS.matcher(name).matches()) {
                        this.state = ScannerState.WithinTag;
                        return this.finishToken(offset, TokenType.PrologName);
                    }
                    if (Constants.ATTRIBUTE_NAME_REGEX.matcher(name).matches()) {
                        this.state = ScannerState.WithinPI;
                        return this.finishToken(offset, TokenType.PIName);
                    }
                }
                this.stream.advanceUntilCharsOrNewTag(END_PROLOG_PATTERN);
                if (this.stream.peekChar() == Constants._LAN) {
                    this.state = ScannerState.WithinContent;
                }
                return this.internalScan();
            }
            case WithinPI: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                if (this.stream.advanceIfChars(END_PROLOG_PATTERN)) {
                    this.state = this.getWithinContentState();
                    return this.finishToken(offset, TokenType.PIEnd);
                }
                if (this.stream.advanceUntilCharsOrNewTag(END_PROLOG_PATTERN)) {
                    if (this.stream.peekChar() == Constants._LAN) {
                        this.state = this.getWithinContentState();
                    }
                    if (this.getTokenTextFromOffset(offset).length() == 0) {
                        return this.finishToken(offset, TokenType.PIEnd);
                    }
                }
                return this.finishToken(offset, TokenType.PIContent);
            }
            case WithinContent: {
                if (this.stream.advanceIfChar(Constants._LAN)) {
                    if (!this.stream.eos() && this.stream.peekChar() == Constants._EXL) {
                        if (this.stream.advanceIfChars(START_COMMENT_PATTERN)) {
                            this.state = ScannerState.WithinComment;
                            return this.finishToken(offset, TokenType.StartCommentTag);
                        }
                        if (this.stream.advanceIfChars(START_CDATA_PATTERN)) {
                            this.state = ScannerState.WithinCDATA;
                            return this.finishToken(offset, TokenType.CDATATagOpen);
                        }
                        if (this.stream.advanceIfChars(START_DOCTYPE_PATTERN)) {
                            this.isDeclCompleted = false;
                            this.state = ScannerState.DTDWithinDoctype;
                            return this.finishToken(offset, TokenType.DTDStartDoctypeTag);
                        }
                    } else if (!this.stream.eos() && this.stream.advanceIfChar(Constants._QMA)) {
                        this.state = ScannerState.PrologOrPI;
                        return this.finishToken(offset, TokenType.StartPrologOrPI);
                    }
                    if (this.stream.advanceIfChar(Constants._FSL)) {
                        this.state = ScannerState.AfterOpeningEndTag;
                        return this.finishToken(offset, TokenType.EndTagOpen);
                    }
                    this.state = ScannerState.AfterOpeningStartTag;
                    return this.finishToken(offset, TokenType.StartTagOpen);
                }
                this.stream.advanceUntilChar(Constants._LAN);
                return this.finishToken(offset, TokenType.Content);
            }
            case WithinCDATA: {
                if (this.stream.advanceIfChars(END_CDATA_PATTERN)) {
                    this.state = ScannerState.WithinContent;
                    return this.finishToken(offset, TokenType.CDATATagClose);
                }
                this.stream.advanceUntilChars(END_CDATA_PATTERN);
                return this.finishToken(offset, TokenType.CDATAContent);
            }
            case AfterOpeningEndTag: {
                if (this.hasNextElementName()) {
                    this.state = ScannerState.WithinEndTag;
                    return this.finishToken(offset, TokenType.EndTag);
                }
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace, this.localize("error.unexpectedWhitespace", "Tag name must directly follow the open bracket."));
                }
                this.state = ScannerState.WithinEndTag;
                if (this.stream.advanceUntilCharOrNewTag(Constants._RAN)) {
                    if (this.stream.peekChar() == Constants._LAN) {
                        this.state = ScannerState.WithinContent;
                    }
                    return this.internalScan();
                }
                return this.finishToken(offset, TokenType.Unknown);
            }
            case WithinEndTag: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                if (this.stream.advanceIfChar(Constants._RAN)) {
                    this.state = ScannerState.WithinContent;
                    return this.finishToken(offset, TokenType.EndTagClose);
                }
                if (this.stream.advanceUntilChar(Constants._LAN)) {
                    this.state = ScannerState.WithinContent;
                    return this.internalScan();
                }
                return this.finishToken(offset, TokenType.Whitespace);
            }
            case AfterOpeningStartTag: {
                if (this.hasNextElementName()) {
                    this.state = ScannerState.WithinTag;
                    return this.finishToken(offset, TokenType.StartTag);
                }
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace, this.localize("error.unexpectedWhitespace", "Tag name must directly follow the open bracket."));
                }
                this.state = ScannerState.WithinTag;
                if (this.stream.advanceUntilCharOrNewTag(Constants._RAN)) {
                    if (this.stream.peekChar() == Constants._LAN) {
                        this.state = ScannerState.WithinContent;
                    }
                    return this.internalScan();
                }
                return this.finishToken(offset, TokenType.Unknown);
            }
            case WithinTag: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                if (this.stream.advanceIfChars(END_PROLOG_PATTERN)) {
                    this.state = this.getWithinContentState();
                    return this.finishToken(offset, TokenType.PrologEnd);
                }
                if (this.hasNextAttributeName()) {
                    this.state = ScannerState.AfterAttributeName;
                    return this.finishToken(offset, TokenType.AttributeName);
                }
                if (this.stream.advanceIfChar(Constants._FSL)) {
                    this.state = ScannerState.WithinTag;
                    if (this.stream.advanceIfChar(Constants._RAN)) {
                        this.state = ScannerState.WithinContent;
                        return this.finishToken(offset, TokenType.StartTagSelfClose);
                    }
                    return this.finishToken(offset, TokenType.Unknown);
                }
                int c = this.stream.peekChar();
                if (c == Constants._DQO || c == Constants._SIQ) {
                    this.state = ScannerState.BeforeAttributeValue;
                    return this.internalScan();
                }
                if (this.stream.advanceIfChar(Constants._RAN)) {
                    this.state = ScannerState.WithinContent;
                    return this.finishToken(offset, TokenType.StartTagClose);
                }
                if (this.stream.advanceUntilChar(Constants._LAN)) {
                    this.state = ScannerState.WithinContent;
                    return this.internalScan();
                }
                return this.finishToken(offset, TokenType.Unknown);
            }
            case AfterAttributeName: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                if (this.stream.advanceIfChar(Constants._EQS)) {
                    this.state = ScannerState.BeforeAttributeValue;
                    return this.finishToken(offset, TokenType.DelimiterAssign);
                }
                this.state = ScannerState.WithinTag;
                return this.internalScan();
            }
            case BeforeAttributeValue: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                if (this.hasNextAttributeValue()) {
                    this.state = ScannerState.WithinTag;
                    return this.finishToken(offset, TokenType.AttributeValue);
                }
                this.state = ScannerState.WithinTag;
                return this.internalScan();
            }
            case DTDWithinDoctype: {
                String doctypeName;
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                if (this.stream.advanceIfChar(Constants._OSB)) {
                    this.state = ScannerState.DTDWithinContent;
                    this.isInsideDTDContent = true;
                    return this.finishToken(offset, TokenType.DTDStartInternalSubset);
                }
                if (this.stream.advanceIfChar(Constants._CSB)) {
                    this.state = ScannerState.DTDWithinDoctype;
                    this.isInsideDTDContent = false;
                    this.isDeclCompleted = true;
                    return this.finishToken(offset, TokenType.DTDEndInternalSubset);
                }
                if (this.stream.advanceIfChar(Constants._RAN)) {
                    this.state = ScannerState.WithinContent;
                    return this.finishToken(offset, TokenType.DTDEndDoctypeTag);
                }
                if (this.stream.peekChar() == Constants._LAN) {
                    this.state = ScannerState.WithinContent;
                    return this.internalScan();
                }
                if (!this.isDeclCompleted && !(doctypeName = this.doctypeName()).equals("")) {
                    this.state = ScannerState.DTDAfterDoctypeName;
                    return this.finishToken(offset, TokenType.DTDDoctypeName);
                }
                this.stream.advanceUntilCharOrNewTag(Constants._RAN);
                return this.finishToken(offset, TokenType.DTDUnrecognizedParameters);
            }
            case DTDAfterDoctypeName: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                if (this.stream.advanceIfChar(Constants._OSB)) {
                    this.state = ScannerState.DTDWithinContent;
                    this.isInsideDTDContent = true;
                    return this.finishToken(offset, TokenType.DTDStartInternalSubset);
                }
                this.lastDoctypeKind = this.doctypeKind();
                if (this.lastDoctypeKind.equals(DOMDocumentType.DocumentTypeKind.PUBLIC.name())) {
                    this.state = ScannerState.DTDAfterDoctypePUBLIC;
                    return this.finishToken(offset, TokenType.DTDDocTypeKindPUBLIC);
                }
                if (this.lastDoctypeKind.equals(DOMDocumentType.DocumentTypeKind.SYSTEM.name())) {
                    this.state = ScannerState.DTDAfterDoctypeSYSTEM;
                    return this.finishToken(offset, TokenType.DTDDocTypeKindSYSTEM);
                }
                this.state = ScannerState.DTDUnrecognizedParameters;
                return this.internalScan();
            }
            case DTDAfterDoctypePUBLIC: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                this.url = this.stream.advanceIfRegExp(Constants.URL_VALUE_REGEX);
                if (!this.url.equals("")) {
                    this.state = ScannerState.DTDAfterDoctypePublicId;
                    return this.finishToken(offset, TokenType.DTDDoctypePublicId);
                }
                this.state = ScannerState.DTDUnrecognizedParameters;
                return this.internalScan();
            }
            case DTDAfterDoctypeSYSTEM: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                this.state = ScannerState.DTDWithinDoctype;
                this.url = this.stream.advanceIfRegExp(Constants.URL_VALUE_REGEX);
                if (!this.url.equals("")) {
                    return this.finishToken(offset, TokenType.DTDDoctypeSystemId);
                }
                this.state = ScannerState.DTDUnrecognizedParameters;
                return this.internalScan();
            }
            case DTDAfterDoctypePublicId: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                this.state = ScannerState.DTDWithinDoctype;
                this.url = this.stream.advanceIfRegExp(Constants.URL_VALUE_REGEX);
                if (!this.url.equals("")) {
                    return this.finishToken(offset, TokenType.DTDDoctypeSystemId);
                }
                this.state = ScannerState.DTDUnrecognizedParameters;
                return this.internalScan();
            }
            case DTDWithinContent: {
                if (!this.isDTDFile && (this.stream.advanceIfChar(Constants._CSB) || this.stream.peekChar() == Constants._RAN)) {
                    this.state = ScannerState.DTDWithinDoctype;
                    this.isInsideDTDContent = false;
                    return this.finishToken(offset, TokenType.DTDEndInternalSubset);
                }
                boolean startsWithLessThanBracket = false;
                if (this.stream.advanceIfChar(Constants._LAN)) {
                    startsWithLessThanBracket = true;
                    if (!this.stream.eos() && this.stream.peekChar() == Constants._EXL) {
                        this.isDeclCompleted = false;
                        if (this.stream.advanceIfChars(START_DTD_ELEMENT_PATTERN)) {
                            this.state = ScannerState.DTDWithinElement;
                            return this.finishToken(offset, TokenType.DTDStartElement);
                        }
                        if (this.stream.advanceIfChars(START_DTD_ATTLIST_PATTERN)) {
                            this.isInitialAttlistDeclCompleted = false;
                            this.state = ScannerState.DTDWithinAttlist;
                            return this.finishToken(offset, TokenType.DTDStartAttlist);
                        }
                        if (this.stream.advanceIfChars(START_DTD_ENTITY_PATTERN)) {
                            this.state = ScannerState.DTDWithinEntity;
                            return this.finishToken(offset, TokenType.DTDStartEntity);
                        }
                        if (this.stream.advanceIfChars(START_DTD_NOTATION_PATTERN)) {
                            this.state = ScannerState.DTDWithinNotation;
                            return this.finishToken(offset, TokenType.DTDStartNotation);
                        }
                        if (this.stream.advanceIfChars(START_COMMENT_PATTERN)) {
                            this.state = ScannerState.WithinComment;
                            return this.finishToken(offset, TokenType.StartCommentTag);
                        }
                    }
                }
                if (this.isDTDFile) {
                    if (startsWithLessThanBracket) {
                        if (this.stream.advanceIfChar(Constants._QMA)) {
                            this.state = ScannerState.PrologOrPI;
                            return this.finishToken(offset, TokenType.StartPrologOrPI);
                        }
                        if (this.stream.advanceUntilCharOrNewTag(Constants._RAN) && this.stream.peekChar() == Constants._RAN) {
                            this.stream.advance(1);
                        }
                    } else {
                        this.stream.advanceUntilChar(Constants._LAN);
                    }
                } else {
                    this.stream.advanceUntilAnyOfChars(END_DTD_DOCTYPE_PATTERN);
                    if (startsWithLessThanBracket && this.stream.peekChar() == Constants._RAN) {
                        this.stream.advance(1);
                    }
                }
                return this.finishToken(offset, TokenType.Content);
            }
            case DTDUnrecognizedParameters: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                if (this.stream.advanceIfChar(Constants._RAN)) {
                    this.state = this.isInsideDTDContent ? ScannerState.DTDWithinContent : ScannerState.WithinContent;
                    this.tempToken = this.isInsideDTDContent ? TokenType.DTDEndTag : TokenType.EndTagClose;
                    return this.finishToken(offset, this.tempToken);
                }
                if (this.stream.peekChar() == Constants._LAN) {
                    this.state = this.isInsideDTDContent ? ScannerState.DTDWithinContent : ScannerState.WithinContent;
                    return this.internalScan();
                }
                if (this.stream.peekChar() == Constants._CSB && this.isInsideDTDContent) {
                    this.state = ScannerState.DTDWithinDoctype;
                    return this.internalScan();
                }
                if (!this.isInsideDTDContent) {
                    this.stream.advanceUntilAnyOfChars(START_DTD_INTERNAL_SUBSET_PATTERN);
                    if (this.stream.peekChar() == Constants._OSB) {
                        this.stream.advance(1);
                        this.stream.advanceUntilCharUsingStack(Constants._CSB);
                    }
                }
                if (this.stream.advanceUntilCharOrNewTag(Constants._RAN) && this.stream.peekChar() == Constants._LAN) {
                    this.state = this.isInsideDTDContent ? ScannerState.DTDWithinContent : ScannerState.DTDWithinDoctype;
                }
                return this.finishToken(offset, TokenType.DTDUnrecognizedParameters);
            }
            case DTDWithinElement: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                if (this.stream.advanceIfChar(Constants._RAN)) {
                    this.state = ScannerState.DTDWithinContent;
                    return this.finishToken(offset, TokenType.DTDEndTag);
                }
                if (this.isDeclCompleted) {
                    this.state = ScannerState.DTDUnrecognizedParameters;
                    return this.internalScan();
                }
                if (!this.stream.advanceIfRegExp(Constants.ELEMENT_NAME_REGEX).equals("")) {
                    this.state = ScannerState.DTDElementAfterName;
                    return this.finishToken(offset, TokenType.DTDElementDeclName);
                }
                this.state = ScannerState.DTDUnrecognizedParameters;
                return this.internalScan();
            }
            case DTDElementAfterName: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                if (this.stream.advanceIfChar(Constants._ORB)) {
                    this.nbBraceOpened = 1;
                    this.state = ScannerState.DTDElementWithinContent;
                    return this.finishToken(offset, TokenType.DTDStartElementContent);
                }
                if (!this.stream.advanceIfRegExpGroup1(Constants.DTD_ELEMENT_CATEGORY).equals("")) {
                    this.isDeclCompleted = true;
                    this.state = ScannerState.DTDWithinElement;
                    return this.finishToken(offset, TokenType.DTDElementCategory);
                }
                this.state = ScannerState.DTDUnrecognizedParameters;
                return this.internalScan();
            }
            case DTDElementWithinContent: {
                if (this.stream.advanceIfChar(Constants._CRB)) {
                    this.isDeclCompleted = true;
                    this.state = ScannerState.DTDWithinElement;
                    this.stream.advanceIfAnyOfChars(DTD_ELEMENT_SEPARATORS);
                    return this.finishToken(offset, TokenType.DTDEndElementContent);
                }
                while (this.nbBraceOpened > 0) {
                    int c = this.stream.peekChar();
                    if (c == Constants._ORB) {
                        ++this.nbBraceOpened;
                    } else if (c == Constants._CRB) {
                        --this.nbBraceOpened;
                        if (this.nbBraceOpened == 0) {
                            return this.finishToken(offset, TokenType.DTDElementContent);
                        }
                    } else {
                        if (c == Constants._RAN) {
                            this.state = ScannerState.DTDWithinElement;
                            return this.finishToken(offset, TokenType.DTDElementContent);
                        }
                        if (c == Constants._LAN) {
                            this.state = ScannerState.DTDWithinContent;
                            return this.finishToken(offset, TokenType.DTDElementContent);
                        }
                        if (c == -1) {
                            return this.finishToken(offset, TokenType.DTDElementContent);
                        }
                    }
                    this.stream.advance(1);
                }
                this.state = ScannerState.DTDUnrecognizedParameters;
                return this.internalScan();
            }
            case DTDWithinAttlist: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                if (this.stream.advanceIfChar(Constants._RAN)) {
                    this.state = ScannerState.DTDWithinContent;
                    return this.finishToken(offset, TokenType.DTDEndTag);
                }
                if (this.isDeclCompleted) {
                    this.state = ScannerState.DTDUnrecognizedParameters;
                    return this.internalScan();
                }
                if (!this.isInitialAttlistDeclCompleted && !this.stream.advanceIfRegExp(Constants.ELEMENT_NAME_REGEX).equals("")) {
                    this.state = ScannerState.DTDAfterAttlistElementName;
                    return this.finishToken(offset, TokenType.DTDAttlistElementName);
                }
                this.state = ScannerState.DTDUnrecognizedParameters;
                return this.internalScan();
            }
            case DTDAfterAttlistElementName: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                if (!this.stream.advanceIfRegExp(Constants.ATTRIBUTE_NAME_REGEX).equals("")) {
                    this.state = ScannerState.DTDAfterAttlistAttributeName;
                    return this.finishToken(offset, TokenType.DTDAttlistAttributeName);
                }
                if (this.stream.advanceIfChar(Constants._RAN)) {
                    this.state = ScannerState.DTDWithinContent;
                    return this.finishToken(offset, TokenType.DTDEndTag);
                }
                this.state = ScannerState.DTDUnrecognizedParameters;
                return this.internalScan();
            }
            case DTDAfterAttlistAttributeName: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                if (!this.stream.advanceIfRegExpGroup1(Constants.DTD_ATTLIST_ATTRIBUTE_TYPE).equals("")) {
                    this.state = ScannerState.DTDAfterAttlistAttributeType;
                    return this.finishToken(offset, TokenType.DTDAttlistAttributeType);
                }
                if (this.stream.advanceIfChar(Constants._RAN)) {
                    this.state = ScannerState.DTDWithinContent;
                    return this.finishToken(offset, TokenType.DTDEndTag);
                }
                this.state = ScannerState.DTDUnrecognizedParameters;
                return this.internalScan();
            }
            case DTDAfterAttlistAttributeType: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                if (!this.stream.advanceIfRegExpGroup1(Constants.DTD_ATTLIST_ATTRIBUTE_VALUE).equals("")) {
                    this.isInitialAttlistDeclCompleted = true;
                    this.isDeclCompleted = true;
                    this.state = ScannerState.DTDAfterAttlistElementName;
                    return this.finishToken(offset, TokenType.DTDAttlistAttributeValue);
                }
                if (this.stream.advanceIfChar(Constants._RAN)) {
                    this.state = ScannerState.DTDWithinContent;
                    return this.finishToken(offset, TokenType.DTDEndTag);
                }
                this.state = ScannerState.DTDUnrecognizedParameters;
                return this.internalScan();
            }
            case DTDWithinEntity: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                if (this.stream.advanceIfChar(Constants._RAN)) {
                    this.state = ScannerState.DTDWithinContent;
                    return this.finishToken(offset, TokenType.DTDEndTag);
                }
                if (this.isDeclCompleted) {
                    this.state = ScannerState.DTDUnrecognizedParameters;
                    return this.internalScan();
                }
                if (!this.stream.advanceIfRegExp(Constants.ELEMENT_NAME_REGEX).equals("")) {
                    this.state = ScannerState.DTDAfterEntityName;
                    return this.finishToken(offset, TokenType.DTDEntityName);
                }
                if (this.stream.advanceIfChar(Constants._PCT)) {
                    return this.finishToken(offset, TokenType.DTDEntityPercent);
                }
                this.state = ScannerState.DTDUnrecognizedParameters;
                return this.internalScan();
            }
            case DTDAfterEntityName: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                if (!this.stream.advanceIfRegExp(Constants.DTD_ENTITY_VALUE).equals("")) {
                    this.isDeclCompleted = true;
                    this.state = ScannerState.DTDWithinEntity;
                    return this.finishToken(offset, TokenType.DTDEntityValue);
                }
                this.lastDoctypeKind = this.doctypeKind();
                if (this.lastDoctypeKind.equals(DOMDocumentType.DocumentTypeKind.PUBLIC.name())) {
                    this.state = ScannerState.DTDAfterEntityPUBLIC;
                    return this.finishToken(offset, TokenType.DTDEntityKindPUBLIC);
                }
                if (this.lastDoctypeKind.equals(DOMDocumentType.DocumentTypeKind.SYSTEM.name())) {
                    this.state = ScannerState.DTDAfterEntitySYSTEM;
                    return this.finishToken(offset, TokenType.DTDEntityKindSYSTEM);
                }
                if (this.stream.advanceIfChar(Constants._RAN)) {
                    this.state = ScannerState.DTDWithinContent;
                    return this.finishToken(offset, TokenType.DTDEndTag);
                }
                this.state = ScannerState.DTDUnrecognizedParameters;
                return this.internalScan();
            }
            case DTDAfterEntityPUBLIC: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                if (!this.stream.advanceIfRegExp(Constants.URL_VALUE_REGEX).equals("")) {
                    this.state = ScannerState.DTDAfterEntitySYSTEM;
                    return this.finishToken(offset, TokenType.DTDEntityPublicId);
                }
                if (this.stream.advanceIfChar(Constants._RAN)) {
                    this.state = ScannerState.DTDWithinContent;
                    return this.finishToken(offset, TokenType.DTDEndTag);
                }
                this.state = ScannerState.DTDUnrecognizedParameters;
                return this.internalScan();
            }
            case DTDAfterEntitySYSTEM: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                if (!this.stream.advanceIfRegExp(Constants.URL_VALUE_REGEX).equals("")) {
                    this.isDeclCompleted = true;
                    this.state = ScannerState.DTDWithinEntity;
                    return this.finishToken(offset, TokenType.DTDEntitySystemId);
                }
                if (this.stream.advanceIfChar(Constants._RAN)) {
                    this.state = ScannerState.DTDWithinContent;
                    return this.finishToken(offset, TokenType.DTDEndTag);
                }
                this.state = ScannerState.DTDUnrecognizedParameters;
                return this.internalScan();
            }
            case DTDWithinNotation: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                if (this.stream.advanceIfChar(Constants._RAN)) {
                    this.state = ScannerState.DTDWithinContent;
                    return this.finishToken(offset, TokenType.DTDEndTag);
                }
                if (this.isDeclCompleted) {
                    this.state = ScannerState.DTDUnrecognizedParameters;
                    return this.internalScan();
                }
                if (!this.stream.advanceIfRegExp(Constants.ELEMENT_NAME_REGEX).equals("")) {
                    this.state = ScannerState.DTDAfterNotationName;
                    return this.finishToken(offset, TokenType.DTDNotationName);
                }
                this.state = ScannerState.DTDUnrecognizedParameters;
                return this.internalScan();
            }
            case DTDAfterNotationName: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                this.lastDoctypeKind = this.doctypeKind();
                if (this.lastDoctypeKind.equals(DOMDocumentType.DocumentTypeKind.PUBLIC.name())) {
                    this.state = ScannerState.DTDAfterNotationPUBLIC;
                    return this.finishToken(offset, TokenType.DTDNotationKindPUBLIC);
                }
                if (this.lastDoctypeKind.equals(DOMDocumentType.DocumentTypeKind.SYSTEM.name())) {
                    this.state = ScannerState.DTDAfterNotationSYSTEM;
                    return this.finishToken(offset, TokenType.DTDNotationKindSYSTEM);
                }
                this.state = ScannerState.DTDUnrecognizedParameters;
                return this.internalScan();
            }
            case DTDAfterNotationPUBLIC: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                this.url = this.stream.advanceIfRegExp(Constants.URL_VALUE_REGEX);
                if (!this.url.equals("")) {
                    this.isDeclCompleted = true;
                    this.state = ScannerState.DTDAfterNotationPublicId;
                    return this.finishToken(offset, TokenType.DTDNotationPublicId);
                }
                this.state = ScannerState.DTDUnrecognizedParameters;
                return this.internalScan();
            }
            case DTDAfterNotationSYSTEM: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                this.state = ScannerState.DTDWithinNotation;
                this.url = this.stream.advanceIfRegExp(Constants.URL_VALUE_REGEX);
                if (!this.url.equals("")) {
                    this.isDeclCompleted = true;
                    this.state = ScannerState.DTDAfterNotationName;
                    return this.finishToken(offset, TokenType.DTDNotationSystemId);
                }
                this.state = ScannerState.DTDUnrecognizedParameters;
                return this.internalScan();
            }
            case DTDAfterNotationPublicId: {
                if (this.stream.skipWhitespace()) {
                    return this.finishToken(offset, TokenType.Whitespace);
                }
                this.state = ScannerState.DTDAfterNotationName;
                this.url = this.stream.advanceIfRegExp(Constants.URL_VALUE_REGEX);
                if (!this.url.equals("")) {
                    this.isDeclCompleted = true;
                    return this.finishToken(offset, TokenType.DTDNotationSystemId);
                }
                this.state = ScannerState.DTDUnrecognizedParameters;
                return this.internalScan();
            }
        }
        this.stream.advance(1);
        this.state = this.isInsideDTDContent ? ScannerState.DTDWithinContent : ScannerState.WithinContent;
        return this.finishToken(offset, TokenType.Unknown, errorMessage);
    }

    private String localize(String string, String string2) {
        return string;
    }

    private ScannerState getWithinContentState() {
        if (this.isDTDFile) {
            return ScannerState.DTDWithinContent;
        }
        return ScannerState.WithinContent;
    }

    public int getLastNonWhitespaceOffset() {
        return this.stream.getLastNonWhitespaceOffset();
    }

    @Override
    public TokenType getTokenType() {
        return this.tokenType;
    }

    @Override
    public int getTokenOffset() {
        return this.tokenOffset;
    }

    @Override
    public int getTokenLength() {
        return this.stream.pos() - this.tokenOffset;
    }

    @Override
    public int getTokenEnd() {
        return this.stream.pos();
    }

    @Override
    public String getTokenText() {
        return this.stream.getSource().substring(this.tokenOffset, this.stream.pos());
    }

    @Override
    public boolean isTokenTextBlank() {
        return StringUtils.isWhitespace(this.stream.getSource(), this.tokenOffset, this.stream.pos());
    }

    @Override
    public ScannerState getScannerState() {
        return this.state;
    }

    @Override
    public String getTokenError() {
        return this.tokenError;
    }

    public String getTokenTextFromOffset(int offset) {
        return this.stream.getSource().substring(offset, this.stream.pos());
    }

    public static Scanner createScanner(String input) {
        return XMLScanner.createScanner(input, false);
    }

    public static Scanner createScanner(String input, boolean isDTD) {
        return XMLScanner.createScanner(input, 0, isDTD);
    }

    public static Scanner createScanner(String input, int initialOffset) {
        return XMLScanner.createScanner(input, initialOffset, false);
    }

    public static Scanner createScanner(String input, int initialOffset, boolean isDTDFile) {
        return XMLScanner.createScanner(input, initialOffset, isDTDFile ? ScannerState.DTDWithinContent : ScannerState.WithinContent, isDTDFile);
    }

    public static Scanner createScanner(String input, int initialOffset, ScannerState initialState) {
        return new XMLScanner(input, initialOffset, initialState, false);
    }

    public static Scanner createScanner(String input, int initialOffset, ScannerState initialState, boolean isDTDFile) {
        return new XMLScanner(input, initialOffset, initialState, isDTDFile);
    }
}

