/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.commons.TextDocument;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class TextEditUtils {
    private static final Logger LOGGER = Logger.getLogger(TextEditUtils.class.getName());

    public static TextEdit createTextEditIfNeeded(int from, int to, String expectedContent, TextDocument textDocument) {
        String text = textDocument.getText();
        if (TextEditUtils.isMatchExpectedContent(from, to, expectedContent, text)) {
            return null;
        }
        try {
            Position endPos = textDocument.positionAt(to);
            Position startPos = to == from ? endPos : textDocument.positionAt(from);
            Range range = new Range(startPos, endPos);
            return new TextEdit(range, expectedContent);
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    private static boolean isMatchExpectedContent(int from, int to, String expectedContent, String text) {
        if (expectedContent.length() == to - from) {
            int j = 0;
            for (int i = from; i < to; ++i) {
                char c = text.charAt(i);
                if (expectedContent.charAt(j) != c) {
                    return false;
                }
                ++j;
            }
        } else {
            return false;
        }
        return true;
    }

    public static String applyEdits(TextDocument document, List<? extends TextEdit> edits) throws BadLocationException {
        String text = document.getText();
        Collections.sort(edits, (a, b) -> {
            int diff = a.getRange().getStart().getLine() - b.getRange().getStart().getLine();
            if (diff == 0) {
                return a.getRange().getStart().getCharacter() - b.getRange().getStart().getCharacter();
            }
            return diff;
        });
        int lastModifiedOffset = 0;
        ArrayList<String> spans = new ArrayList<String>();
        for (TextEdit textEdit : edits) {
            int startOffset = document.offsetAt(textEdit.getRange().getStart());
            if (startOffset < lastModifiedOffset) {
                throw new Error("Overlapping edit");
            }
            if (startOffset > lastModifiedOffset) {
                spans.add(text.substring(lastModifiedOffset, startOffset));
            }
            if (textEdit.getNewText() != null) {
                spans.add(textEdit.getNewText());
            }
            lastModifiedOffset = document.offsetAt(textEdit.getRange().getEnd());
        }
        spans.add(text.substring(lastModifiedOffset));
        return spans.stream().collect(Collectors.joining());
    }

    public static int adjustOffsetWithLeftWhitespaces(int leftLimit, int to, String text) {
        if (to == 0) {
            return -1;
        }
        for (int i = to - 1; i >= leftLimit; --i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return i + 1;
        }
        return leftLimit;
    }
}

