/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.model;

import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelProvider;
import org.eclipse.lemminx.extensions.contentmodel.model.GrammarCacheInfo;
import org.eclipse.lemminx.uriresolver.ResolvedURIInfo;

public class ReferencedGrammarInfo {
    private final ResolvedURIInfo resolvedURIInfo;
    private final GrammarCacheInfo grammarCacheInfo;
    private final ContentModelProvider.Identifier identifier;

    public ReferencedGrammarInfo(ResolvedURIInfo resolvedURIInfo, GrammarCacheInfo grammarCacheInfo, ContentModelProvider.Identifier identifier) {
        this.resolvedURIInfo = resolvedURIInfo;
        this.grammarCacheInfo = grammarCacheInfo;
        this.identifier = identifier;
    }

    public ResolvedURIInfo getResolvedURIInfo() {
        return this.resolvedURIInfo;
    }

    public GrammarCacheInfo getGrammarCacheInfo() {
        return this.grammarCacheInfo;
    }

    public ContentModelProvider.Identifier getIdentifier() {
        return this.identifier;
    }

    public boolean isInCache() {
        return this.grammarCacheInfo != null;
    }

    public String getIdentifierURI() {
        if (this.identifier == null) {
            return null;
        }
        String publicId = this.identifier.getPublicId();
        String systemId = this.identifier.getSystemId();
        return publicId != null ? publicId : systemId;
    }

    public String getBindingKind() {
        return this.identifier != null ? this.identifier.getKind() : null;
    }

    public String getResolvedBy() {
        String resolvedBy = this.resolvedURIInfo != null ? this.resolvedURIInfo.getResolverName() : null;
        return "default".equals(resolvedBy) ? null : resolvedBy;
    }

    public static String getBindingKindAndResolvedBy(ReferencedGrammarInfo info) {
        String resolverBy;
        boolean hasKind;
        StringBuilder bindingName = new StringBuilder();
        String bindingKind = info.getBindingKind();
        boolean bl = hasKind = bindingKind != null;
        if (hasKind) {
            bindingName.append(bindingKind);
        }
        if ((resolverBy = info.getResolvedBy()) != null) {
            if (bindingName.length() > 0) {
                bindingName.append(" ");
            }
            bindingName.append("with ");
            bindingName.append(resolverBy);
        }
        return bindingName.toString();
    }
}

