/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.utils.platform;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.lemminx.utils.platform.Platform;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PlatformTest {
    @Test
    public void testVersion() {
        String version = Platform.getVersion().getVersionNumber();
        Pattern pattern = Pattern.compile("^(\\d+\\.\\d+\\.\\d+)(-.*)$");
        Matcher matcher = pattern.matcher(version);
        Assertions.assertTrue((boolean)matcher.matches(), (String)("Unexpected format for :" + version));
    }

    @Test
    public void testGitInfos() {
        Assertions.assertNotNull((Object)Platform.getVersion().getBranch(), (String)"Branch was not set");
        Assertions.assertNotNull((Object)Platform.getVersion().getCommitMessage(), (String)"Commit message was not set");
        Assertions.assertNotNull((Object)Platform.getVersion().getShortCommitId(), (String)"Commit id was not set");
    }

    @Test
    public void testDetails() {
        String details = Platform.details();
        Assertions.assertTrue((boolean)details.contains(Platform.getVersion().getVersionNumber()), (String)"version is missing from the details");
        Assertions.assertTrue((boolean)details.contains(Platform.getJVM().getJavaHome()), (String)"Java is missing from the details");
        Assertions.assertTrue((boolean)details.contains(Platform.getVersion().getCommitMessage()), (String)"commit message is missing from the details");
        Assertions.assertTrue((boolean)details.contains(Platform.getVersion().getShortCommitId()), (String)"commit id is missing from the details");
        String branch = Platform.getVersion().getBranch();
        if ("main".equals(branch)) {
            Assertions.assertFalse((boolean)details.contains(branch), (String)"main branch should not be in the details");
        } else {
            Assertions.assertTrue((boolean)details.contains(branch), (String)(branch + " branch is missing from the details"));
        }
    }
}

