/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format.experimental;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.settings.EnforceQuoteStyle;
import org.eclipse.lemminx.settings.QuoteStyle;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.TextEdit;
import org.junit.jupiter.api.Test;

public class XMLFormatterQuoteStyleTest {
    @Test
    public void testUseDoubleQuotesFromDoubleQuotes() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        settings.getPreferences().setQuoteStyle(QuoteStyle.doubleQuotes);
        String content = "<a name=  \" value \"> </a>";
        String expected = "<a name=\" value \"> </a>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, XMLAssert.te(0, 8, 0, 10, ""));
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testUseSingleQuotesFromSingleQuotes() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<a name=  ' value '> </a>";
        String expected = "<a name=' value '> </a>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, XMLAssert.te(0, 8, 0, 10, ""));
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testUseSingleQuotesFromDoubleQuotes() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<a name=  \" value \"> </a>";
        String expected = "<a name=' value '> </a>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, XMLAssert.te(0, 8, 0, 10, ""), XMLAssert.te(0, 10, 0, 11, "'"), XMLAssert.te(0, 18, 0, 19, "'"));
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testUseDoubleQuotesFromSingleQuotes() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<a name=  ' value '> </a>";
        String expected = "<a name=\" value \"> </a>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, XMLAssert.te(0, 8, 0, 10, ""), XMLAssert.te(0, 10, 0, 11, "\""), XMLAssert.te(0, 18, 0, 19, "\""));
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testUseDoubleQuotesFromSingleQuotesUnclosedEnd() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<a name=  ' value > </a>";
        String expected = "<a name=\" value > </a>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, XMLAssert.te(0, 8, 0, 10, ""), XMLAssert.te(0, 10, 0, 11, "\""));
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testUseDoubleQuotesFromSingleQuotesUnclosedStart() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<a name=  value '> </a>";
        String expected = "<a name= value \"> </a>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, XMLAssert.te(0, 8, 0, 10, " "), XMLAssert.te(0, 16, 0, 17, "\""));
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testUseDoubleQuotesFromSingleQuotesMisMatchStart() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<a name=  ' value \"> </a>";
        String expected = "<a name=\" value \"> </a>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, XMLAssert.te(0, 8, 0, 10, ""), XMLAssert.te(0, 10, 0, 11, "\""));
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testUseDoubleQuotesFromSingleQuotesMisMatchEnd() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<a name=  \" value '> </a>";
        String expected = "<a name=\" value '> </a>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, XMLAssert.te(0, 8, 0, 10, ""));
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testUseSingleQuotesNoQuotes() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        String content = "<a name = test> </a>";
        String expected = "<a name= test> </a>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, XMLAssert.te(0, 7, 0, 8, ""));
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testUseSingleQuotesNoQuotesSplit() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setSplitAttributes(true);
        String content = "<a name = test> </a>";
        String expected = "<a" + System.lineSeparator() + "    name=" + System.lineSeparator() + "    test> </a>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, XMLAssert.te(0, 2, 0, 3, System.lineSeparator() + "    "), XMLAssert.te(0, 7, 0, 8, ""), XMLAssert.te(0, 9, 0, 10, System.lineSeparator() + "    "));
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testAttValueOnlyStartQuote() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        String content = "<a name = \"> </a>";
        String expected = "<a name=\"> </a>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, XMLAssert.te(0, 7, 0, 8, ""), XMLAssert.te(0, 9, 0, 10, ""));
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testUseDoubleQuotesMultipleAttributes() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<a name1=  \" value1 \"  name2= \" value2 \"   name3= ' value3 ' > </a>";
        String expected = "<a name1=\" value1 \" name2=\" value2 \" name3=\" value3 \"> </a>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, XMLAssert.te(0, 9, 0, 11, ""), XMLAssert.te(0, 21, 0, 23, " "), XMLAssert.te(0, 29, 0, 30, ""), XMLAssert.te(0, 40, 0, 43, " "), XMLAssert.te(0, 49, 0, 50, ""), XMLAssert.te(0, 50, 0, 51, "\""), XMLAssert.te(0, 59, 0, 60, "\""), XMLAssert.te(0, 60, 0, 61, ""));
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testUseSingleQuotesMultipleAttributes() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<a name1=  \" value1 \"  name2= \" value2 \"   name3= ' value3 ' > </a>";
        String expected = "<a name1=' value1 ' name2=' value2 ' name3=' value3 '> </a>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, XMLAssert.te(0, 9, 0, 11, ""), XMLAssert.te(0, 11, 0, 12, "'"), XMLAssert.te(0, 20, 0, 21, "'"), XMLAssert.te(0, 21, 0, 23, " "), XMLAssert.te(0, 29, 0, 30, ""), XMLAssert.te(0, 30, 0, 31, "'"), XMLAssert.te(0, 39, 0, 40, "'"), XMLAssert.te(0, 40, 0, 43, " "), XMLAssert.te(0, 49, 0, 50, ""), XMLAssert.te(0, 60, 0, 61, ""));
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testUseDoubleQuotesMultipleAttributesSplit() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSplitAttributes(true);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<a name1=  \" value1 \"  name2= \" value2 \"   name3= ' value3 ' > </a>\n";
        String expected = "<a\n    name1=\" value1 \"\n    name2=\" value2 \"\n    name3=\" value3 \"> </a>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, XMLAssert.te(0, 2, 0, 3, "\n    "), XMLAssert.te(0, 9, 0, 11, ""), XMLAssert.te(0, 21, 0, 23, "\n    "), XMLAssert.te(0, 29, 0, 30, ""), XMLAssert.te(0, 40, 0, 43, "\n    "), XMLAssert.te(0, 49, 0, 50, ""), XMLAssert.te(0, 50, 0, 51, "\""), XMLAssert.te(0, 59, 0, 60, "\""), XMLAssert.te(0, 60, 0, 61, ""), XMLAssert.te(0, 67, 1, 0, ""));
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testUseSingleQuotesMultipleAttributesSplit() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSplitAttributes(true);
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<a name1=  \" value1 \"  name2= \" value2 \"   name3= ' value3 ' > </a>\n";
        String expected = "<a\n    name1=' value1 '\n    name2=' value2 '\n    name3=' value3 '> </a>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, XMLAssert.te(0, 2, 0, 3, "\n    "), XMLAssert.te(0, 9, 0, 11, ""), XMLAssert.te(0, 11, 0, 12, "'"), XMLAssert.te(0, 20, 0, 21, "'"), XMLAssert.te(0, 21, 0, 23, "\n    "), XMLAssert.te(0, 29, 0, 30, ""), XMLAssert.te(0, 30, 0, 31, "'"), XMLAssert.te(0, 39, 0, 40, "'"), XMLAssert.te(0, 40, 0, 43, "\n    "), XMLAssert.te(0, 49, 0, 50, ""), XMLAssert.te(0, 60, 0, 61, ""), XMLAssert.te(0, 67, 1, 0, ""));
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testUseSingleQuotesLocalDTD() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<!DOCTYPE note SYSTEM \"note.dtd\">";
        String expected = "<!DOCTYPE note SYSTEM 'note.dtd'>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, XMLAssert.te(0, 22, 0, 23, "'"), XMLAssert.te(0, 31, 0, 32, "'"));
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testUseSingleQuotesLocalDTDUnclosedStart() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<!DOCTYPE note SYSTEM note.dtd\">";
        String expected = "<!DOCTYPE note SYSTEM note.dtd\">";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, new TextEdit[0]);
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testUseSingleQuotesLocalDTDUnclosedEnd() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<!DOCTYPE note SYSTEM \"note.dtd>";
        String expected = "<!DOCTYPE note SYSTEM \"note.dtd>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, new TextEdit[0]);
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testUseSingleQuotesLocalDTDWithSubset() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<!DOCTYPE article [\n  <!ENTITY AUTHOR \"John Doe\">\n  <!ENTITY COMPANY \"JD Power Tools, Inc.\">\n  <!ENTITY EMAIL \"jd@jd-tools.com\">\n  <!ELEMENT E EMPTY>\n  <!ATTLIST E WIDTH CDATA \"0\">\n]>\n\n<root attr=\"hello\"></root>";
        String expected = "<!DOCTYPE article [\n  <!ENTITY AUTHOR 'John Doe'>\n  <!ENTITY COMPANY 'JD Power Tools, Inc.'>\n  <!ENTITY EMAIL 'jd@jd-tools.com'>\n  <!ELEMENT E EMPTY>\n  <!ATTLIST E WIDTH CDATA '0'>\n]>\n<root attr='hello'></root>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, XMLAssert.te(1, 18, 1, 19, "'"), XMLAssert.te(1, 27, 1, 28, "'"), XMLAssert.te(2, 19, 2, 20, "'"), XMLAssert.te(2, 40, 2, 41, "'"), XMLAssert.te(3, 17, 3, 18, "'"), XMLAssert.te(3, 33, 3, 34, "'"), XMLAssert.te(5, 26, 5, 27, "'"), XMLAssert.te(5, 28, 5, 29, "'"), XMLAssert.te(6, 2, 8, 0, "\n"), XMLAssert.te(8, 11, 8, 12, "'"), XMLAssert.te(8, 17, 8, 18, "'"));
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testUseSingleQuotesLocalDTDWithSubsetUnclosed() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<!DOCTYPE article [\n  <!ENTITY AUTHOR John Doe\">\n  <!ENTITY COMPANY \"JD Power Tools, Inc.>\n  <!ENTITY EMAIL \"jd@jd-tools.com\">\n  <!ELEMENT E EMPTY>\n  <!ATTLIST E WIDTH CDATA 0\">\n]>\n\n<root attr=\"hello\"></root>";
        String expected = "<!DOCTYPE article [\n  <!ENTITY AUTHOR John Doe\">\n  <!ENTITY COMPANY \"JD Power Tools, Inc.>\n  <!ENTITY EMAIL 'jd@jd-tools.com'>\n  <!ELEMENT E EMPTY>\n  <!ATTLIST E WIDTH CDATA 0\">\n]>\n<root attr='hello'></root>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, XMLAssert.te(3, 17, 3, 18, "'"), XMLAssert.te(3, 33, 3, 34, "'"), XMLAssert.te(6, 2, 8, 0, "\n"), XMLAssert.te(8, 11, 8, 12, "'"), XMLAssert.te(8, 17, 8, 18, "'"));
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testUseSingleQuotesDTDFile() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<!ENTITY AUTHOR \"John Doe\">\n<!ENTITY COMPANY \"JD Power Tools, Inc.\">\n<!ENTITY EMAIL \"jd@jd-tools.com\">\n<!ELEMENT E EMPTY>\n<!ATTLIST E WIDTH CDATA \"0\">";
        String expected = "<!ENTITY AUTHOR 'John Doe'>\n<!ENTITY COMPANY 'JD Power Tools, Inc.'>\n<!ENTITY EMAIL 'jd@jd-tools.com'>\n<!ELEMENT E EMPTY>\n<!ATTLIST E WIDTH CDATA '0'>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, "test.dtd", XMLAssert.te(0, 16, 0, 17, "'"), XMLAssert.te(0, 25, 0, 26, "'"), XMLAssert.te(1, 17, 1, 18, "'"), XMLAssert.te(1, 38, 1, 39, "'"), XMLAssert.te(2, 15, 2, 16, "'"), XMLAssert.te(2, 31, 2, 32, "'"), XMLAssert.te(4, 24, 4, 25, "'"), XMLAssert.te(4, 26, 4, 27, "'"));
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testDontFormatQuotesByDefault() throws BadLocationException {
        String content;
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        String expected = content = "<a number='\"one\"'></a>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, new TextEdit[0]);
        settings.getPreferences().setQuoteStyle(QuoteStyle.doubleQuotes);
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, new TextEdit[0]);
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testAttributeNameTouchingPreviousValue() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        settings.getFormattingSettings().setSplitAttributes(true);
        String content = "<xml>\r\n  <a zz= tt = \"aa\"aa ></a>\r\n</xml>";
        String expected = "<xml>\r\n  <a\r\n      zz=\r\n      tt='aa'\r\n      aa></a>\r\n</xml>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, XMLAssert.te(1, 4, 1, 5, "\r\n      "), XMLAssert.te(1, 8, 1, 9, "\r\n      "), XMLAssert.te(1, 11, 1, 12, ""), XMLAssert.te(1, 13, 1, 14, ""), XMLAssert.te(1, 14, 1, 15, "'"), XMLAssert.te(1, 17, 1, 18, "'"), XMLAssert.te(1, 18, 1, 18, "\r\n      "), XMLAssert.te(1, 20, 1, 21, ""));
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void enforceSingleQuoteStyle() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<a  attr   =     \"value\" />";
        String expected = "<a attr='value' />";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, XMLAssert.te(0, 2, 0, 4, " "), XMLAssert.te(0, 8, 0, 11, ""), XMLAssert.te(0, 12, 0, 17, ""), XMLAssert.te(0, 17, 0, 18, "'"), XMLAssert.te(0, 23, 0, 24, "'"));
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void enforceDoubleQuoteStyle() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.doubleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<a  attr   =     'value' />";
        String expected = "<a attr=\"value\" />";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, XMLAssert.te(0, 2, 0, 4, " "), XMLAssert.te(0, 8, 0, 11, ""), XMLAssert.te(0, 12, 0, 17, ""), XMLAssert.te(0, 17, 0, 18, "\""), XMLAssert.te(0, 23, 0, 24, "\""));
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void enforceSingleQuoteStyleProlog() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        String expected = "<?xml version='1.0' encoding='UTF-8'?>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, XMLAssert.te(0, 14, 0, 15, "'"), XMLAssert.te(0, 18, 0, 19, "'"), XMLAssert.te(0, 29, 0, 30, "'"), XMLAssert.te(0, 35, 0, 36, "'"));
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void enforceDoubleQuoteStyleProlog() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.doubleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<?xml version='1.0' encoding='UTF-8'?>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, XMLAssert.te(0, 14, 0, 15, "\""), XMLAssert.te(0, 18, 0, 19, "\""), XMLAssert.te(0, 29, 0, 30, "\""), XMLAssert.te(0, 35, 0, 36, "\""));
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void enforceDoubleQuoteStyleProlo() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.doubleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        String content = "<?xml version= 1.0' encoding='UTF-8?>";
        String expected = "<?xml version= 1.0\" encoding=\" UTF-8?>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, XMLAssert.te(0, 18, 0, 19, "\""), XMLAssert.te(0, 29, 0, 30, "\""), XMLAssert.te(0, 30, 0, 30, " "));
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void dontEnforceSingleQuoteStyle() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.ignore);
        String content = "<a attr  =   \"'\" attr2   =     '\"' />";
        String expected = "<a attr=\"'\" attr2='\"' />";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, XMLAssert.te(0, 7, 0, 9, ""), XMLAssert.te(0, 10, 0, 13, ""), XMLAssert.te(0, 22, 0, 25, ""), XMLAssert.te(0, 26, 0, 31, ""));
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void dontEnforceSingleQuoteStyleProlog() throws BadLocationException {
        String content;
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.ignore);
        String expected = content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, new TextEdit[0]);
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void dontEnforceDoubleQuoteStyleProlog() throws BadLocationException {
        String content;
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.ignore);
        String expected = content = "<?xml version='1.0' encoding='UTF-8'?>";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, new TextEdit[0]);
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void dontEnforceDoubleQuoteStyle() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.doubleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.ignore);
        String content = "<a attr  =   \"'\" attr2   =     '\"' />";
        String expected = "<a attr=\"'\" attr2='\"' />";
        XMLFormatterQuoteStyleTest.assertFormat(content, expected, settings, XMLAssert.te(0, 7, 0, 9, ""), XMLAssert.te(0, 10, 0, 13, ""), XMLAssert.te(0, 22, 0, 25, ""), XMLAssert.te(0, 26, 0, 31, ""));
        XMLFormatterQuoteStyleTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterQuoteStyleTest.assertFormat(unformatted, expected, sharedSettings, "test://test.html", expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterQuoteStyleTest.assertFormat(unformatted, expected, sharedSettings, uri, true, expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, Boolean considerRangeFormat, TextEdit ... expectedEdits) throws BadLocationException {
        sharedSettings.getFormattingSettings().setExperimental(true);
        XMLAssert.assertFormat(null, unformatted, expected, sharedSettings, uri, considerRangeFormat, expectedEdits);
    }
}

