/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format.experimental;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.TextEdit;
import org.junit.jupiter.api.Test;

public class XMLFormatterJoinContentLinesTest {
    @Test
    public void testPreserveEmptyContentWithJoinContentLines() throws BadLocationException {
        String content;
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveEmptyContent(true);
        settings.getFormattingSettings().setJoinContentLines(true);
        String expected = content = "<a>\n   xx  \n   yy  \n   <b>  </b>  \n</a>";
        XMLFormatterJoinContentLinesTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testJoinContentLinesTrue() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveEmptyContent(false);
        settings.getFormattingSettings().setJoinContentLines(true);
        String content = "<a>\n   zz  \n   zz  </a>";
        String expected = "<a> zz zz </a>";
        XMLFormatterJoinContentLinesTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 3, " "), XMLAssert.te(1, 5, 2, 3, " "), XMLAssert.te(2, 5, 2, 7, " "));
        XMLFormatterJoinContentLinesTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testJoinContentLinesTrue2() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveEmptyContent(false);
        settings.getFormattingSettings().setJoinContentLines(true);
        String content = "<a>zz zz zz</a>";
        String expected = "<a>zz zz zz</a>";
        XMLFormatterJoinContentLinesTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testJoinContentLinesFalse() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveEmptyContent(false);
        settings.getFormattingSettings().setJoinContentLines(false);
        String content = "<a>\n   zz  \n   zz  </a>";
        String expected = "<a> zz  \n   zz </a>";
        XMLFormatterJoinContentLinesTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 3, " "), XMLAssert.te(2, 5, 2, 7, " "));
        XMLFormatterJoinContentLinesTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testJoinContentLinesFalseEmptyContent() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveEmptyContent(false);
        settings.getFormattingSettings().setJoinContentLines(false);
        String content = "<a>\n     \n     </a>";
        String expected = "<a> </a>";
        XMLFormatterJoinContentLinesTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 2, 5, " "));
        XMLFormatterJoinContentLinesTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testJoinContentLinesWithSiblingElementTrue() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveEmptyContent(false);
        settings.getFormattingSettings().setJoinContentLines(true);
        String content = "<a>\n   zz  \n   zz  \n   <b>  </b>  \n</a>";
        String expected = "<a> zz zz <b> </b>\n</a>";
        XMLFormatterJoinContentLinesTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 3, " "), XMLAssert.te(1, 5, 2, 3, " "), XMLAssert.te(2, 5, 3, 3, " "), XMLAssert.te(3, 6, 3, 8, " "), XMLAssert.te(3, 12, 4, 0, "\n"));
        XMLFormatterJoinContentLinesTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testJoinContentLinesWithSiblingElementFalse() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveEmptyContent(false);
        settings.getFormattingSettings().setJoinContentLines(false);
        String content = "<a>\n   zz  \n   zz  \n   <a>  </a>  \n</a>";
        String expected = "<a> zz  \n   zz <a> </a>\n</a>";
        XMLFormatterJoinContentLinesTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 3, " "), XMLAssert.te(2, 5, 3, 3, " "), XMLAssert.te(3, 6, 3, 8, " "), XMLAssert.te(3, 12, 4, 0, "\n"));
        XMLFormatterJoinContentLinesTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterJoinContentLinesTest.assertFormat(unformatted, expected, sharedSettings, "test://test.html", expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterJoinContentLinesTest.assertFormat(unformatted, expected, sharedSettings, uri, true, expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, Boolean considerRangeFormat, TextEdit ... expectedEdits) throws BadLocationException {
        sharedSettings.getFormattingSettings().setExperimental(true);
        XMLAssert.assertFormat(null, unformatted, expected, sharedSettings, uri, considerRangeFormat, expectedEdits);
    }
}

