/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsd.participants;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xerces.xni.XMLLocator;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.s4s_elt_invalid_content_3CodeAction;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.src_import_1_2CodeAction;
import org.eclipse.lemminx.services.extensions.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.diagnostics.IXMLErrorCode;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.Range;

public enum XSDErrorCode implements IXMLErrorCode
{
    cos_all_limited_2("cos-all-limited.2"),
    ct_props_correct_3("ct-props-correct.3"),
    p_props_correct_2_1("p-props-correct.2.1"),
    s4s_elt_invalid_content_1("s4s-elt-invalid-content.1"),
    s4s_elt_must_match_1("s4s-elt-must-match.1"),
    s4s_elt_must_match_2("s4s-elt-must-match.2"),
    s4s_att_must_appear("s4s-att-must-appear"),
    s4s_elt_invalid_content_2("s4s-elt-invalid-content.2"),
    s4s_att_not_allowed("s4s-att-not-allowed"),
    s4s_att_invalid_value("s4s-att-invalid-value"),
    s4s_elt_character("s4s-elt-character"),
    s4s_elt_invalid_content_3("s4s-elt-invalid-content.3"),
    sch_props_correct_2("sch-props-correct.2"),
    schema_reference_4("schema_reference.4"),
    src_ct_1("src-ct.1"),
    src_import_1_2("src-import.1.2"),
    src_element_3("src-element.3"),
    src_resolve_4_2("src-resolve.4.2"),
    src_resolve("src-resolve"),
    src_element_2_1("src-element.2.1"),
    EmptyTargetNamespace("EmptyTargetNamespace"),
    src_import_3_1("src-import.3.1"),
    src_import_3_2("src-import.3.2");

    private final String code;
    private static final Map<String, XSDErrorCode> codes;

    private XSDErrorCode() {
        this(null);
    }

    private XSDErrorCode(String code) {
        this.code = code;
    }

    @Override
    public String getCode() {
        if (this.code == null) {
            return this.name();
        }
        return this.code;
    }

    public static XSDErrorCode get(String name) {
        return codes.get(name);
    }

    public static Range toLSPRange(XMLLocator location, XSDErrorCode code, Object[] arguments, DOMDocument document) {
        int offset = location.getCharacterOffset() - 1;
        switch (code) {
            case cos_all_limited_2: {
                String nameValue = StringUtils.getString(arguments[1]);
                DOMNode parent = document.findNodeAt(offset);
                List<DOMNode> children = parent.getChildrenWithAttributeValue("name", nameValue);
                if (children.isEmpty()) {
                    return XMLPositionUtility.selectStartTagName(offset, document);
                }
                offset = children.get(0).getStart() + 1;
                return XMLPositionUtility.selectAttributeValueAt("maxOccurs", offset, document);
            }
            case ct_props_correct_3: {
                String attrValue = StringUtils.getString(arguments[0]);
                if (attrValue.charAt(0) == ':') {
                    attrValue = attrValue.substring(1);
                }
                return XMLPositionUtility.selectAttributeValueFromGivenValue(attrValue, offset, document);
            }
            case p_props_correct_2_1: {
                return XMLPositionUtility.selectAttributeFromGivenNameAt("minOccurs", offset, document);
            }
            case s4s_elt_invalid_content_1: 
            case s4s_elt_must_match_1: 
            case s4s_elt_must_match_2: 
            case s4s_att_must_appear: 
            case s4s_elt_invalid_content_2: 
            case s4s_elt_invalid_content_3: 
            case src_element_2_1: 
            case src_element_3: 
            case src_import_1_2: {
                return XMLPositionUtility.selectStartTagName(offset, document);
            }
            case s4s_att_not_allowed: {
                String attrName = StringUtils.getString(arguments[1]);
                return XMLPositionUtility.selectAttributeNameFromGivenNameAt(attrName, offset, document);
            }
            case s4s_att_invalid_value: {
                String attrName = StringUtils.getString(arguments[1]);
                return XMLPositionUtility.selectAttributeValueAt(attrName, offset, document);
            }
            case s4s_elt_character: {
                return XMLPositionUtility.selectContent(offset, document);
            }
            case sch_props_correct_2: {
                String argument = StringUtils.getString(arguments[0]);
                String attrName = argument.substring(argument.indexOf(",") + 1);
                return XMLPositionUtility.selectAttributeValueFromGivenValue(attrName, offset, document);
            }
            case src_ct_1: {
                return XMLPositionUtility.selectAttributeValueAt("base", offset, document);
            }
            case src_resolve_4_2: {
                String attrValue = StringUtils.getString(arguments[2]);
                return XMLPositionUtility.selectAttributeValueByGivenValueAt(attrValue, offset, document);
            }
            case src_resolve: {
                String attrValue = StringUtils.getString(arguments[0]);
                return XMLPositionUtility.selectAttributeValueByGivenValueAt(attrValue, offset, document);
            }
            case schema_reference_4: {
                return XMLPositionUtility.selectAttributeValueAt("schemaLocation", offset, true, document);
            }
            case EmptyTargetNamespace: {
                return XMLPositionUtility.selectAttributeValueAt("targetNamespace", offset, document);
            }
            case src_import_3_1: {
                DOMNode elementHighlighted = document.findNodeAt(offset);
                if (elementHighlighted.getNodeName().equals("xs:schema")) {
                    return XMLPositionUtility.selectChildNodeAttributeValueFromGivenNameAt("xs:import", "namespace", offset, document);
                }
                return XMLPositionUtility.selectAttributeValueAt("namespace", offset, document);
            }
            case src_import_3_2: {
                return XMLPositionUtility.selectChildNodeAttributeValueFromGivenNameAt("xs:import", "schemaLocation", offset, document);
            }
        }
        return null;
    }

    public static void registerCodeActionParticipants(Map<String, ICodeActionParticipant> codeActions) {
        codeActions.put(s4s_elt_invalid_content_3.getCode(), new s4s_elt_invalid_content_3CodeAction());
        codeActions.put(src_import_1_2.getCode(), new src_import_1_2CodeAction());
    }

    static {
        codes = new HashMap<String, XSDErrorCode>();
        for (XSDErrorCode errorCode : XSDErrorCode.values()) {
            codes.put(errorCode.getCode(), errorCode);
        }
    }
}

