/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsd;

import java.nio.file.Paths;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lsp4j.LocationLink;
import org.junit.jupiter.api.Test;

public class XSDDefinitionExtensionsTest {
    @Test
    public void noXSDefinition() throws BadLocationException {
        String xml = "<?xml version='1.0'?>\r\n<xs:sche|ma xmlns:xs='http://www.w3.org/2001/XMLSchema'>\r\n</xs:schema>";
        XSDDefinitionExtensionsTest.testDefinitionFor(xml, XMLAssert.ll("test.xsd", XMLAssert.r(1, 1, 1, 10), XMLAssert.r(2, 2, 2, 11)));
    }

    @Test
    public void definitionOnElementType() throws BadLocationException {
        String xml = "<?xml version=\"1.1\" ?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" elementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\">\r\n\t\r\n\t<xs:element name=\"employee\" type=\"|fullpersoninfo\" />\r\n\t\r\n\t<xs:complexType name=\"fullpersoninfo\">\t\r\n\t</xs:complexType>\r\n\t\r\n</xs:schema>";
        XSDDefinitionExtensionsTest.testDefinitionFor(xml, XMLAssert.ll("test.xsd", XMLAssert.r(3, 34, 3, 50), XMLAssert.r(5, 22, 5, 38)));
    }

    @Test
    public void definitionOnExtensionBase() throws BadLocationException {
        String xml = "<?xml version=\"1.1\" ?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" elementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\">\r\n\t\r\n\t<xs:complexType name=\"personinfo\">\r\n\t\t\r\n\t</xs:complexType>\r\n\t\r\n\t<xs:complexType name=\"fullpersoninfo\">\r\n\t\t<xs:complexContent>\r\n\t\t\t<xs:extension base=\"|personinfo\">\r\n\t\t\r\n\t\t\t</xs:extension>\r\n\t\t</xs:complexContent>\r\n\t</xs:complexType>\r\n\t\r\n</xs:schema>";
        XSDDefinitionExtensionsTest.testDefinitionFor(xml, XMLAssert.ll("test.xsd", XMLAssert.r(9, 22, 9, 34), XMLAssert.r(3, 22, 3, 34)));
    }

    @Test
    public void definitionWithTargetNamespace() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:tns=\"http://camel.apache.org/schema/spring\" elementFormDefault=\"qualified\" targetNamespace=\"http://camel.apache.org/schema/spring\" version=\"1.0\">\r\n\t\r\n\t<xs:element name=\"aggregate\" type=\"|tns:aggregateDefinition\">\r\n\t</xs:element>\r\n\t\r\n\t<xs:complexType name=\"aggregateDefinition\">\r\n\t</xs:complexType>\r\n\t\r\n</xs:schema>";
        XSDDefinitionExtensionsTest.testDefinitionFor(xml, XMLAssert.ll("test.xsd", XMLAssert.r(3, 35, 3, 60), XMLAssert.r(6, 22, 6, 43)));
    }

    @Test
    public void definitionOnElementRef() throws BadLocationException {
        String xml = "<?xml version=\"1.1\" ?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" targetNamespace=\"http://www.w3.org/2001/XMLSchema\" version=\"1.0\">\r\n\t\r\n\t<xs:group name=\"schemaTop\">\r\n\t\t<xs:choice>\r\n\t\t\t<xs:group ref=\"xs:redefinable\" />\r\n\t\t\t<xs:element ref=\"xs:element\" />\r\n\t\t\t<xs:element ref=\"xs:attribute\" />\r\n\t\t\t<xs:element ref=\"|xs:notation\" />\r\n\t\t</xs:choice>\r\n\t</xs:group>\r\n\t\r\n\t<xs:group name=\"redefinable\">\r\n\t\t<xs:choice></xs:choice>\r\n\t</xs:group>\r\n\t\r\n\t<xs:element name=\"element\" />\r\n\t<xs:element name=\"attribute\" />\r\n\t<xs:element name=\"notation\" />\r\n</xs:schema>";
        XSDDefinitionExtensionsTest.testDefinitionFor(xml, XMLAssert.ll("test.xsd", XMLAssert.r(8, 19, 8, 32), XMLAssert.r(18, 18, 18, 28)));
    }

    @Test
    public void definitionOnGroupRef() throws BadLocationException {
        String xml = "<?xml version=\"1.1\" ?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" targetNamespace=\"http://www.w3.org/2001/XMLSchema\" version=\"1.0\">\r\n\t\r\n\t<xs:group name=\"schemaTop\">\r\n\t\t<xs:choice>\r\n\t\t\t<xs:group ref=\"|xs:redefinable\" />\r\n\t\t\t<xs:element ref=\"xs:element\" />\r\n\t\t\t<xs:element ref=\"xs:attribute\" />\r\n\t\t\t<xs:element ref=\"xs:notation\" />\r\n\t\t</xs:choice>\r\n\t</xs:group>\r\n\t\r\n\t<xs:group name=\"redefinable\">\r\n\t\t<xs:choice></xs:choice>\r\n\t</xs:group>\r\n\t\r\n\t<xs:element name=\"element\" />\r\n\t<xs:element name=\"attribute\" />\r\n\t<xs:element name=\"notation\" />\r\n</xs:schema>";
        XSDDefinitionExtensionsTest.testDefinitionFor(xml, XMLAssert.ll("test.xsd", XMLAssert.r(5, 17, 5, 33), XMLAssert.r(12, 16, 12, 29)));
    }

    @Test
    public void definitionWithXSInclude() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<xs:schema id=\"tns\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" elementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\">\r\n\t<xs:include schemaLocation=\"src/test/resources/xsd/SchemaB.xsd\" />\r\n  \r\n\t<xs:complexType name=\"Bar\">\r\n\t\t<xs:sequence>\r\n\t\t\t<xs:element ref=\"TypeFr|omB\" />\r\n\t\t</xs:sequence>\r\n\t</xs:complexType>";
        String schemaBPath = Paths.get("src/test/resources/xsd/SchemaB.xsd", new String[0]).toUri().toString();
        XSDDefinitionExtensionsTest.testDefinitionFor(xml, XMLAssert.ll(schemaBPath, XMLAssert.r(6, 19, 6, 30), XMLAssert.r(4, 18, 4, 29)));
        xml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<xs:schema id=\"tns\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" elementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\">\r\n\t<xs:include schemaLocation=\"src/test/resources/xsd/SchemaB.xsd\" />\r\n  \r\n\t<xs:complexType name=\"Bar\">\r\n\t\t<xs:sequence>\r\n\t\t\t<xs:element ref=\"TypeFr|omC\" />\r\n\t\t</xs:sequence>\r\n\t</xs:complexType>";
        String schemaCPath = Paths.get("src/test/resources/xsd/SchemaC.xsd", new String[0]).toUri().toString();
        XSDDefinitionExtensionsTest.testDefinitionFor(xml, XMLAssert.ll(schemaCPath, XMLAssert.r(6, 19, 6, 30), XMLAssert.r(3, 18, 3, 29)));
    }

    @Test
    public void definitionWithXSImport() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<xs:schema targetNamespace=\"SomeNamespace\"\r\n           xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\r\n           xmlns:ct=\"ChildTypes\"\r\n           xmlns=\"SomeNamespace\"\r\n           elementFormDefault=\"unqualified\">\r\n  <xs:import schemaLocation=\"src/test/resources/xsd/Child.xsd\" namespace=\"ChildTypes\"/>\r\n \r\n  <xs:complexType name=\"SpecialType\">\r\n    <xs:complexContent>\r\n      <xs:extension base=\"ct:Som|eGenericType\">\r\n        <xs:sequence>\r\n          <xs:element name=\"AdditionalField\" type=\"xs:string\" />\r\n        </xs:sequence>\r\n      </xs:extension>\r\n    </xs:complexContent>\r\n  </xs:complexType>\r\n</xs:schema>";
        String childPath = Paths.get("src/test/resources/xsd/Child.xsd", new String[0]).toUri().toString();
        XSDDefinitionExtensionsTest.testDefinitionFor(xml, XMLAssert.ll(childPath, XMLAssert.r(10, 25, 10, 45), XMLAssert.r(5, 23, 5, 40)));
    }

    private static void testDefinitionFor(String xml, LocationLink ... expectedItems) throws BadLocationException {
        XMLAssert.testDefinitionFor(xml, "test.xsd", expectedItems);
    }
}

