/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.utils;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.lemminx.utils.IOUtils;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lemminx.utils.platform.Platform;

public class FilesUtils {
    public static final String FILE_SCHEME = "file://";
    public static final String LEMMINX_WORKDIR_KEY = "lemminx.workdir";
    private static String cachePathSetting = null;
    private static Pattern uriSchemePattern = Pattern.compile("^([a-zA-Z\\-]+:\\/\\/).*");
    private static Pattern endFilePattern = Pattern.compile(".*[\\\\\\/]\\.[\\S]+");
    public static Supplier<Path> DEPLOYED_BASE_PATH;

    public static String getCachePathSetting() {
        return cachePathSetting;
    }

    public static void setCachePathSetting(String cachePathSetting) {
        FilesUtils.cachePathSetting = StringUtils.isEmpty(cachePathSetting) ? null : cachePathSetting;
        FilesUtils.resetDeployPath();
    }

    private FilesUtils() {
    }

    public static void resetDeployPath() {
        DEPLOYED_BASE_PATH = Suppliers.memoize(() -> FilesUtils.getDeployedBasePath());
    }

    public static String normalizePath(String pathString) {
        if (pathString != null && !pathString.isEmpty()) {
            if (pathString.indexOf("~") == 0) {
                pathString = System.getProperty("user.home") + (pathString.length() > 1 ? pathString.substring(1) : "");
            }
            pathString = pathString.replace("/", File.separator);
            pathString = pathString.replace("\\", File.separator);
            Path p = Paths.get(pathString, new String[0]);
            pathString = p.normalize().toString();
            return pathString;
        }
        return null;
    }

    private static Path getDeployedBasePath() {
        String dir = System.getProperty(LEMMINX_WORKDIR_KEY);
        if (dir != null) {
            return Paths.get(dir, new String[0]);
        }
        if (cachePathSetting != null && !cachePathSetting.isEmpty()) {
            return Paths.get(cachePathSetting, new String[0]);
        }
        dir = System.getProperty("user.home");
        if (dir == null) {
            dir = System.getProperty("user.dir");
        }
        if (dir == null) {
            dir = "";
        }
        return FilesUtils.getPath(dir).resolve(".lemminx");
    }

    public static Path getDeployedPath(Path path) throws IOException {
        return ((Path)DEPLOYED_BASE_PATH.get()).resolve(path);
    }

    public static void saveToFile(InputStream in, Path outFile) throws IOException {
        FilesUtils.saveToFile(IOUtils.convertStreamToString(in), outFile);
    }

    public static void saveToFile(String content, Path outFile) throws IOException {
        if (!Files.exists(outFile.getParent(), new LinkOption[0])) {
            Files.createDirectories(outFile.getParent(), new FileAttribute[0]);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(outFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(content);
        }
        outFile.toFile().setExecutable(false);
    }

    public static int getOffsetAfterScheme(String uri) {
        Matcher m = uriSchemePattern.matcher(uri);
        if (m.matches()) {
            return m.group(1).length();
        }
        return -1;
    }

    public static String getFilePathSlash(String text) {
        if (text.contains("\\")) {
            return "\\";
        }
        return "/";
    }

    public static String convertToWindowsPath(String pathString) {
        String pathSlash = FilesUtils.getFilePathSlash(pathString);
        if (pathString.startsWith(pathSlash) && pathString.length() > 3) {
            char letter = pathString.charAt(1);
            char colon = pathString.charAt(2);
            if (Character.isLetter(letter) && ':' == colon) {
                pathString = pathString.substring(1);
            }
        }
        return pathString.replace("/", "\\");
    }

    public static boolean pathEndsWithFile(String pathString) {
        Matcher m = endFilePattern.matcher(pathString);
        return m.matches();
    }

    public static boolean isIncludedInDeployedPath(Path resourceCachePath) {
        return resourceCachePath.normalize().startsWith((Path)DEPLOYED_BASE_PATH.get());
    }

    public static String removeFileScheme(String fileURI) {
        return FilesUtils.removeFileScheme(fileURI, false);
    }

    private static String removeFileScheme(String fileURI, boolean removeLastSlash) {
        int index = fileURI.indexOf(FILE_SCHEME);
        if (index != -1) {
            index = index + FILE_SCHEME.length() - 1;
            if (removeLastSlash && index + 1 < fileURI.length() && fileURI.charAt(index + 1) == '/') {
                ++index;
            }
            fileURI = fileURI.substring(index + 1, fileURI.length());
        }
        return fileURI;
    }

    public static File toFile(String fileUri) {
        String convertedUri = fileUri.replace("file:///", "file:/");
        convertedUri = convertedUri.replace(FILE_SCHEME, "file:/");
        return new File(URI.create(convertedUri));
    }

    public static Path getPath(String uri) {
        uri = FilesUtils.removeFileScheme(uri, Platform.isWindows);
        try {
            uri = URLDecoder.decode(uri, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return Paths.get(uri, new String[0]);
    }

    public static String encodePath(String path) {
        return path.replace(" ", "%20");
    }

    public static String readString(Path path) throws IOException {
        return Files.readAllLines(path).stream().collect(Collectors.joining(System.lineSeparator()));
    }

    static {
        FilesUtils.resetDeployPath();
    }
}

