/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.codeactions;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.lemminx.commons.CodeActionFactory;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.services.extensions.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.IComponentProvider;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;

public class TargetNamespace_1CodeAction
implements ICodeActionParticipant {
    private static final Pattern NAMESPACE_EXTRACTOR = Pattern.compile("'([^']+)'\\.");

    @Override
    public void doCodeAction(Diagnostic diagnostic, Range range, DOMDocument document, List<CodeAction> codeActions, SharedSettings sharedSettings, IComponentProvider componentProvider) {
        String namespace = TargetNamespace_1CodeAction.extractNamespace(diagnostic.getMessage());
        if (StringUtils.isEmpty(namespace)) {
            return;
        }
        String quote = sharedSettings.getPreferences().getQuotationAsString();
        CodeAction replaceNamespace = CodeActionFactory.replace("Replace with '" + namespace + "'", diagnostic.getRange(), quote + namespace + quote, document.getTextDocument(), diagnostic);
        codeActions.add(replaceNamespace);
    }

    private static String extractNamespace(String diagnosticMessage) {
        Matcher nsMatcher = NAMESPACE_EXTRACTOR.matcher(diagnosticMessage);
        if (nsMatcher.find()) {
            return nsMatcher.group(1);
        }
        return null;
    }
}

