/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsd;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.xsd.participants.XSDErrorCode;
import org.eclipse.lemminx.services.extensions.diagnostics.IXMLErrorCode;
import org.eclipse.lsp4j.Diagnostic;
import org.junit.jupiter.api.Test;

public class XSDValidationExtensionsTest {
    @Test
    public void cos_all_limited_2() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<xs:schema \r\n\txmlns:xs=\"http://www.w3.org/2001/XMLSchema\">\r\n\t\r\n\t<xs:complexType name=\"testType\">\r\n\t\t<xs:all>\r\n\t\t\t<xs:element name=\"testEle1\" minOccurs=\"2\" maxOccurs=\"unbounded\" type=\"xs:string\"/>\r\n\t\t</xs:all>\r\n\t</xs:complexType>\r\n</xs:schema>";
        XSDValidationExtensionsTest.testDiagnosticsFor(xml, XMLAssert.d(6, 55, 6, 66, (IXMLErrorCode)XSDErrorCode.cos_all_limited_2));
    }

    @Test
    public void cos_all_limited_2_multiple() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<xs:schema \r\n\txmlns:xs=\"http://www.w3.org/2001/XMLSchema\">\r\n\t\r\n\t<xs:complexType name=\"testType\">\r\n\t\t<xs:all>\r\n\t\t\t<xs:element name=\"testEle1\" minOccurs=\"2\" maxOccurs=\"unbounded\" type=\"xs:string\"/>\r\n\t\t\t<xs:element name=\"testEle2\" minOccurs=\"2\" maxOccurs=\"unbounded\" type=\"xs:string\"/>\r\n\t\t\t<xs:element name=\"test3\" minOccurs=\"2\" maxOccurs=\"unbounded\" type=\"xs:string\"/>\r\n\t\t</xs:all>\r\n\t</xs:complexType>\r\n</xs:schema>";
        Diagnostic first = XMLAssert.d(6, 55, 6, 66, (IXMLErrorCode)XSDErrorCode.cos_all_limited_2);
        Diagnostic second = XMLAssert.d(7, 55, 7, 66, (IXMLErrorCode)XSDErrorCode.cos_all_limited_2);
        Diagnostic third = XMLAssert.d(8, 52, 8, 63, (IXMLErrorCode)XSDErrorCode.cos_all_limited_2);
        XSDValidationExtensionsTest.testDiagnosticsFor(xml, first, second, third);
    }

    @Test
    public void ct_props_correct_3_1() throws BadLocationException {
        String xml = "<?xml version=\"1.1\" ?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" elementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\">\r\n\t<xs:complexType name=\"fullpersoninfo\">\r\n\t\t<xs:complexContent>\r\n\t\t\t<xs:extension base=\"fullpersoninfo\">\r\n\t\t\t</xs:extension>\r\n\t\t</xs:complexContent>\r\n\t</xs:complexType>\r\n</xs:schema>";
        XSDValidationExtensionsTest.testDiagnosticsFor(xml, XMLAssert.d(4, 22, 4, 38, (IXMLErrorCode)XSDErrorCode.ct_props_correct_3));
    }

    @Test
    public void ct_props_correct_3_2() throws BadLocationException {
        String xml = "<?xml version=\"1.1\" ?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" targetNamespace=\"http://www.w3.org/2001/XMLSchema\">\r\n\t<xs:complexType name=\"aComplexType\">\r\n\t\t<xs:complexContent>\r\n\t\t\t<xs:extension base=\"xs:aComplexType\"></xs:extension>\r\n\t\t</xs:complexContent>\r\n\t</xs:complexType>\r\n</xs:schema>";
        XSDValidationExtensionsTest.testDiagnosticsFor(xml, XMLAssert.d(4, 22, 4, 39, (IXMLErrorCode)XSDErrorCode.ct_props_correct_3));
    }

    @Test
    public void emptyTargetNamespace() throws BadLocationException {
        String xml = "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\r\n\telementFormDefault=\"qualified\" xml:lang=\"EN\"\r\n\ttargetNamespace=\"\"\r\n\tversion=\"1.0\">\r\n</xs:schema>";
        XSDValidationExtensionsTest.testDiagnosticsFor(xml, XMLAssert.d(2, 17, 2, 19, (IXMLErrorCode)XSDErrorCode.EmptyTargetNamespace));
    }

    @Test
    public void p_props_correct_2_1() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">\r\n\t<xs:complexType name=\"testType\">\r\n\t\t<xs:all>\r\n\t\t\t<xs:element name=\"testEle\" minOccurs=\"1\" maxOccurs=\"0\" type=\"xs:string\"/>\r\n\t\t</xs:all>\r\n\t</xs:complexType>\r\n</xs:schema>";
        XSDValidationExtensionsTest.testDiagnosticsFor(xml, XMLAssert.d(4, 30, 4, 43, (IXMLErrorCode)XSDErrorCode.p_props_correct_2_1));
    }

    @Test
    public void p_props_correct_2_1_multiple() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">\r\n\t<xs:complexType name=\"testType\">\r\n\t\t<xs:all>\r\n\t\t\t<xs:element name=\"testEle\" minOccurs=\"1\" maxOccurs=\"0\" type=\"xs:string\"/>\r\n\t\t\t<xs:element name=\"test\" minOccurs=\"5\" maxOccurs=\"0\" type=\"xs:string\"/>\r\n\t\t</xs:all>\r\n\t</xs:complexType>\r\n</xs:schema>";
        Diagnostic first = XMLAssert.d(4, 30, 4, 43, (IXMLErrorCode)XSDErrorCode.p_props_correct_2_1);
        Diagnostic second = XMLAssert.d(5, 27, 5, 40, (IXMLErrorCode)XSDErrorCode.p_props_correct_2_1);
        XSDValidationExtensionsTest.testDiagnosticsFor(xml, first, second);
    }

    @Test
    public void s4s_elt_invalid_content_1() throws BadLocationException {
        String xml = "<?xml version=\"1.1\"?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\r\n\telementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\">\r\n\t<foo></foo>\r\n</xs:schema>";
        XSDValidationExtensionsTest.testDiagnosticsFor(xml, XMLAssert.d(3, 2, 3, 5, (IXMLErrorCode)XSDErrorCode.s4s_elt_invalid_content_1));
    }

    @Test
    public void s4s_elt_character() throws BadLocationException {
        String xml = "<?xml version=\"1.1\"?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\r\n\telementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\">\r\n\t<xs:element name=\"foo\">bar</xs:element>\r\n</xs:schema>";
        XSDValidationExtensionsTest.testDiagnosticsFor(xml, XMLAssert.d(3, 24, 3, 27, (IXMLErrorCode)XSDErrorCode.s4s_elt_character));
    }

    @Test
    public void s4s_elt_must_match_2() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" version=\"1.0\">\r\n\t<xs:simpleType name=\"X\"></xs:simpleType>\r\n</xs:schema>";
        XSDValidationExtensionsTest.testDiagnosticsFor(xml, XMLAssert.d(2, 2, 2, 15, (IXMLErrorCode)XSDErrorCode.s4s_elt_must_match_2));
    }

    @Test
    public void s4s_att_must_appear() throws BadLocationException {
        String xml = "<?xml version=\"1.1\"?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\r\n\telementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\">\r\n\t<xs:element></xs:element>\r\n</xs:schema>";
        XSDValidationExtensionsTest.testDiagnosticsFor(xml, XMLAssert.d(3, 2, 3, 12, (IXMLErrorCode)XSDErrorCode.s4s_att_must_appear));
    }

    @Test
    public void s4s_att_not_allowed() throws BadLocationException {
        String xml = "<?xml version=\"1.1\"?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\r\n\telementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\">\r\n\t<xs:element foo=\"bar\" ></xs:element>\r\n</xs:schema>";
        XSDValidationExtensionsTest.testDiagnosticsFor(xml, XMLAssert.d(3, 13, 3, 16, (IXMLErrorCode)XSDErrorCode.s4s_att_not_allowed), XMLAssert.d(3, 2, 3, 12, (IXMLErrorCode)XSDErrorCode.s4s_att_must_appear));
    }

    @Test
    public void s4s_att_invalid_value() throws BadLocationException {
        String xml = "<?xml version=\"1.1\"?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\r\n\telementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\">\r\n\t<xs:element name=\"\" ></xs:element>\r\n</xs:schema>";
        XSDValidationExtensionsTest.testDiagnosticsFor(xml, XMLAssert.d(3, 18, 3, 20, (IXMLErrorCode)XSDErrorCode.s4s_att_invalid_value), XMLAssert.d(3, 2, 3, 12, (IXMLErrorCode)XSDErrorCode.s4s_att_must_appear));
    }

    @Test
    public void s4s_elt_invalid_content_3WithClosingTag() throws BadLocationException {
        String xml = "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" elementFormDefault=\"qualified\">\r\n\t<xs:element name=\"project\" type=\"xs:string\"></xs:element>\r\n\t<xs:import></xs:import>\r\n</xs:schema>";
        Diagnostic d = XMLAssert.d(2, 2, 2, 11, (IXMLErrorCode)XSDErrorCode.s4s_elt_invalid_content_3);
        XSDValidationExtensionsTest.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(2, 1, 2, 24, "")));
    }

    @Test
    public void s4s_elt_invalid_content_3WithSelfClosingTag() throws BadLocationException {
        String xml = "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" elementFormDefault=\"qualified\">\r\n\t<xs:element name=\"project\" type=\"xs:string\"></xs:element>\r\n\t<xs:import/>\r\n</xs:schema>";
        Diagnostic d = XMLAssert.d(2, 2, 2, 11, (IXMLErrorCode)XSDErrorCode.s4s_elt_invalid_content_3);
        XSDValidationExtensionsTest.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(2, 1, 2, 13, "")));
    }

    @Test
    public void sch_props_correct_2() throws BadLocationException {
        String xml = "<?xml version=\"1.1\" ?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">\r\n\t<xs:element name=\"elt1\" />\r\n\t<xs:element name=\"elt1\" />\r\n</xs:schema>";
        XSDValidationExtensionsTest.testDiagnosticsFor(xml, XMLAssert.d(3, 18, 3, 24, (IXMLErrorCode)XSDErrorCode.sch_props_correct_2));
    }

    @Test
    public void src_ct_1() throws BadLocationException {
        String xml = "<?xml version=\"1.1\" ?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" elementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\">\r\n\t<xs:complexType name=\"fullpersoninfo\">\r\n\t\t<xs:complexContent>\r\n\t\t\t<xs:extension base=\"xs:string\">\r\n\t\t\t</xs:extension>\r\n\t\t</xs:complexContent>\r\n\t</xs:complexType>\r\n</xs:schema>";
        XSDValidationExtensionsTest.testDiagnosticsFor(xml, XMLAssert.d(4, 22, 4, 33, (IXMLErrorCode)XSDErrorCode.src_ct_1));
    }

    @Test
    public void src_resolve() throws BadLocationException {
        String xml = "<?xml version=\"1.1\"?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\r\n\telementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\">\r\n\t<xs:element name=\"A\">\r\n\t\t<xs:complexType>\r\n\t\t\t<xs:sequence>\r\n\t\t\t\t<xs:element name=\"A.1\" type=\"xs:string\" />\r\n\t\t\t\t<xs:element name=\"A.2\" type=\"XXXXX\" /> \r\n\t\t\t</xs:sequence>\r\n\t\t</xs:complexType>\r\n\t</xs:element> \r\n</xs:schema>";
        XSDValidationExtensionsTest.testDiagnosticsFor(xml, XMLAssert.d(7, 32, 7, 39, (IXMLErrorCode)XSDErrorCode.src_resolve));
    }

    @Test
    public void src_resolve2() throws BadLocationException {
        String xml = "<?xml version=\"1.1\" ?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\r\n\telementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\">\r\n\r\n\t<xs:simpleType name=\"carType\">\r\n\t\t<xs:restriction base=\"xs:string\">\r\n\t\t\t<xs:enumeration value=\"Audi\" />\r\n\t\t\t<xs:enumeration value=\"Golf\" />\r\n\t\t\t<xs:enumeration value=\"BMW\" />\r\n\t\t</xs:restriction>\r\n\t</xs:simpleType>\r\n\r\n\t<xs:element name=\"car\" type=\"carType\" />\r\n\t<xs:element name=\"foo\" type=\"fooType\" />\r\n\r\n</xs:schema>";
        XSDValidationExtensionsTest.testDiagnosticsFor(xml, XMLAssert.d(13, 29, 13, 38, (IXMLErrorCode)XSDErrorCode.src_resolve));
    }

    @Test
    public void src_element_2_1() throws BadLocationException {
        String xml = "<?xml version='1.0'?>\r\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\r\n    <xs:element name='note'>\r\n        <xs:complexType>\r\n            <xs:sequence>\r\n                <xs:element nhame='to' type='xs:string' nillable='false' />\r\n                <xs:element name='from' type='xs:string' />\r\n                <xs:element name='heading' type='xs:string' />\r\n                <xs:element name='body' type='xs:string' nillable='false' />\r\n            </xs:sequence>\r\n        </xs:complexType>\r\n    </xs:element>\r\n</xs:schema>";
        XSDValidationExtensionsTest.testDiagnosticsFor(xml, XMLAssert.d(5, 28, 5, 33, (IXMLErrorCode)XSDErrorCode.s4s_att_not_allowed), XMLAssert.d(5, 17, 5, 27, (IXMLErrorCode)XSDErrorCode.src_element_2_1));
    }

    @Test
    public void src_element_3() throws BadLocationException {
        String xml = "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">\r\n  <xs:element name=\"a\" type=\"xs:integer\">\r\n    <xs:complexType>\r\n      <xs:sequence>\r\n        <xs:element name=\"b\"></xs:element>\r\n      </xs:sequence>\r\n    </xs:complexType>\r\n  </xs:element>\r\n</xs:schema>";
        XSDValidationExtensionsTest.testDiagnosticsFor(xml, XMLAssert.d(1, 3, 1, 13, (IXMLErrorCode)XSDErrorCode.src_element_3));
    }

    @Test
    public void src_import_1_2xs() throws BadLocationException {
        String xml = "<?xml version='1.0'?>\r\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\r\n\t<xs:import></xs:import>\r\n</xs:schema>";
        Diagnostic d = XMLAssert.d(2, 2, 2, 11, (IXMLErrorCode)XSDErrorCode.src_import_1_2);
        XSDValidationExtensionsTest.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(2, 11, 2, 11, " namespace=\"\"")), XMLAssert.ca(d, XMLAssert.te(1, 54, 1, 54, " targetNamespace=\"\"")));
    }

    @Test
    public void src_import_1_2() throws BadLocationException {
        String xml = "<?xml version='1.0'?>\r\n<schema xmlns='http://www.w3.org/2001/XMLSchema'>\r\n\t<import></import>\r\n</schema>";
        Diagnostic d = XMLAssert.d(2, 2, 2, 8, (IXMLErrorCode)XSDErrorCode.src_import_1_2);
        XSDValidationExtensionsTest.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(2, 8, 2, 8, " namespace=\"\"")), XMLAssert.ca(d, XMLAssert.te(1, 48, 1, 48, " targetNamespace=\"\"")));
    }

    @Test
    public void src_import_1_2_different_range() throws BadLocationException {
        String xml = "<?xml version='1.0'?>\r\n<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\r\n\t<xs:imp|ort></xs:import>\r\n</xs:schema>";
        Diagnostic d = XMLAssert.d(2, 2, 2, 11, (IXMLErrorCode)XSDErrorCode.src_import_1_2);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(2, 11, 2, 11, " namespace=\"\"")), XMLAssert.ca(d, XMLAssert.te(1, 54, 1, 54, " targetNamespace=\"\"")));
    }

    @Test
    public void schema_reference_4_BadSchemaLocation() throws BadLocationException {
        String xsd = "<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\r\n<xs:import namespace='http://foo' schemaLocation='bad.xsd' />\r\n<xs:element name='foo'></xs:element>\r\n</xs:schema>";
        Diagnostic d = XMLAssert.d(1, 49, 1, 58, (IXMLErrorCode)XSDErrorCode.schema_reference_4);
        XSDValidationExtensionsTest.testDiagnosticsFor(xsd, d);
    }

    @Test
    public void schema_reference_4_GoodSchemaLocation() throws BadLocationException {
        String xsd = "<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\r\n<xs:import namespace='team_namespace' schemaLocation='src/test/resources/xsd/team.xsd' />\r\n<xs:element name='foo'></xs:element>\r\n</xs:schema>";
        XSDValidationExtensionsTest.testDiagnosticsFor(xsd, new Diagnostic[0]);
    }

    @Test
    public void schema_reference_4_IncludeErrorRange() throws BadLocationException {
        String xsd = "<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\r\n<xs:include schemaLocation='bad.xsd' />\r\n<xs:element name='foo'></xs:element>\r\n</xs:schema>";
        Diagnostic d = XMLAssert.d(1, 27, 1, 36, (IXMLErrorCode)XSDErrorCode.schema_reference_4);
        XSDValidationExtensionsTest.testDiagnosticsFor(xsd, d);
    }

    @Test
    public void src_import_3_1_BadNamespaceWithEmptySchema() throws BadLocationException {
        String xsd = "<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n<xs:import namespace='BAD_NAMESPACE' schemaLocation='src/test/resources/xsd/empty.xsd'/>\n<xs:element name='foo'></xs:element>\n</xs:schema>";
        Diagnostic d = XMLAssert.d(1, 21, 1, 36, (IXMLErrorCode)XSDErrorCode.src_import_3_1);
        XSDValidationExtensionsTest.testDiagnosticsFor(xsd, d);
    }

    @Test
    public void src_import_3_1_BadNamespaceWithSchemaContent() throws BadLocationException {
        String xsd = "<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n<xs:import namespace='BAD_NAMESPACE' schemaLocation='src/test/resources/xsd/baseSchema.xsd'/>\n<xs:element name='foo'></xs:element>\n</xs:schema>";
        Diagnostic d = XMLAssert.d(1, 21, 1, 36, (IXMLErrorCode)XSDErrorCode.src_import_3_1);
        XSDValidationExtensionsTest.testDiagnosticsFor(xsd, d);
    }

    @Test
    public void src_import_3_2_NoNamespaceFound() throws BadLocationException {
        String xsd = "<xs:schema\nxmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\ntargetNamespace=\"http://example.org/my-example\"\nxmlns:NS=\"http://example.org/my-example\">\n<xs:import schemaLocation=\"src/test/resources/xsd/baseSchema.xsd\"/>\n</xs:schema>";
        Diagnostic d = XMLAssert.d(4, 26, 4, 65, (IXMLErrorCode)XSDErrorCode.src_import_3_2);
        XSDValidationExtensionsTest.testDiagnosticsFor(xsd, d);
    }

    @Test
    public void schema_reference_4() throws BadLocationException {
        String xsd = "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">\r\n  <xs:import\r\n      namespace=\"abcd\"\r\n      schemaLocation=\"unkown1.xsd\" />\r\n  <xs:include schemaLocation=\"unkown2.xsd\" />\r\n</xs:schema>";
        Diagnostic d1 = XMLAssert.d(3, 21, 3, 34, (IXMLErrorCode)XSDErrorCode.schema_reference_4);
        Diagnostic d2 = XMLAssert.d(4, 29, 4, 42, (IXMLErrorCode)XSDErrorCode.schema_reference_4);
        XSDValidationExtensionsTest.testDiagnosticsFor(xsd, d1, d2);
    }

    @Test
    public void aggregateErrorFromReferencedSchema() throws BadLocationException {
        String xsd = "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" targetNamespace=\"http://java.sun.com/xml/ns/j2ee\">\r\n  <xs:import\r\n      schemaLocation=\"src/test/resources/xsd/foo-invalid-schema.xsd\" />\r\n  <xs:include schemaLocation=\"src/test/resources/xsd/srcElement3.xsd\" />\r\n</xs:schema>";
        Diagnostic d1 = XMLAssert.d(2, 21, 2, 68, null);
        Diagnostic d2 = XMLAssert.d(3, 29, 3, 69, null);
        XSDValidationExtensionsTest.testDiagnosticsFor(xsd, d1, d2);
    }

    private static void testDiagnosticsFor(String xml, Diagnostic ... expected) throws BadLocationException {
        XMLAssert.testDiagnosticsFor(xml, null, null, "test.xsd", expected);
    }
}

