/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants;

import java.util.Arrays;
import java.util.List;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.services.extensions.codelens.ICodeLensParticipant;
import org.eclipse.lemminx.services.extensions.codelens.ICodeLensRequest;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class ContentModelCodeLensParticipant
implements ICodeLensParticipant {
    @Override
    public void doCodeLens(ICodeLensRequest request, List<CodeLens> lenses, CancelChecker cancelChecker) {
        if (!ContentModelCodeLensParticipant.canSupport(request)) {
            return;
        }
        DOMDocument document = request.getDocument();
        DOMElement documentElement = document.getDocumentElement();
        if (documentElement == null || document.hasGrammar()) {
            return;
        }
        String documentURI = document.getDocumentURI();
        Range range = XMLPositionUtility.selectRootStartTag(document);
        lenses.add(ContentModelCodeLensParticipant.createAssociateLens(documentURI, "Bind to grammar/schema...", range));
    }

    private static boolean canSupport(ICodeLensRequest request) {
        if (!request.isSupportedByClient("association")) {
            return false;
        }
        String uri = request.getDocument().getDocumentURI();
        return !DOMUtils.isXSD(uri) && !DOMUtils.isDTD(uri);
    }

    private static CodeLens createAssociateLens(String documentURI, String title, Range range) {
        Command command = new Command(title, "xml.open.binding.wizard", Arrays.asList(documentURI));
        return new CodeLens(range, command, null);
    }
}

