/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.telemetry;

import org.eclipse.lemminx.telemetry.InitializationTelemetryInfo;
import org.eclipse.lemminx.telemetry.TelemetryEvent;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.services.LanguageClient;

public class TelemetryManager {
    private static final String STARTUP_EVENT_NAME = "server.initialized";
    private final LanguageClient languageClient;
    private boolean enabled;

    public TelemetryManager(LanguageClient languageClient) {
        this.languageClient = languageClient;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void onInitialized(InitializedParams params) {
        if (this.isEnabled()) {
            this.telemetryEvent(STARTUP_EVENT_NAME, InitializationTelemetryInfo.getInitializationTelemetryInfo());
        }
    }

    private void telemetryEvent(String eventName, Object object) {
        this.languageClient.telemetryEvent((Object)new TelemetryEvent(eventName, object));
    }
}

