/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.catalog;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.util.URI;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.catalog.CatalogEntry;
import org.eclipse.lemminx.extensions.catalog.CatalogUtils;
import org.eclipse.lemminx.services.extensions.IDocumentLinkParticipant;
import org.eclipse.lemminx.utils.FilesUtils;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.DocumentLink;

public class XMLCatalogDocumentLinkParticipant
implements IDocumentLinkParticipant {
    private static Logger LOGGER = Logger.getLogger(XMLCatalogDocumentLinkParticipant.class.getName());

    @Override
    public void findDocumentLinks(DOMDocument document, List<DocumentLink> links) {
        for (CatalogEntry catalogEntry : CatalogUtils.getCatalogEntries(document)) {
            DocumentLink docLink = XMLCatalogDocumentLinkParticipant.createDocumentLinkFromCatalogEntry(document, catalogEntry);
            if (docLink == null) continue;
            links.add(docLink);
        }
    }

    private static DocumentLink createDocumentLinkFromCatalogEntry(DOMDocument document, CatalogEntry catalogEntry) {
        try {
            String path = XMLCatalogDocumentLinkParticipant.getResolvedLocation(FilesUtils.removeFileScheme(document.getDocumentURI()), catalogEntry.getResolvedURI());
            if (path != null && catalogEntry.getLinkRange() != null) {
                return XMLPositionUtility.createDocumentLink(catalogEntry.getLinkRange(), path, true);
            }
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "Creation of document link failed", e);
        }
        return null;
    }

    private static String getResolvedLocation(String documentURI, String location) {
        if (StringUtils.isBlank(location)) {
            return null;
        }
        try {
            return XMLEntityManager.expandSystemId((String)location, (String)documentURI, (boolean)false);
        }
        catch (URI.MalformedURIException e) {
            return location;
        }
    }
}

