/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import java.util.Collections;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lsp4j.CodeLens;
import org.junit.jupiter.api.Test;

public class AssociateGrammarCodeLensExtensionsTest {
    @Test
    public void noGrammarWithAssociationSupportInXML() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<foo />";
        XMLAssert.testCodeLensFor(xml, "test.xml", Collections.singletonList("association"), XMLAssert.cl(XMLAssert.r(1, 1, 1, 4), "Bind to grammar/schema...", "xml.open.binding.wizard"));
    }

    @Test
    public void noGrammarWithAssociationSupportInXSD() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<schema />";
        XMLAssert.testCodeLensFor(xml, "test.xsd", Collections.singletonList("association"), new CodeLens[0]);
    }

    @Test
    public void noGrammarWithAssociationSupportInDTD() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<foo />";
        XMLAssert.testCodeLensFor(xml, "test.dtd", Collections.singletonList("association"), new CodeLens[0]);
    }

    @Test
    public void noGrammarWithoutAssociationSupport() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<foo />";
        XMLAssert.testCodeLensFor(xml, "test.xml", Collections.emptyList(), new CodeLens[0]);
    }

    @Test
    public void withGrammar() throws BadLocationException {
        String xml = "<?xml-model href='test.dtd' >\r\n<foo />";
        XMLAssert.testCodeLensFor(xml, "test.xml", new CodeLens[0]);
    }
}

