/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lemminx.XMLLanguageServer;
import org.eclipse.lemminx.XMLTextDocumentService;
import org.eclipse.lemminx.services.extensions.commands.IXMLCommandService;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.FileEvent;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.eclipse.lsp4j.services.WorkspaceService;

public class XMLWorkspaceService
implements WorkspaceService,
IXMLCommandService {
    private final XMLLanguageServer xmlLanguageServer;
    private final Map<String, IXMLCommandService.IDelegateCommandHandler> commands;

    public XMLWorkspaceService(XMLLanguageServer xmlLanguageServer) {
        this.xmlLanguageServer = xmlLanguageServer;
        this.commands = new HashMap<String, IXMLCommandService.IDelegateCommandHandler>();
    }

    public CompletableFuture<List<? extends SymbolInformation>> symbol(WorkspaceSymbolParams params) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params) {
        Map<String, IXMLCommandService.IDelegateCommandHandler> map = this.commands;
        synchronized (map) {
            IXMLCommandService.IDelegateCommandHandler handler = this.commands.get(params.getCommand());
            if (handler == null) {
                throw new ResponseErrorException(new ResponseError(ResponseErrorCode.InternalError, "No command handler for the command: " + params.getCommand(), null));
            }
            return CompletableFutures.computeAsync(cancelChecker -> {
                try {
                    return handler.executeCommand(params, (CancelChecker)cancelChecker);
                }
                catch (Exception e) {
                    if (e instanceof ResponseErrorException) {
                        throw (ResponseErrorException)e;
                    }
                    if (e instanceof CancellationException) {
                        throw (CancellationException)e;
                    }
                    throw new ResponseErrorException(new ResponseError(ResponseErrorCode.UnknownErrorCode, e.getMessage(), (Object)e));
                }
            });
        }
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        this.xmlLanguageServer.updateSettings(params.getSettings());
        this.xmlLanguageServer.getCapabilityManager().syncDynamicCapabilitiesWithPreferences();
    }

    public void didChangeWorkspaceFolders(DidChangeWorkspaceFoldersParams params) {
        this.xmlLanguageServer.getXMLLanguageService().getWorkspaceServiceParticipants().forEach(participant -> participant.didChangeWorkspaceFolders(params));
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        XMLTextDocumentService xmlTextDocumentService = (XMLTextDocumentService)this.xmlLanguageServer.getTextDocumentService();
        List changes = params.getChanges();
        for (FileEvent change : changes) {
            if (xmlTextDocumentService.documentIsOpen(change.getUri())) continue;
            xmlTextDocumentService.doSave(change.getUri());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerCommand(String commandId, IXMLCommandService.IDelegateCommandHandler handler) {
        Map<String, IXMLCommandService.IDelegateCommandHandler> map = this.commands;
        synchronized (map) {
            if (this.commands.containsKey(commandId)) {
                throw new IllegalArgumentException("Command with id '" + commandId + "' is already registered");
            }
            this.commands.put(commandId, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterCommand(String commandId) {
        Map<String, IXMLCommandService.IDelegateCommandHandler> map = this.commands;
        synchronized (map) {
            this.commands.remove(commandId);
        }
    }

    @Override
    public CompletableFuture<Object> executeClientCommand(ExecuteCommandParams command) {
        return this.xmlLanguageServer.getLanguageClient().executeClientCommand(command);
    }

    @Override
    public void endCommandsRegistration() {
        if (!this.commands.isEmpty()) {
            this.xmlLanguageServer.getCapabilityManager().registerExecuteCommand(new ArrayList<String>(this.commands.keySet()));
        }
    }
}

