/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.telemetry;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lemminx.XMLLanguageServer;
import org.eclipse.lemminx.customservice.XMLLanguageClientAPI;
import org.eclipse.lemminx.telemetry.TelemetryEvent;
import org.eclipse.lemminx.utils.platform.Platform;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TelemetryInitializationTest {
    @Test
    public void telemetryEnabled() {
        ArrayList<TelemetryEvent> actualTelementryEvents = new ArrayList<TelemetryEvent>();
        XMLLanguageServer languageServer = TelemetryInitializationTest.createServer(actualTelementryEvents);
        languageServer.getTelemetryManager().setEnabled(true);
        TelemetryInitializationTest.initializeServer((LanguageServer)languageServer);
        Assertions.assertEquals((int)1, (int)actualTelementryEvents.size());
        Assertions.assertTrue((boolean)(((TelemetryEvent)actualTelementryEvents.get((int)0)).properties instanceof Map));
        Map initTelemetry = (Map)((TelemetryEvent)actualTelementryEvents.get((int)0)).properties;
        Assertions.assertEquals((Object)Platform.getVersion().getVersionNumber(), initTelemetry.get("server_version"));
        Assertions.assertNotNull(initTelemetry.get("jvm_name"), (String)"Name of JVM is present");
        Assertions.assertNotNull(initTelemetry.get("jvm_memory_max"), (String)"Memory information is present");
        Assertions.assertFalse((boolean)((Boolean)initTelemetry.get("server_is_native")), (String)"Not running under native-image (tests are set up to only run with the Java server)");
    }

    @Test
    public void telemetryDisabled() {
        ArrayList<TelemetryEvent> actualTelementryEvents = new ArrayList<TelemetryEvent>();
        XMLLanguageServer languageServer = TelemetryInitializationTest.createServer(actualTelementryEvents);
        TelemetryInitializationTest.initializeServer((LanguageServer)languageServer);
        Assertions.assertEquals((int)0, (int)actualTelementryEvents.size());
    }

    private static void initializeServer(LanguageServer languageServer) {
        InitializeParams params = new InitializeParams();
        languageServer.initialize(params);
        InitializedParams initialized = new InitializedParams();
        languageServer.initialized(initialized);
    }

    private static XMLLanguageServer createServer(final List<TelemetryEvent> actualTelementryEvents) {
        XMLLanguageServer languageServer = new XMLLanguageServer();
        XMLLanguageClientAPI client = new XMLLanguageClientAPI(){

            public void telemetryEvent(Object object) {
                actualTelementryEvents.add((TelemetryEvent)object);
            }

            public CompletableFuture<MessageActionItem> showMessageRequest(ShowMessageRequestParams requestParams) {
                return null;
            }

            public void showMessage(MessageParams messageParams) {
            }

            public void publishDiagnostics(PublishDiagnosticsParams diagnostics) {
            }

            public void logMessage(MessageParams message) {
            }
        };
        languageServer.setClient((LanguageClient)client);
        return languageServer;
    }
}

