/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lemminx.XMLLanguageServer;
import org.eclipse.lemminx.XMLTextDocumentService;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.FileEvent;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.services.WorkspaceService;

public class XMLWorkspaceService
implements WorkspaceService {
    private final XMLLanguageServer xmlLanguageServer;

    public XMLWorkspaceService(XMLLanguageServer xmlLanguageServer) {
        this.xmlLanguageServer = xmlLanguageServer;
    }

    public CompletableFuture<List<? extends SymbolInformation>> symbol(WorkspaceSymbolParams params) {
        return null;
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        this.xmlLanguageServer.updateSettings(params.getSettings());
        this.xmlLanguageServer.capabilityManager.syncDynamicCapabilitiesWithPreferences();
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        XMLTextDocumentService xmlTextDocumentService = (XMLTextDocumentService)this.xmlLanguageServer.getTextDocumentService();
        List changes = params.getChanges();
        for (FileEvent change : changes) {
            if (xmlTextDocumentService.documentIsOpen(change.getUri())) continue;
            xmlTextDocumentService.doSave(change.getUri());
        }
    }
}

