/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsd.contentmodel;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.xerces.impl.xs.XSLoaderImpl;
import org.apache.xerces.xs.XSModel;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.NoNamespaceSchemaLocation;
import org.eclipse.lemminx.dom.SchemaLocation;
import org.eclipse.lemminx.extensions.contentmodel.model.CMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelProvider;
import org.eclipse.lemminx.extensions.xsd.contentmodel.CMXSDDocument;
import org.eclipse.lemminx.uriresolver.CacheResourceDownloadingException;
import org.eclipse.lemminx.uriresolver.URIResolverExtensionManager;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lemminx.utils.StringUtils;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;

public class CMXSDContentModelProvider
implements ContentModelProvider {
    private final URIResolverExtensionManager resolverExtensionManager;

    public CMXSDContentModelProvider(URIResolverExtensionManager resolverExtensionManager) {
        this.resolverExtensionManager = resolverExtensionManager;
    }

    @Override
    public boolean adaptFor(DOMDocument document, boolean internal) {
        if (internal) {
            return false;
        }
        return document.hasSchemaLocation() || document.hasNoNamespaceSchemaLocation();
    }

    @Override
    public boolean adaptFor(String uri) {
        return DOMUtils.isXSD(uri);
    }

    @Override
    public Collection<String> getSystemIds(DOMDocument xmlDocument, String namespaceURI) {
        ArrayList<String> systemIds = new ArrayList<String>();
        SchemaLocation schemaLocation = xmlDocument.getSchemaLocation();
        if (schemaLocation != null) {
            String location = schemaLocation.getLocationHint(namespaceURI);
            if (!StringUtils.isEmpty(location)) {
                systemIds.add(location);
            }
        } else {
            String location;
            NoNamespaceSchemaLocation noNamespaceSchemaLocation = xmlDocument.getNoNamespaceSchemaLocation();
            if (noNamespaceSchemaLocation != null && namespaceURI == null && !StringUtils.isEmpty(location = noNamespaceSchemaLocation.getLocation())) {
                systemIds.add(location);
            }
        }
        return systemIds;
    }

    @Override
    public CMDocument createCMDocument(String key) {
        XSLoaderImpl loader = this.getLoader();
        XSModel model = loader.loadURI(key);
        if (model != null) {
            return new CMXSDDocument(model, loader);
        }
        return null;
    }

    @Override
    public CMDocument createInternalCMDocument(DOMDocument xmlDocument) {
        return null;
    }

    public XSLoaderImpl getLoader() {
        XSLoaderImpl loader = new XSLoaderImpl();
        loader.setParameter("http://apache.org/xml/properties/internal/entity-resolver", (Object)this.resolverExtensionManager);
        loader.setParameter("error-handler", (Object)new DOMErrorHandler(){

            @Override
            public boolean handleError(DOMError error) {
                if (error.getRelatedException() instanceof CacheResourceDownloadingException) {
                    throw (CacheResourceDownloadingException)error.getRelatedException();
                }
                return false;
            }
        });
        return loader;
    }
}

