/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMDocumentType;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.LSPErrorReporterForXML;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.LSPSAXParser;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.LSPXMLParserConfiguration;
import org.eclipse.lemminx.extensions.contentmodel.settings.ContentModelSettings;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationSettings;
import org.eclipse.lemminx.services.extensions.diagnostics.LSPContentHandler;
import org.eclipse.lemminx.uriresolver.CacheResourceDownloadingException;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class XMLValidator {
    private static final Logger LOGGER = Logger.getLogger(XMLValidator.class.getName());

    public static void doDiagnostics(DOMDocument document, XMLEntityResolver entityResolver, List<Diagnostic> diagnostics, ContentModelSettings contentModelSettings, XMLGrammarPool grammarPool, CancelChecker monitor) {
        try {
            XMLValidationSettings validationSettings = contentModelSettings != null ? contentModelSettings.getValidation() : null;
            LSPXMLParserConfiguration configuration = new LSPXMLParserConfiguration(grammarPool, XMLValidator.isDisableOnlyDTDValidation(document), validationSettings);
            if (entityResolver != null) {
                configuration.setProperty("http://apache.org/xml/properties/internal/entity-resolver", entityResolver);
            }
            LSPErrorReporterForXML reporter = new LSPErrorReporterForXML(document, diagnostics);
            LSPSAXParser parser = new LSPSAXParser(document, reporter, (XMLParserConfiguration)configuration, grammarPool);
            parser.setContentHandler(new LSPContentHandler(monitor));
            boolean hasGrammar = document.hasGrammar(true);
            if (validationSettings == null || validationSettings.isSchema()) {
                XMLValidator.checkExternalSchema(document.getExternalSchemaLocation(), parser);
                parser.setFeature("http://apache.org/xml/features/validation/schema", hasGrammar);
                XMLValidator.warnNoGrammar(document, diagnostics, contentModelSettings);
            } else {
                hasGrammar = false;
            }
            parser.setFeature("http://xml.org/sax/features/validation", hasGrammar);
            String content = document.getText();
            String uri = document.getDocumentURI();
            XMLValidator.parseXML(content, uri, parser);
        }
        catch (IOException | CancellationException | SAXException validationSettings) {
        }
        catch (CacheResourceDownloadingException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unexpected XMLValidator error", e);
        }
    }

    private static void parseXML(String content, String uri, SAXParser parser) throws SAXException, IOException {
        InputSource inputSource = new InputSource();
        inputSource.setCharacterStream(new StringReader(content));
        inputSource.setSystemId(uri);
        parser.parse(inputSource);
    }

    private static boolean isDisableOnlyDTDValidation(DOMDocument document) {
        if (!document.hasDTD()) {
            return false;
        }
        DOMDocumentType docType = document.getDoctype();
        if (docType.getKindNode() != null) {
            return false;
        }
        return !docType.getChildren().stream().anyMatch(node -> node.isDTDElementDecl() || node.isDTDAttListDecl());
    }

    private static void warnNoGrammar(DOMDocument document, List<Diagnostic> diagnostics, ContentModelSettings settings) {
        boolean hasGrammar = document.hasGrammar();
        if (hasGrammar) {
            return;
        }
        DiagnosticSeverity severity = XMLValidationSettings.getNoGrammarSeverity(settings);
        if (severity == null) {
            return;
        }
        if (!hasGrammar) {
            Range range = null;
            DOMElement documentElement = document.getDocumentElement();
            if (documentElement != null) {
                range = XMLPositionUtility.selectStartTagName(documentElement);
            }
            if (range == null) {
                range = new Range(new Position(0, 0), new Position(0, 0));
            }
            diagnostics.add(new Diagnostic(range, "No grammar constraints (DTD or XML Schema).", severity, document.getDocumentURI(), "XML"));
        }
    }

    private static void checkExternalSchema(Map<String, String> result, SAXParser reader) throws SAXNotRecognizedException, SAXNotSupportedException {
        String noNamespaceSchemaLocation;
        if (result != null && (noNamespaceSchemaLocation = result.get("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation")) != null) {
            reader.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", (Object)noNamespaceSchemaLocation);
        }
    }
}

