/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.participants.DTDErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSchemaErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSyntaxErrorCode;
import org.eclipse.lemminx.extensions.xsd.participants.XSDErrorCode;
import org.eclipse.lemminx.services.extensions.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.IComponentProvider;
import org.eclipse.lemminx.settings.XMLFormattingOptions;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;

public class ContentModelCodeActionParticipant
implements ICodeActionParticipant {
    private final Map<String, ICodeActionParticipant> codeActionParticipants = new HashMap<String, ICodeActionParticipant>();

    public ContentModelCodeActionParticipant() {
        XMLSyntaxErrorCode.registerCodeActionParticipants(this.codeActionParticipants);
        DTDErrorCode.registerCodeActionParticipants(this.codeActionParticipants);
        XMLSchemaErrorCode.registerCodeActionParticipants(this.codeActionParticipants);
        XSDErrorCode.registerCodeActionParticipants(this.codeActionParticipants);
    }

    @Override
    public void doCodeAction(Diagnostic diagnostic, Range range, DOMDocument document, List<CodeAction> codeActions, XMLFormattingOptions formattingSettings, IComponentProvider componentProvider) {
        ICodeActionParticipant participant = this.codeActionParticipants.get(diagnostic.getCode());
        if (participant != null) {
            participant.doCodeAction(diagnostic, range, document, codeActions, formattingSettings, componentProvider);
        }
    }
}

