/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.settings;

import org.eclipse.lemminx.extensions.contentmodel.settings.ContentModelSettings;
import org.eclipse.lsp4j.DiagnosticSeverity;

public class XMLValidationSettings {
    private Boolean schema;
    private Boolean enabled;
    private boolean disallowDocTypeDecl;
    private boolean resolveExternalEntities;
    private String noGrammar;

    public XMLValidationSettings() {
        this.setSchema(true);
        this.setEnabled(true);
        this.setDisallowDocTypeDecl(false);
        this.setResolveExternalEntities(false);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isSchema() {
        return this.schema;
    }

    public void setSchema(boolean schema) {
        this.schema = schema;
    }

    public void setNoGrammar(String noGrammar) {
        this.noGrammar = noGrammar;
    }

    public String getNoGrammar() {
        return this.noGrammar;
    }

    public boolean isDisallowDocTypeDecl() {
        return this.disallowDocTypeDecl;
    }

    public void setDisallowDocTypeDecl(boolean disallowDocTypeDecl) {
        this.disallowDocTypeDecl = disallowDocTypeDecl;
    }

    public boolean isResolveExternalEntities() {
        return this.resolveExternalEntities;
    }

    public void setResolveExternalEntities(boolean resolveExternalEntities) {
        this.resolveExternalEntities = resolveExternalEntities;
    }

    public static DiagnosticSeverity getNoGrammarSeverity(ContentModelSettings settings) {
        DiagnosticSeverity defaultSeverity = DiagnosticSeverity.Hint;
        if (settings == null || settings.getValidation() == null) {
            return defaultSeverity;
        }
        XMLValidationSettings problems = settings.getValidation();
        String noGrammar = problems.getNoGrammar();
        if ("ignore".equalsIgnoreCase(noGrammar)) {
            return null;
        }
        if ("info".equalsIgnoreCase(noGrammar)) {
            return DiagnosticSeverity.Information;
        }
        if ("warning".equalsIgnoreCase(noGrammar)) {
            return DiagnosticSeverity.Warning;
        }
        if ("error".equalsIgnoreCase(noGrammar)) {
            return DiagnosticSeverity.Error;
        }
        return defaultSeverity;
    }

    public XMLValidationSettings merge(XMLValidationSettings settings) {
        if (settings != null) {
            this.schema = settings.schema;
            this.enabled = settings.enabled;
            this.disallowDocTypeDecl = settings.disallowDocTypeDecl;
            this.resolveExternalEntities = settings.resolveExternalEntities;
        }
        return this;
    }
}

