/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.xml.marshaller.unmarshaller;

import org.eclipse.kura.core.inventory.resources.SystemBundle;
import org.eclipse.kura.core.inventory.resources.SystemBundles;
import org.eclipse.kura.internal.xml.marshaller.unmarshaller.XmlJavaDataMapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlJavaBundlesMapper
implements XmlJavaDataMapper {
    private static final String BUNDLES = "bundles";
    private static final String BUNDLES_BUNDLE = "bundle";
    private static final String BUNDLES_BUNDLE_NAME = "name";
    private static final String BUNDLES_BUNDLE_VERSION = "version";
    private static final String BUNDLES_BUNDLE_ID = "id";
    private static final String BUNDLES_BUNDLE_STATE = "state";

    @Override
    public Element marshal(Document doc, Object object) throws Exception {
        SystemBundle[] xmlBundleArray;
        Element bundles = doc.createElement(BUNDLES);
        doc.appendChild(bundles);
        SystemBundles xmlBundles = (SystemBundles)object;
        SystemBundle[] systemBundleArray = xmlBundleArray = xmlBundles.getBundles();
        int n = xmlBundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            SystemBundle xmlBundle = systemBundleArray[n2];
            Element bundle = doc.createElement(BUNDLES_BUNDLE);
            XmlJavaBundlesMapper.marshallBundle(doc, xmlBundle, bundle);
            bundles.appendChild(bundle);
            ++n2;
        }
        return bundles;
    }

    @Override
    public <T> T unmarshal(Document doc) throws Exception {
        return null;
    }

    private static void marshallBundle(Document doc, SystemBundle xmlBundle, Element bundle) {
        String bundleName = xmlBundle.getName();
        String bundleVersion = xmlBundle.getVersion();
        String bundleId = Long.toString(xmlBundle.getId());
        String bundleState = xmlBundle.getState();
        if (bundleName != null && !bundleName.trim().isEmpty()) {
            Element name = doc.createElement(BUNDLES_BUNDLE_NAME);
            name.setTextContent(bundleName);
            bundle.appendChild(name);
        }
        if (bundleVersion != null && !bundleVersion.trim().isEmpty()) {
            Element version = doc.createElement(BUNDLES_BUNDLE_VERSION);
            version.setTextContent(bundleVersion);
            bundle.appendChild(version);
        }
        if (bundleId != null && !bundleId.trim().isEmpty()) {
            Element id = doc.createElement(BUNDLES_BUNDLE_ID);
            id.setTextContent(bundleId);
            bundle.appendChild(id);
        }
        if (bundleState != null && !bundleState.trim().isEmpty()) {
            Element state = doc.createElement(BUNDLES_BUNDLE_STATE);
            state.setTextContent(bundleState);
            bundle.appendChild(state);
        }
    }
}

