/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.broker.artemis.core;

import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.config.impl.SecurityConfiguration;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.jms.server.config.impl.FileJMSConfiguration;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.spi.core.security.jaas.InVMLoginModule;
import org.eclipse.kura.broker.artemis.core.ServerConfiguration;
import org.eclipse.kura.broker.artemis.core.UserAuthentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerRunner {
    private static final Logger logger = LoggerFactory.getLogger(ServerRunner.class);
    private final ServerConfiguration configuration;
    private Map<String, ActiveMQComponent> components;
    private final Collection<ProtocolManagerFactory<?>> protocols;

    public ServerRunner(ServerConfiguration configuration, Collection<ProtocolManagerFactory<?>> protocols) {
        this.configuration = configuration;
        this.protocols = protocols;
    }

    public void start() throws Exception {
        Path file = Files.createTempFile("broker-", ".xml", new FileAttribute[0]);
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(Files.newOutputStream(file, new OpenOption[0]), StandardCharsets.UTF_8), true);){
                ((Writer)writer).write(this.configuration.getBrokerXml());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.createArtemis(file);
        }
        finally {
            Files.deleteIfExists(file);
        }
    }

    private void createArtemis(Path brokerXmlFile) throws Exception {
        ActiveMQSecurityManager security = this.createSecurityManager();
        FileConfiguration configurationFile = new FileConfiguration();
        FileJMSConfiguration jmsConfiguration = new FileJMSConfiguration();
        FileDeploymentManager fileDeploymentManager = new FileDeploymentManager(brokerXmlFile.toUri().toString());
        fileDeploymentManager.addDeployable((Deployable)configurationFile);
        fileDeploymentManager.addDeployable((Deployable)jmsConfiguration);
        fileDeploymentManager.readConfiguration();
        this.components = fileDeploymentManager.buildService(security, ManagementFactory.getPlatformMBeanServer());
        logger.info("Loaded components: {}", (Object)this.components.size());
        for (Map.Entry<String, ActiveMQComponent> entry : this.components.entrySet()) {
            logger.info("\t{} -> {}", (Object)entry.getKey(), (Object)entry.getValue());
        }
        ActiveMQServer server = (ActiveMQServer)this.components.get("core");
        if (server != null) {
            for (ProtocolManagerFactory<?> protocol : this.protocols) {
                logger.debug("Registering protocol: {}", protocol);
                server.addProtocolManagerFactory(protocol);
            }
        }
        this.startComponents();
    }

    private ActiveMQSecurityManager createSecurityManager() {
        return ServerRunner.createSecurityManager(this.configuration.getUserAuthentication());
    }

    private static ActiveMQSecurityManager createSecurityManager(UserAuthentication source) {
        SecurityConfiguration configuration = new SecurityConfiguration();
        configuration.setDefaultUser(source.getDefaultUser());
        for (UserAuthentication.User user : source.getUsers()) {
            configuration.addUser(user.getName(), user.getPassword());
            for (String role : user.getRoles()) {
                configuration.addRole(user.getName(), role);
            }
        }
        return new ActiveMQJAASSecurityManager(InVMLoginModule.class.getName(), configuration);
    }

    public void stop() throws Exception {
        this.stopComponents();
    }

    private List<ActiveMQComponent> getComponents() {
        ActiveMQComponent core;
        if (this.components == null) {
            return Collections.emptyList();
        }
        ArrayList<ActiveMQComponent> result = new ArrayList<ActiveMQComponent>(2);
        ActiveMQComponent jms = this.components.get("jms");
        if (jms != null) {
            result.add(jms);
        }
        if ((core = this.components.get("core")) == null) {
            return Collections.emptyList();
        }
        result.add(core);
        return result;
    }

    private void startComponents() throws Exception {
        for (ActiveMQComponent component : this.getComponents()) {
            component.start();
        }
    }

    private void stopComponents() throws Exception {
        List<ActiveMQComponent> currentComponents = this.getComponents();
        ListIterator<ActiveMQComponent> iter = currentComponents.listIterator(currentComponents.size());
        while (iter.hasPrevious()) {
            iter.previous().stop();
        }
    }
}

