/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.persistence;

import io.moquette.broker.SessionRegistry;
import io.moquette.broker.subscriptions.Topic;
import io.moquette.persistence.ByteBufDataType;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.nio.ByteBuffer;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.StringDataType;

public final class EnqueuedMessageValueType
implements DataType {
    private final StringDataType topicDataType = new StringDataType();
    private final ByteBufDataType payloadDataType = new ByteBufDataType();

    @Override
    public int compare(Object a, Object b) {
        return 0;
    }

    @Override
    public int getMemory(Object obj) {
        if (obj instanceof SessionRegistry.PubRelMarker) {
            return 1;
        }
        SessionRegistry.PublishedMessage casted = (SessionRegistry.PublishedMessage)obj;
        return 2 + this.topicDataType.getMemory(casted.getTopic().toString()) + this.payloadDataType.getMemory(casted.getPayload());
    }

    @Override
    public void write(WriteBuffer buff, Object obj) {
        if (obj instanceof SessionRegistry.PublishedMessage) {
            buff.put((byte)MessageType.PUBLISHED_MESSAGE.ordinal());
            SessionRegistry.PublishedMessage casted = (SessionRegistry.PublishedMessage)obj;
            buff.put((byte)casted.getPublishingQos().value());
            String token = casted.getTopic().toString();
            this.topicDataType.write(buff, token);
            this.payloadDataType.write(buff, casted.getPayload());
        } else if (obj instanceof SessionRegistry.PubRelMarker) {
            buff.put((byte)MessageType.PUB_REL_MARKER.ordinal());
        } else {
            throw new IllegalArgumentException("Unrecognized message class " + obj.getClass());
        }
    }

    @Override
    public void write(WriteBuffer buff, Object[] obj, int len, boolean key) {
        for (int i = 0; i < len; ++i) {
            this.write(buff, obj[i]);
        }
    }

    @Override
    public Object read(ByteBuffer buff) {
        byte messageType = buff.get();
        if (messageType == MessageType.PUB_REL_MARKER.ordinal()) {
            return new SessionRegistry.PubRelMarker();
        }
        if (messageType == MessageType.PUBLISHED_MESSAGE.ordinal()) {
            MqttQoS qos = MqttQoS.valueOf(buff.get());
            String topicStr = this.topicDataType.read(buff);
            ByteBuf payload = this.payloadDataType.read(buff);
            return new SessionRegistry.PublishedMessage(Topic.asTopic(topicStr), qos, payload);
        }
        throw new IllegalArgumentException("Can't recognize record of type: " + messageType);
    }

    @Override
    public void read(ByteBuffer buff, Object[] obj, int len, boolean key) {
        for (int i = 0; i < len; ++i) {
            obj[i] = this.read(buff);
        }
    }

    private static enum MessageType {
        PUB_REL_MARKER,
        PUBLISHED_MESSAGE;

    }
}

