/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.container.orchestration.provider.impl;

import java.util.Map;
import java.util.Objects;
import org.eclipse.kura.util.configuration.Property;

public class ContainerOrchestrationServiceOptions {
    private static final Property<Boolean> IS_ENABLED = new Property("enabled", (Object)false);
    private static final Property<String> DOCKER_HOST_URL = new Property("container.engine.host", (Object)"unix:///var/run/docker.sock");
    private static final Property<Boolean> ENFORCEMENT_ENABLED = new Property("enforcement.enabled", (Object)false);
    private static final Property<String> ENFORCEMENT_ALLOWLIST = new Property("enforcement.allowlist", (Object)"");
    private final boolean enabled;
    private final String hostUrl;
    private final boolean enforcementEnabled;
    private final String enforcementAllowlist;

    public ContainerOrchestrationServiceOptions(Map<String, Object> properties) {
        if (Objects.isNull(properties)) {
            throw new IllegalArgumentException("Properties cannot be null!");
        }
        this.enabled = (Boolean)IS_ENABLED.get(properties);
        this.hostUrl = (String)DOCKER_HOST_URL.get(properties);
        this.enforcementEnabled = (Boolean)ENFORCEMENT_ENABLED.get(properties);
        this.enforcementAllowlist = (String)ENFORCEMENT_ALLOWLIST.get(properties);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getHostUrl() {
        return this.hostUrl;
    }

    public boolean isEnforcementEnabled() {
        return this.enforcementEnabled;
    }

    public String getEnforcementAllowlist() {
        return this.enforcementAllowlist;
    }

    public int hashCode() {
        return Objects.hash(this.enforcementAllowlist, this.enforcementEnabled, this.enabled, this.hostUrl);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContainerOrchestrationServiceOptions other = (ContainerOrchestrationServiceOptions)obj;
        return Objects.equals(this.enforcementAllowlist, other.enforcementAllowlist) && this.enforcementEnabled == other.enforcementEnabled && this.enabled == other.enabled && Objects.equals(this.hostUrl, other.hostUrl);
    }
}

