/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.json.marshaller.unmarshaller.message;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.Base64;
import java.util.Date;
import org.eclipse.kura.internal.json.marshaller.unmarshaller.message.CloudPayloadJsonFields;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.message.KuraPosition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudPayloadJsonEncoder {
    private static final Logger logger = LoggerFactory.getLogger(CloudPayloadJsonEncoder.class);

    private CloudPayloadJsonEncoder() {
    }

    public static String marshal(KuraPayload kuraPayload) {
        JsonObject json = Json.object();
        CloudPayloadJsonEncoder.encodeTimestamp(kuraPayload, json);
        CloudPayloadJsonEncoder.encodePosition(kuraPayload, json);
        CloudPayloadJsonEncoder.encodeMetrics(kuraPayload, json);
        CloudPayloadJsonEncoder.encodeBody(kuraPayload, json);
        return json.toString();
    }

    private static void encodeBody(KuraPayload kuraPayload, JsonObject json) {
        byte[] body = kuraPayload.getBody();
        if (body != null) {
            json.add(CloudPayloadJsonFields.BODY.value(), Base64.getEncoder().encodeToString(body));
        }
    }

    private static void encodeMetrics(KuraPayload kuraPayload, JsonObject json) {
        JsonObject jsonMetrics = Json.object();
        for (String name : kuraPayload.metricNames()) {
            Object object = kuraPayload.getMetric(name);
            if (object instanceof Boolean) {
                jsonMetrics.add(name, ((Boolean)object).booleanValue());
                continue;
            }
            if (object instanceof Double) {
                CloudPayloadJsonEncoder.encodeDoubleMetric(jsonMetrics, name, object);
                continue;
            }
            if (object instanceof Float) {
                CloudPayloadJsonEncoder.encodeFloatMetric(jsonMetrics, name, object);
                continue;
            }
            if (object instanceof Integer) {
                jsonMetrics.add(name, ((Integer)object).intValue());
                continue;
            }
            if (object instanceof Long) {
                jsonMetrics.add(name, ((Long)object).longValue());
                continue;
            }
            if (object instanceof String) {
                jsonMetrics.add(name, (String)object);
                continue;
            }
            if (object instanceof byte[]) {
                jsonMetrics.add(name, Base64.getEncoder().encodeToString((byte[])object));
                continue;
            }
            throw new IllegalArgumentException("Cannot encode this value: " + object.toString());
        }
        json.add(CloudPayloadJsonFields.METRICS.value(), (JsonValue)jsonMetrics);
    }

    private static void encodeFloatMetric(JsonObject jsonMetrics, String name, Object object) {
        CloudPayloadJsonEncoder.encodeFloatProperty(jsonMetrics, name, object, "discarding non finite float metric: {}={}");
    }

    private static void encodeDoubleMetric(JsonObject jsonMetrics, String name, Object object) {
        CloudPayloadJsonEncoder.encodeDoubleProperty(jsonMetrics, name, object, "discarding non finite double metric: {}={}");
    }

    private static void encodePosition(KuraPayload kuraPayload, JsonObject json) {
        KuraPosition position = kuraPayload.getPosition();
        if (position == null) {
            return;
        }
        JsonObject jsonPosition = Json.object();
        CloudPayloadJsonEncoder.encodePositionDouble(jsonPosition, CloudPayloadJsonFields.CloudPayloadJsonPositionFields.LATITUDE.value(), position.getLatitude());
        CloudPayloadJsonEncoder.encodePositionDouble(jsonPosition, CloudPayloadJsonFields.CloudPayloadJsonPositionFields.LONGITUDE.value(), position.getLongitude());
        CloudPayloadJsonEncoder.encodePositionDouble(jsonPosition, CloudPayloadJsonFields.CloudPayloadJsonPositionFields.ALTITUDE.value(), position.getAltitude());
        CloudPayloadJsonEncoder.encodePositionDouble(jsonPosition, CloudPayloadJsonFields.CloudPayloadJsonPositionFields.HEADING.value(), position.getHeading());
        CloudPayloadJsonEncoder.encodePositionDouble(jsonPosition, CloudPayloadJsonFields.CloudPayloadJsonPositionFields.PRECISION.value(), position.getPrecision());
        if (position.getSatellites() != null) {
            jsonPosition.add(CloudPayloadJsonFields.CloudPayloadJsonPositionFields.SATELLITES.value(), position.getSatellites().intValue());
        }
        CloudPayloadJsonEncoder.encodePositionDouble(jsonPosition, CloudPayloadJsonFields.CloudPayloadJsonPositionFields.SPEED.value(), position.getSpeed());
        if (position.getTimestamp() != null) {
            jsonPosition.add(CloudPayloadJsonFields.CloudPayloadJsonPositionFields.TIMESTAMP.value(), position.getTimestamp().getTime());
        }
        if (position.getStatus() != null) {
            jsonPosition.add(CloudPayloadJsonFields.CloudPayloadJsonPositionFields.STATUS.value(), position.getStatus().intValue());
        }
        json.add(CloudPayloadJsonFields.POSITION.value(), (JsonValue)jsonPosition);
    }

    private static void encodePositionDouble(JsonObject object, String metric, Double value) {
        if (value != null) {
            CloudPayloadJsonEncoder.encodeDoubleProperty(object, metric, value, "discarding non finite double metric: position.{}={}");
        }
    }

    private static void encodeTimestamp(KuraPayload kuraPayload, JsonObject json) {
        Date timestamp = kuraPayload.getTimestamp();
        if (timestamp != null) {
            json.add(CloudPayloadJsonFields.SENTON.value(), timestamp.getTime());
        }
    }

    private static void encodeFloatProperty(JsonObject object, String name, Object value, String errorMessageFormat) {
        Float floatValue = (Float)value;
        if (Float.isFinite(floatValue.floatValue())) {
            object.add(name, floatValue.floatValue());
        } else {
            logger.warn(errorMessageFormat, (Object)name, (Object)floatValue);
        }
    }

    private static void encodeDoubleProperty(JsonObject object, String name, Object value, String errorMessageFormat) {
        Double doubleValue = (Double)value;
        if (Double.isFinite(doubleValue)) {
            object.add(name, doubleValue.doubleValue());
        } else {
            logger.warn(errorMessageFormat, (Object)name, (Object)doubleValue);
        }
    }
}

