/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.cloud;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloud.CloudClient;
import org.eclipse.kura.cloud.CloudClientListener;
import org.eclipse.kura.core.cloud.CloudClientListenerAdapter;
import org.eclipse.kura.core.cloud.CloudServiceImpl;
import org.eclipse.kura.core.cloud.CloudServiceOptions;
import org.eclipse.kura.data.DataService;
import org.eclipse.kura.message.KuraPayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudClientImpl
implements CloudClient,
CloudClientListener {
    private static final Logger logger = LoggerFactory.getLogger(CloudClientImpl.class);
    private final String applicationId;
    private final DataService dataService;
    private final CloudServiceImpl cloudServiceImpl;
    private final List<CloudClientListenerAdapter> listeners;

    protected CloudClientImpl(String applicationId, DataService dataService, CloudServiceImpl cloudServiceImpl) {
        this.applicationId = applicationId;
        this.dataService = dataService;
        this.cloudServiceImpl = cloudServiceImpl;
        this.listeners = new CopyOnWriteArrayList<CloudClientListenerAdapter>();
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void release() {
        this.cloudServiceImpl.removeCloudClient(this);
    }

    public void addCloudClientListener(CloudClientListener cloudClientListener) {
        this.listeners.add(new CloudClientListenerAdapter(cloudClientListener));
    }

    public void removeCloudClientListener(CloudClientListener cloudClientListener) {
        ArrayList<CloudClientListenerAdapter> adapters = new ArrayList<CloudClientListenerAdapter>(this.listeners);
        for (CloudClientListenerAdapter adapter : adapters) {
            if (adapter.getCloudClientListenerAdapted() != cloudClientListener) continue;
            this.listeners.remove(adapter);
            break;
        }
    }

    public boolean isConnected() {
        return this.dataService.isConnected();
    }

    public int publish(String appTopic, KuraPayload payload, int qos, boolean retain) throws KuraException {
        CloudServiceOptions options = this.cloudServiceImpl.getCloudServiceOptions();
        return this.publish(CloudServiceOptions.getTopicClientIdToken(), appTopic, payload, qos, retain);
    }

    public int publish(String deviceId, String appTopic, KuraPayload payload, int qos, boolean retain) throws KuraException {
        return this.publish(deviceId, appTopic, payload, qos, retain, 5);
    }

    public int publish(String appTopic, KuraPayload payload, int qos, boolean retain, int priority) throws KuraException {
        CloudServiceOptions options = this.cloudServiceImpl.getCloudServiceOptions();
        return this.publish(CloudServiceOptions.getTopicClientIdToken(), appTopic, payload, qos, retain, priority);
    }

    public int publish(String deviceId, String appTopic, KuraPayload payload, int qos, boolean retain, int priority) throws KuraException {
        byte[] appPayload = this.cloudServiceImpl.encodePayload(payload);
        return this.publish(deviceId, appTopic, appPayload, qos, retain, priority);
    }

    public int publish(String appTopic, byte[] payload, int qos, boolean retain, int priority) throws KuraException {
        CloudServiceOptions options = this.cloudServiceImpl.getCloudServiceOptions();
        return this.publish(CloudServiceOptions.getTopicClientIdToken(), appTopic, payload, qos, retain, priority);
    }

    public int publish(String deviceId, String appTopic, byte[] payload, int qos, boolean retain, int priority) throws KuraException {
        boolean isControl = false;
        String fullTopic = this.encodeTopic(deviceId, appTopic, isControl);
        return this.dataService.publish(fullTopic, payload, qos, retain, priority);
    }

    public int controlPublish(String appTopic, KuraPayload payload, int qos, boolean retain, int priority) throws KuraException {
        CloudServiceOptions options = this.cloudServiceImpl.getCloudServiceOptions();
        return this.controlPublish(CloudServiceOptions.getTopicClientIdToken(), appTopic, payload, qos, retain, priority);
    }

    public int controlPublish(String deviceId, String appTopic, KuraPayload payload, int qos, boolean retain, int priority) throws KuraException {
        byte[] appPayload = this.cloudServiceImpl.encodePayload(payload);
        return this.controlPublish(deviceId, appTopic, appPayload, qos, retain, priority);
    }

    public int controlPublish(String deviceId, String appTopic, byte[] payload, int qos, boolean retain, int priority) throws KuraException {
        boolean isControl = true;
        String fullTopic = this.encodeTopic(deviceId, appTopic, isControl);
        return this.dataService.publish(fullTopic, payload, qos, retain, priority);
    }

    public void subscribe(String appTopic, int qos) throws KuraException {
        CloudServiceOptions options = this.cloudServiceImpl.getCloudServiceOptions();
        this.subscribe(CloudServiceOptions.getTopicClientIdToken(), appTopic, qos);
    }

    public void subscribe(String deviceId, String appTopic, int qos) throws KuraException {
        boolean isControl = false;
        String fullTopic = this.encodeTopic(deviceId, appTopic, isControl);
        this.dataService.subscribe(fullTopic, qos);
    }

    public void controlSubscribe(String appTopic, int qos) throws KuraException {
        CloudServiceOptions options = this.cloudServiceImpl.getCloudServiceOptions();
        this.controlSubscribe(CloudServiceOptions.getTopicClientIdToken(), appTopic, qos);
    }

    public void controlSubscribe(String deviceId, String appTopic, int qos) throws KuraException {
        boolean isControl = true;
        String fullTopic = this.encodeTopic(deviceId, appTopic, isControl);
        this.dataService.subscribe(fullTopic, qos);
    }

    public void unsubscribe(String appTopic) throws KuraException {
        CloudServiceOptions options = this.cloudServiceImpl.getCloudServiceOptions();
        this.unsubscribe(CloudServiceOptions.getTopicClientIdToken(), appTopic);
    }

    public void unsubscribe(String deviceId, String appTopic) throws KuraException {
        boolean isControl = false;
        String fullTopic = this.encodeTopic(deviceId, appTopic, isControl);
        this.dataService.unsubscribe(fullTopic);
    }

    public void controlUnsubscribe(String appTopic) throws KuraException {
        CloudServiceOptions options = this.cloudServiceImpl.getCloudServiceOptions();
        this.controlUnsubscribe(CloudServiceOptions.getTopicClientIdToken(), appTopic);
    }

    public void controlUnsubscribe(String deviceId, String appTopic) throws KuraException {
        boolean isControl = true;
        String fullTopic = this.encodeTopic(deviceId, appTopic, isControl);
        this.dataService.unsubscribe(fullTopic);
    }

    public List<Integer> getUnpublishedMessageIds() throws KuraException {
        String topicRegex = this.getAppTopicRegex();
        return this.dataService.getUnpublishedMessageIds(topicRegex);
    }

    public List<Integer> getInFlightMessageIds() throws KuraException {
        String topicRegex = this.getAppTopicRegex();
        return this.dataService.getInFlightMessageIds(topicRegex);
    }

    public List<Integer> getDroppedInFlightMessageIds() throws KuraException {
        String topicRegex = this.getAppTopicRegex();
        return this.dataService.getDroppedInFlightMessageIds(topicRegex);
    }

    public void onMessageArrived(String deviceId, String appTopic, KuraPayload payload, int qos, boolean retain) {
        for (CloudClientListener cloudClientListener : this.listeners) {
            cloudClientListener.onMessageArrived(deviceId, appTopic, payload, qos, retain);
        }
    }

    public void onControlMessageArrived(String deviceId, String appTopic, KuraPayload payload, int qos, boolean retain) {
        for (CloudClientListener cloudClientListener : this.listeners) {
            cloudClientListener.onControlMessageArrived(deviceId, appTopic, payload, qos, retain);
        }
    }

    public void onMessageConfirmed(int pubId, String appTopic) {
        for (CloudClientListener cloudClientListener : this.listeners) {
            cloudClientListener.onMessageConfirmed(pubId, appTopic);
        }
    }

    public void onMessagePublished(int pubId, String appTopic) {
        for (CloudClientListener cloudClientListener : this.listeners) {
            cloudClientListener.onMessagePublished(pubId, appTopic);
        }
    }

    public void onConnectionEstablished() {
        for (CloudClientListener cloudClientListener : this.listeners) {
            cloudClientListener.onConnectionEstablished();
        }
    }

    public void onConnectionLost() {
        for (CloudClientListener cloudClientListener : this.listeners) {
            cloudClientListener.onConnectionLost();
        }
    }

    private String encodeTopic(String deviceId, String appTopic, boolean isControl) {
        CloudServiceOptions options = this.cloudServiceImpl.getCloudServiceOptions();
        StringBuilder sb = new StringBuilder();
        if (isControl) {
            sb.append(options.getTopicControlPrefix()).append(CloudServiceOptions.getTopicSeparator());
        }
        sb.append(CloudServiceOptions.getTopicAccountToken()).append(CloudServiceOptions.getTopicSeparator()).append(deviceId).append(CloudServiceOptions.getTopicSeparator()).append(this.applicationId);
        if (appTopic != null && !appTopic.isEmpty()) {
            sb.append(CloudServiceOptions.getTopicSeparator()).append(appTopic);
        }
        return sb.toString();
    }

    private String getAppTopicRegex() {
        CloudServiceOptions options = this.cloudServiceImpl.getCloudServiceOptions();
        StringBuilder sb = new StringBuilder();
        sb.append("^(").append("\\$EDC").append(CloudServiceOptions.getTopicSeparator()).append(")?").append(CloudServiceOptions.getTopicAccountToken()).append(CloudServiceOptions.getTopicSeparator()).append(".+").append(CloudServiceOptions.getTopicSeparator()).append(this.applicationId).append("(/.+)?");
        return sb.toString();
    }
}

