/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.deployment.install;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.KuraProcessExecutionErrorException;
import org.eclipse.kura.cloudconnection.publisher.CloudNotificationPublisher;
import org.eclipse.kura.core.deployment.CloudDeploymentHandlerV2;
import org.eclipse.kura.core.deployment.DeploymentPackageOptions;
import org.eclipse.kura.core.deployment.InstallStatus;
import org.eclipse.kura.core.deployment.download.DeploymentPackageDownloadOptions;
import org.eclipse.kura.core.deployment.install.DeploymentPackageInstallOptions;
import org.eclipse.kura.core.deployment.install.KuraInstallPayload;
import org.eclipse.kura.core.deployment.util.FileUtilities;
import org.eclipse.kura.core.linux.executor.LinuxSignal;
import org.eclipse.kura.executor.Command;
import org.eclipse.kura.executor.CommandExecutorService;
import org.eclipse.kura.executor.CommandStatus;
import org.eclipse.kura.executor.Signal;
import org.eclipse.kura.message.KuraResponsePayload;
import org.osgi.service.deploymentadmin.DeploymentAdmin;
import org.osgi.service.deploymentadmin.DeploymentException;
import org.osgi.service.deploymentadmin.DeploymentPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallImpl {
    private static final Logger logger = LoggerFactory.getLogger(InstallImpl.class);
    private static final int PROGRESS_COMPLETE = 100;
    private static final String MESSAGE_CONFIGURATION_FILE_NOT_SPECIFIED = "Configuration file not specified";
    public static final String RESOURCE_INSTALL = "install";
    public static final String PERSISTANCE_SUFFIX = "_persistance";
    public static final String PERSISTANCE_FOLDER_NAME = "persistance";
    public static final String PERSISTANCE_VERIFICATION_FOLDER_NAME = "verification";
    public static final String PERSISTANCE_FILE_NAME = "persistance.file.name";
    private DeploymentPackageInstallOptions options;
    private final CloudDeploymentHandlerV2 callback;
    private DeploymentAdmin deploymentAdmin;
    private Properties installPersistance;
    private String dpaConfPath;
    private final String installVerifDir;
    private final String installPersistanceDir;
    private String packagesPath;
    private CommandExecutorService executorService;

    public InstallImpl(CloudDeploymentHandlerV2 callback, String kuraDataDir, CommandExecutorService executorService) {
        this.callback = callback;
        StringBuilder pathSB = new StringBuilder();
        pathSB.append(kuraDataDir);
        pathSB.append(File.separator);
        pathSB.append(PERSISTANCE_FOLDER_NAME);
        this.installPersistanceDir = pathSB.toString();
        File installPersistanceDirFile = new File(this.installPersistanceDir);
        if (!installPersistanceDirFile.exists()) {
            installPersistanceDirFile.mkdir();
        }
        pathSB = new StringBuilder();
        pathSB.append(this.installPersistanceDir);
        pathSB.append(File.separator);
        pathSB.append(PERSISTANCE_VERIFICATION_FOLDER_NAME);
        this.installVerifDir = pathSB.toString();
        File installVerificationDir = new File(this.installVerifDir);
        if (!installVerificationDir.exists()) {
            installVerificationDir.mkdir();
        }
        this.executorService = executorService;
    }

    public String getVerificationDirectory() {
        return this.installVerifDir;
    }

    public Properties getDeployedPackages() {
        Properties deployedPackages = new Properties();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream fis = new FileInputStream(this.dpaConfPath);){
                deployedPackages.load(fis);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.error("Error opening package configuration file", (Throwable)e);
        }
        return deployedPackages;
    }

    public void setOptions(DeploymentPackageInstallOptions options) {
        this.options = options;
    }

    public void setPackagesPath(String packagesPath) {
        this.packagesPath = packagesPath;
    }

    public void setDeploymentAdmin(DeploymentAdmin deploymentAdmin) {
        this.deploymentAdmin = deploymentAdmin;
    }

    public void setDpaConfPath(String dpaConfPath) {
        this.dpaConfPath = dpaConfPath;
    }

    public void installDp(DeploymentPackageInstallOptions options, File dpFile) {
        try {
            this.installDeploymentPackageInternal(dpFile);
            this.installCompleteAsync(options, dpFile.getName());
            logger.info("Install completed!");
            if (options.isReboot()) {
                Thread.sleep(options.getRebootDelay());
                Consumer<CommandStatus> commandCallback = status -> {};
                this.executorService.execute(new Command(new String[]{"reboot"}), commandCallback);
            }
        }
        catch (Exception e) {
            logger.info("Install failed!");
            this.installFailedAsync(options, dpFile.getName(), e);
        }
    }

    public void installSh(DeploymentPackageOptions options, File shFile) throws KuraException {
        String shFilePath;
        this.updateInstallPersistance(shFile.getName(), options);
        try {
            shFilePath = shFile.getCanonicalPath();
        }
        catch (IOException e) {
            throw new KuraProcessExecutionErrorException((Throwable)e, (Object)"Failed to get script path");
        }
        Command command = new Command(new String[]{"chmod", "700", shFilePath});
        command.setTimeout(60);
        CommandStatus status = this.executorService.execute(command);
        if (!status.getExitStatus().isSuccessful()) {
            throw new KuraProcessExecutionErrorException((Object)"Failed to change file mode");
        }
        status = this.executorService.execute(new Command(new String[]{shFilePath}));
        if (!status.getExitStatus().isSuccessful()) {
            throw new KuraProcessExecutionErrorException((Object)"Failed to execute script");
        }
    }

    public void installInProgressSyncMessage(KuraResponsePayload respPayload) {
        respPayload.setTimestamp(new Date());
        respPayload.addMetric("dp.install.status", (Object)InstallStatus.IN_PROGRESS.getStatusString());
        respPayload.addMetric("dp.name", (Object)this.options.getDpName());
        respPayload.addMetric("dp.version", (Object)this.options.getDpVersion());
    }

    public void installIdleSyncMessage(KuraResponsePayload respPayload) {
        respPayload.setTimestamp(new Date());
        respPayload.addMetric("dp.install.status", (Object)InstallStatus.IDLE.getStatusString());
    }

    public void installCompleteAsync(DeploymentPackageOptions options, String dpName) {
        KuraInstallPayload notify = new KuraInstallPayload(options.getClientId());
        notify.setTimestamp(new Date());
        notify.setInstallStatus(InstallStatus.COMPLETED.getStatusString());
        notify.setJobId(options.getJobId());
        notify.setDpName(dpName);
        notify.setInstallProgress(100);
        this.callback.publishMessage(options, notify, RESOURCE_INSTALL);
    }

    public void installFailedAsync(DeploymentPackageInstallOptions options, String dpName, Exception e) {
        KuraInstallPayload notify = new KuraInstallPayload(options.getClientId());
        notify.setTimestamp(new Date());
        notify.setInstallStatus(InstallStatus.FAILED.getStatusString());
        notify.setJobId(options.getJobId());
        notify.setDpName(dpName);
        notify.setInstallProgress(0);
        if (e != null) {
            notify.setErrorMessage(e.getMessage());
        }
        this.callback.publishMessage(options, notify, RESOURCE_INSTALL);
    }

    public void sendInstallConfirmations(String notificationPublisherPid, CloudNotificationPublisher notificationPublisher) {
        logger.info("Ready to send Confirmations");
        File verificationDir = new File(this.installVerifDir);
        if (verificationDir.listFiles() != null) {
            File[] fileArray = verificationDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File fileEntry = fileArray[n2];
                if (fileEntry.isFile() && (fileEntry.getName().endsWith(".sh") || fileEntry.getName().endsWith(".bat")) && this.isCorrectNotificationPublisher(notificationPublisherPid, fileEntry.getName())) {
                    this.runScriptAndNotify(notificationPublisher, fileEntry);
                }
                ++n2;
            }
        }
    }

    private void runScriptAndNotify(CloudNotificationPublisher notificationPublisher, File fileEntry) {
        block15: {
            logger.info("running verifier {}", (Object)fileEntry);
            String fileEntryPath = "";
            try {
                fileEntryPath = fileEntry.getCanonicalPath();
            }
            catch (IOException iOException) {
                logger.error("Failed to get script path");
            }
            Command command = new Command(new String[]{"chmod", "700", fileEntryPath});
            command.setTimeout(60);
            CommandStatus status = this.executorService.execute(command);
            if (!status.getExitStatus().isSuccessful()) {
                logger.error("Failed to change file mode");
            }
            String[] commandLine = new String[]{fileEntryPath};
            try {
                try {
                    status = this.executorService.execute(new Command(commandLine));
                    if (status.getExitStatus().isSuccessful()) {
                        this.sendSysUpdateSuccess(fileEntry.getName(), notificationPublisher);
                        break block15;
                    }
                    this.sendSysUpdateFailure(fileEntry.getName(), notificationPublisher);
                }
                catch (Exception e) {
                    logger.warn("failed to publish completion status", (Throwable)e);
                    this.executorService.kill(commandLine, (Signal)LinuxSignal.SIGKILL);
                    try {
                        Files.delete(fileEntry.toPath());
                    }
                    catch (IOException e2) {
                        logger.error("Cannot delete file {}", (Object)fileEntry, (Object)e2);
                    }
                }
            }
            finally {
                this.executorService.kill(commandLine, (Signal)LinuxSignal.SIGKILL);
                try {
                    Files.delete(fileEntry.toPath());
                }
                catch (IOException e) {
                    logger.error("Cannot delete file {}", (Object)fileEntry, (Object)e);
                }
            }
        }
    }

    private DeploymentPackage installDeploymentPackageInternal(File fileReference) throws DeploymentException, IOException {
        DeploymentPackage dp = null;
        File downloadedFile = fileReference;
        StringBuilder dpPersistentFilePath = new StringBuilder();
        try {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (FileInputStream dpInputStream = new FileInputStream(downloadedFile);){
                    dp = this.deploymentAdmin.installDeploymentPackage((InputStream)dpInputStream);
                    dpPersistentFilePath.append(this.packagesPath);
                    dpPersistentFilePath.append(File.separator);
                    dpPersistentFilePath.append(FileUtilities.getFileName(dp.getName(), dp.getVersion().toString(), ".dp", "_"));
                    File dpPersistentFile = new File(dpPersistentFilePath.toString());
                    boolean isDownloadedInPersistentPath = downloadedFile.getCanonicalPath().equals(dpPersistentFile.getCanonicalPath());
                    if (!isDownloadedInPersistentPath) {
                        logger.info("Moving downloaded DP from '{}' to '{}'.", (Object)downloadedFile.getCanonicalPath(), (Object)dpPersistentFile.getCanonicalPath());
                        Files.deleteIfExists(dpPersistentFile.toPath());
                        FileUtils.moveFile((File)downloadedFile, (File)dpPersistentFile);
                    }
                    this.addPackageToConfFile(dp.getName(), "file:" + dpPersistentFilePath.toString());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                logger.error("Unable to move downloaded DP from '" + downloadedFile.getCanonicalPath() + "' to '" + dpPersistentFilePath.toString() + "'.", (Throwable)ex);
                if (!downloadedFile.getCanonicalPath().equals(dpPersistentFilePath.toString())) {
                    downloadedFile.delete();
                }
            }
        }
        finally {
            if (!downloadedFile.getCanonicalPath().equals(dpPersistentFilePath.toString())) {
                downloadedFile.delete();
            }
        }
        return dp;
    }

    private void updateInstallPersistance(String fileName, DeploymentPackageOptions options) {
        this.installPersistance = new Properties();
        this.installPersistance.setProperty("client.id", options.getClientId());
        this.installPersistance.setProperty("job.id", Long.toString(options.getJobId()));
        this.installPersistance.setProperty("dp.name", fileName);
        this.installPersistance.setProperty("dp.version", options.getDpVersion());
        this.installPersistance.setProperty("requester.client.id", options.getRequestClientId());
        this.installPersistance.setProperty(PERSISTANCE_FILE_NAME, fileName);
        this.installPersistance.setProperty("publisherpid", options.getNotificationPublisherPid());
        if (this.installPersistanceDir == null) {
            logger.warn(MESSAGE_CONFIGURATION_FILE_NOT_SPECIFIED);
            return;
        }
        StringBuilder pathSB = new StringBuilder();
        pathSB.append(this.installPersistanceDir);
        pathSB.append(File.separator);
        pathSB.append(fileName);
        pathSB.append(PERSISTANCE_SUFFIX);
        String persistanceFile = pathSB.toString();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileOutputStream fos = new FileOutputStream(persistanceFile);){
                this.installPersistance.store(fos, null);
                fos.flush();
                fos.getFD().sync();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.error("Error writing remote install configuration file", (Throwable)e);
        }
    }

    private void addPackageToConfFile(String packageName, String packageUrl) {
        Properties deployedPackages = this.getDeployedPackages();
        deployedPackages.setProperty(packageName, packageUrl);
        if (this.dpaConfPath == null) {
            logger.warn(MESSAGE_CONFIGURATION_FILE_NOT_SPECIFIED);
            return;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileOutputStream fos = new FileOutputStream(this.dpaConfPath);){
                deployedPackages.store(fos, null);
                fos.flush();
                fos.getFD().sync();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.error("Error writing package configuration file", (Throwable)e);
        }
    }

    public void removePackageFromConfFile(String packageName) {
        Properties deployedPackages = this.getDeployedPackages();
        deployedPackages.remove(packageName);
        if (this.dpaConfPath == null) {
            logger.warn(MESSAGE_CONFIGURATION_FILE_NOT_SPECIFIED);
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileOutputStream fos = new FileOutputStream(this.dpaConfPath);){
                deployedPackages.store(fos, null);
                fos.flush();
                fos.getFD().sync();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.error("Error writing package configuration file", (Throwable)e);
        }
    }

    private void sendSysUpdateSuccess(String verificationFileName, CloudNotificationPublisher notificationPublisher) throws IOException {
        logger.info("Publishing success notification for verifier {}...", (Object)verificationFileName);
        File fileEntry = this.findPersistenceFileFromVerificationFile(verificationFileName);
        Properties downloadProperties = this.loadInstallPersistance(fileEntry);
        String deployUrl = downloadProperties.getProperty("dp.uri");
        String dpName = downloadProperties.getProperty("dp.name");
        String dpVersion = downloadProperties.getProperty("dp.version");
        String clientId = downloadProperties.getProperty("client.id");
        Long jobId = Long.valueOf(downloadProperties.getProperty("job.id"));
        String fileSystemFileName = downloadProperties.getProperty(PERSISTANCE_FILE_NAME);
        String requestClientId = downloadProperties.getProperty("requester.client.id");
        String notificationPid = downloadProperties.getProperty("publisherpid");
        DeploymentPackageDownloadOptions deployOptions = new DeploymentPackageDownloadOptions(deployUrl, dpName, dpVersion);
        deployOptions.setClientId(clientId);
        deployOptions.setJobId(jobId);
        deployOptions.setRequestClientId(requestClientId);
        deployOptions.setNotificationPublisherPid(notificationPid);
        deployOptions.setNotificationPublisher(notificationPublisher);
        this.installCompleteAsync(deployOptions, fileSystemFileName);
        Files.delete(fileEntry.toPath());
        logger.info("Publishing success notification for verifier {}...done", (Object)verificationFileName);
    }

    private void sendSysUpdateFailure(String verificationFileName, CloudNotificationPublisher notificationPublisher) throws IOException {
        logger.info("Publishing failure notification for verifier {}...", (Object)verificationFileName);
        File fileEntry = this.findPersistenceFileFromVerificationFile(verificationFileName);
        Properties downloadProperties = this.loadInstallPersistance(fileEntry);
        String deployUrl = downloadProperties.getProperty("dp.uri");
        String dpName = downloadProperties.getProperty("dp.name");
        String dpVersion = downloadProperties.getProperty("dp.version");
        String clientId = downloadProperties.getProperty("client.id");
        Long jobId = Long.valueOf(downloadProperties.getProperty("job.id"));
        String fileSystemFileName = downloadProperties.getProperty(PERSISTANCE_FILE_NAME);
        String requestClientId = downloadProperties.getProperty("requester.client.id");
        String notificationPid = downloadProperties.getProperty("publisherpid");
        DeploymentPackageDownloadOptions deployOptions = new DeploymentPackageDownloadOptions(deployUrl, dpName, dpVersion);
        deployOptions.setClientId(clientId);
        deployOptions.setJobId(jobId);
        deployOptions.setRequestClientId(requestClientId);
        deployOptions.setNotificationPublisherPid(notificationPid);
        deployOptions.setNotificationPublisher(notificationPublisher);
        this.installFailedAsync(deployOptions, fileSystemFileName, (Exception)((Object)new KuraException(KuraErrorCode.INTERNAL_ERROR)));
        Files.delete(fileEntry.toPath());
        logger.info("Publishing failure notification for verifier {}...done", (Object)verificationFileName);
    }

    private File findPersistenceFileFromVerificationFile(String verificationFileName) throws FileNotFoundException {
        String executableName = verificationFileName.split("_verifier")[0];
        File installDir = new File(this.installPersistanceDir);
        File[] fileArray = installDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File fileEntry = fileArray[n2];
            if (fileEntry.isFile() && fileEntry.getName().endsWith(PERSISTANCE_SUFFIX) && fileEntry.getName().contains(executableName)) {
                return fileEntry;
            }
            ++n2;
        }
        throw new FileNotFoundException("Cannot find persistance file for verification file " + verificationFileName);
    }

    private Properties loadInstallPersistance(File installedDpPersistance) {
        Properties downloadProperies = new Properties();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileReader fr = new FileReader(installedDpPersistance);){
                downloadProperies.load(fr);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.error("Exception loading install configuration file", (Throwable)e);
        }
        return downloadProperies;
    }

    public boolean isCorrectNotificationPublisher(String pid, String verificationFileName) {
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (Stream<Path> filesStream = Files.list(Paths.get(this.installPersistanceDir, new String[0]));){
                List availableFiles = filesStream.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(filePath -> {
                    boolean isPersistanceFile = filePath.toFile().getName().endsWith(PERSISTANCE_SUFFIX);
                    if (isPersistanceFile) {
                        Properties downloadProperties = this.loadInstallPersistance(filePath.toFile());
                        String notificationPid = downloadProperties.getProperty("publisherpid");
                        String executableFileName = downloadProperties.getProperty(PERSISTANCE_FILE_NAME);
                        if (pid.equals(notificationPid) && verificationFileName.contains(executableFileName)) {
                            return true;
                        }
                    }
                    return false;
                }).collect(Collectors.toList());
                boolean result = false;
                if (!availableFiles.isEmpty()) {
                    result = true;
                }
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            logger.info("Unable to parse persistance dir");
            return false;
        }
    }
}

