/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections.transports;

import java.io.IOException;
import java.util.Random;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.transports.AbstractTransport;
import org.freedesktop.dbus.connections.transports.TcpTransport;
import org.freedesktop.dbus.connections.transports.UnixSocketTransport;
import org.freedesktop.dbus.utils.Hexdump;
import org.slf4j.LoggerFactory;

public final class TransportFactory {
    private TransportFactory() {
    }

    public static AbstractTransport createTransport(BusAddress _address, int _timeout) throws IOException {
        AbstractTransport transport;
        LoggerFactory.getLogger(TransportFactory.class).debug("Connecting to {}", (Object)_address);
        if (_address.getBusType() == BusAddress.AddressBusTypes.UNIX) {
            transport = new UnixSocketTransport(_address);
        } else if (_address.getBusType() == BusAddress.AddressBusTypes.TCP) {
            transport = new TcpTransport(_address, _timeout);
        } else {
            throw new IOException("Unknown address type " + _address.getType());
        }
        ((AbstractTransport)transport).connect();
        return transport;
    }

    public static AbstractTransport createTransport(BusAddress _address) throws IOException {
        return TransportFactory.createTransport(_address, 10000);
    }

    public static String genGUID() {
        Random r = new Random();
        byte[] buf = new byte[16];
        r.nextBytes(buf);
        String guid = Hexdump.toHex(buf);
        return guid.replaceAll(" ", "");
    }
}

