/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.json.marshaller.unmarshaller.system;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import org.eclipse.kura.core.inventory.resources.SystemPackage;
import org.eclipse.kura.core.inventory.resources.SystemPackages;

public class JsonJavaSystemPackagesMapper {
    private static final String SYSTEM_PACKAGES = "systemPackages";
    private static final String SYSTEM_PACKAGES_PACKAGE_NAME = "name";
    private static final String SYSTEM_PACKAGES_PACKAGE_VERSION = "version";
    private static final String SYSTEM_PACKAGES_PACKAGE_TYPE = "type";

    private JsonJavaSystemPackagesMapper() {
    }

    public static String marshal(SystemPackages systemPackages) {
        JsonObject json = Json.object();
        JsonArray packages = new JsonArray();
        systemPackages.getSystemPackages().stream().forEach(p -> {
            JsonArray jsonArray2 = packages.add((JsonValue)JsonJavaSystemPackagesMapper.getJsonPackage(p));
        });
        json.add(SYSTEM_PACKAGES, (JsonValue)packages);
        return json.toString();
    }

    private static JsonObject getJsonPackage(SystemPackage p) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add(SYSTEM_PACKAGES_PACKAGE_NAME, p.getName());
        jsonObject.add(SYSTEM_PACKAGES_PACKAGE_VERSION, p.getVersion());
        jsonObject.add(SYSTEM_PACKAGES_PACKAGE_TYPE, p.getTypeString());
        return jsonObject;
    }
}

